/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.transform.CapacityJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.MapUnmarshaller;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class ConsumedCapacityJsonUnmarshaller
implements Unmarshaller<ConsumedCapacity, JsonUnmarshallerContext> {
    private static ConsumedCapacityJsonUnmarshaller instance;

    ConsumedCapacityJsonUnmarshaller() {
    }

    public ConsumedCapacity unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        ConsumedCapacity consumedCapacity = new ConsumedCapacity();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("TableName")) {
                consumedCapacity.setTableName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("CapacityUnits")) {
                consumedCapacity.setCapacityUnits(SimpleTypeJsonUnmarshallers.DoubleJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("Table")) {
                consumedCapacity.setTable(CapacityJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("LocalSecondaryIndexes")) {
                consumedCapacity.setLocalSecondaryIndexes(new MapUnmarshaller((Unmarshaller)CapacityJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            if (name.equals("GlobalSecondaryIndexes")) {
                consumedCapacity.setGlobalSecondaryIndexes(new MapUnmarshaller((Unmarshaller)CapacityJsonUnmarshaller.getInstance()).unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return consumedCapacity;
    }

    public static ConsumedCapacityJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConsumedCapacityJsonUnmarshaller();
        }
        return instance;
    }
}

