/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;
import java.util.Map;

class ItemCollectionMetricsJsonMarshaller {
    private static ItemCollectionMetricsJsonMarshaller instance;

    ItemCollectionMetricsJsonMarshaller() {
    }

    public void marshall(ItemCollectionMetrics itemCollectionMetrics, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (itemCollectionMetrics.getItemCollectionKey() != null) {
            Map<String, AttributeValue> itemCollectionKey = itemCollectionMetrics.getItemCollectionKey();
            jsonWriter.name("ItemCollectionKey");
            jsonWriter.beginObject();
            for (Map.Entry entry : itemCollectionKey.entrySet()) {
                AttributeValue itemCollectionKeyValue = (AttributeValue)entry.getValue();
                if (itemCollectionKeyValue == null) continue;
                jsonWriter.name((String)entry.getKey());
                AttributeValueJsonMarshaller.getInstance().marshall(itemCollectionKeyValue, jsonWriter);
            }
            jsonWriter.endObject();
        }
        if (itemCollectionMetrics.getSizeEstimateRangeGB() != null) {
            List<Double> sizeEstimateRangeGB = itemCollectionMetrics.getSizeEstimateRangeGB();
            jsonWriter.name("SizeEstimateRangeGB");
            jsonWriter.beginArray();
            for (Double d : sizeEstimateRangeGB) {
                if (d == null) continue;
                jsonWriter.value((Number)d);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public static ItemCollectionMetricsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ItemCollectionMetricsJsonMarshaller();
        }
        return instance;
    }
}

