/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.services.dynamodbv2.model.AutoScalingPolicyDescription;
import com.amazonaws.services.dynamodbv2.model.AutoScalingSettingsDescription;
import com.amazonaws.services.dynamodbv2.model.transform.AutoScalingPolicyDescriptionJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.List;

class AutoScalingSettingsDescriptionJsonMarshaller {
    private static AutoScalingSettingsDescriptionJsonMarshaller instance;

    AutoScalingSettingsDescriptionJsonMarshaller() {
    }

    public void marshall(AutoScalingSettingsDescription autoScalingSettingsDescription, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (autoScalingSettingsDescription.getMinimumUnits() != null) {
            Long minimumUnits = autoScalingSettingsDescription.getMinimumUnits();
            jsonWriter.name("MinimumUnits");
            jsonWriter.value((Number)minimumUnits);
        }
        if (autoScalingSettingsDescription.getMaximumUnits() != null) {
            Long maximumUnits = autoScalingSettingsDescription.getMaximumUnits();
            jsonWriter.name("MaximumUnits");
            jsonWriter.value((Number)maximumUnits);
        }
        if (autoScalingSettingsDescription.getAutoScalingDisabled() != null) {
            Boolean autoScalingDisabled = autoScalingSettingsDescription.getAutoScalingDisabled();
            jsonWriter.name("AutoScalingDisabled");
            jsonWriter.value(autoScalingDisabled.booleanValue());
        }
        if (autoScalingSettingsDescription.getAutoScalingRoleArn() != null) {
            String autoScalingRoleArn = autoScalingSettingsDescription.getAutoScalingRoleArn();
            jsonWriter.name("AutoScalingRoleArn");
            jsonWriter.value(autoScalingRoleArn);
        }
        if (autoScalingSettingsDescription.getScalingPolicies() != null) {
            List<AutoScalingPolicyDescription> scalingPolicies = autoScalingSettingsDescription.getScalingPolicies();
            jsonWriter.name("ScalingPolicies");
            jsonWriter.beginArray();
            for (AutoScalingPolicyDescription scalingPoliciesItem : scalingPolicies) {
                if (scalingPoliciesItem == null) continue;
                AutoScalingPolicyDescriptionJsonMarshaller.getInstance().marshall(scalingPoliciesItem, jsonWriter);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    public static AutoScalingSettingsDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AutoScalingSettingsDescriptionJsonMarshaller();
        }
        return instance;
    }
}

