/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.ListBackupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;

public class ListBackupsRequestMarshaller
implements Marshaller<Request<ListBackupsRequest>, ListBackupsRequest> {
    public Request<ListBackupsRequest> marshall(ListBackupsRequest listBackupsRequest) {
        if (listBackupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListBackupsRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listBackupsRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20120810.ListBackups";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listBackupsRequest.getTableName() != null) {
                String tableName = listBackupsRequest.getTableName();
                jsonWriter.name("TableName");
                jsonWriter.value(tableName);
            }
            if (listBackupsRequest.getLimit() != null) {
                Integer limit = listBackupsRequest.getLimit();
                jsonWriter.name("Limit");
                jsonWriter.value((Number)limit);
            }
            if (listBackupsRequest.getTimeRangeLowerBound() != null) {
                Date timeRangeLowerBound = listBackupsRequest.getTimeRangeLowerBound();
                jsonWriter.name("TimeRangeLowerBound");
                jsonWriter.value(timeRangeLowerBound);
            }
            if (listBackupsRequest.getTimeRangeUpperBound() != null) {
                Date timeRangeUpperBound = listBackupsRequest.getTimeRangeUpperBound();
                jsonWriter.name("TimeRangeUpperBound");
                jsonWriter.value(timeRangeUpperBound);
            }
            if (listBackupsRequest.getExclusiveStartBackupArn() != null) {
                String exclusiveStartBackupArn = listBackupsRequest.getExclusiveStartBackupArn();
                jsonWriter.name("ExclusiveStartBackupArn");
                jsonWriter.value(exclusiveStartBackupArn);
            }
            if (listBackupsRequest.getBackupType() != null) {
                String backupType = listBackupsRequest.getBackupType();
                jsonWriter.name("BackupType");
                jsonWriter.value(backupType);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        return request;
    }
}

