/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Map;

public class UpdateItemRequestMarshaller
implements Marshaller<Request<UpdateItemRequest>, UpdateItemRequest> {
    public Request<UpdateItemRequest> marshall(UpdateItemRequest updateItemRequest) {
        if (updateItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateItemRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.UpdateItem";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag bSList;
            ListWithAutoConstructFlag nSList;
            ListWithAutoConstructFlag sSList;
            AttributeValue value;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)updateItemRequest.getTableName());
            }
            if (updateItemRequest.getKey() != null) {
                jsonWriter.key("Key");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : updateItemRequest.getKey().entrySet()) {
                    ListWithAutoConstructFlag bSList2;
                    ListWithAutoConstructFlag nSList2;
                    ListWithAutoConstructFlag sSList2;
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    if (((AttributeValue)entry.getValue()).getS() != null) {
                        jsonWriter.key("S").value((Object)((AttributeValue)entry.getValue()).getS());
                    }
                    if (((AttributeValue)entry.getValue()).getN() != null) {
                        jsonWriter.key("N").value((Object)((AttributeValue)entry.getValue()).getN());
                    }
                    if (((AttributeValue)entry.getValue()).getB() != null) {
                        jsonWriter.key("B").value(((AttributeValue)entry.getValue()).getB());
                    }
                    if (!((sSList2 = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getSS()) == null || sSList2.isAutoConstruct() && sSList2.isEmpty())) {
                        jsonWriter.key("SS");
                        jsonWriter.array();
                        for (String sSListValue : sSList2) {
                            if (sSListValue == null) continue;
                            jsonWriter.value((Object)sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((nSList2 = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getNS()) == null || nSList2.isAutoConstruct() && nSList2.isEmpty())) {
                        jsonWriter.key("NS");
                        jsonWriter.array();
                        for (String nSListValue : nSList2) {
                            if (nSListValue == null) continue;
                            jsonWriter.value((Object)nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (!((bSList2 = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getBS()) == null || bSList2.isAutoConstruct() && bSList2.isEmpty())) {
                        jsonWriter.key("BS");
                        jsonWriter.array();
                        for (ByteBuffer bSListValue : bSList2) {
                            if (bSListValue == null) continue;
                            jsonWriter.value(bSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getAttributeUpdates() != null) {
                jsonWriter.key("AttributeUpdates");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : updateItemRequest.getAttributeUpdates().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    value = ((AttributeValueUpdate)entry.getValue()).getValue();
                    if (value != null) {
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value((Object)value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value((Object)value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (String sSListValue : sSList) {
                                if (sSListValue == null) continue;
                                jsonWriter.value((Object)sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            for (String nSListValue : nSList) {
                                if (nSListValue == null) continue;
                                jsonWriter.value((Object)nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (((AttributeValueUpdate)entry.getValue()).getAction() != null) {
                        jsonWriter.key("Action").value((Object)((AttributeValueUpdate)entry.getValue()).getAction());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getExpected() != null) {
                jsonWriter.key("Expected");
                jsonWriter.object();
                for (Map.Entry<String, Serializable> entry : updateItemRequest.getExpected().entrySet()) {
                    ListWithAutoConstructFlag attributeValueListList;
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    value = ((ExpectedAttributeValue)entry.getValue()).getValue();
                    if (value != null) {
                        jsonWriter.key("Value");
                        jsonWriter.object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value((Object)value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value((Object)value.getN());
                        }
                        if (value.getB() != null) {
                            jsonWriter.key("B").value(value.getB());
                        }
                        if (!((sSList = (ListWithAutoConstructFlag)value.getSS()) == null || sSList.isAutoConstruct() && sSList.isEmpty())) {
                            jsonWriter.key("SS");
                            jsonWriter.array();
                            for (String sSListValue : sSList) {
                                if (sSListValue == null) continue;
                                jsonWriter.value((Object)sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((nSList = (ListWithAutoConstructFlag)value.getNS()) == null || nSList.isAutoConstruct() && nSList.isEmpty())) {
                            jsonWriter.key("NS");
                            jsonWriter.array();
                            for (String nSListValue : nSList) {
                                if (nSListValue == null) continue;
                                jsonWriter.value((Object)nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if (!((bSList = (ListWithAutoConstructFlag)value.getBS()) == null || bSList.isAutoConstruct() && bSList.isEmpty())) {
                            jsonWriter.key("BS");
                            jsonWriter.array();
                            for (ByteBuffer bSListValue : bSList) {
                                if (bSListValue == null) continue;
                                jsonWriter.value(bSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).isExists() != null) {
                        jsonWriter.key("Exists").value((Object)((ExpectedAttributeValue)entry.getValue()).isExists());
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).getComparisonOperator() != null) {
                        jsonWriter.key("ComparisonOperator").value((Object)((ExpectedAttributeValue)entry.getValue()).getComparisonOperator());
                    }
                    if (!((attributeValueListList = (ListWithAutoConstructFlag)((ExpectedAttributeValue)entry.getValue()).getAttributeValueList()) == null || attributeValueListList.isAutoConstruct() && attributeValueListList.isEmpty())) {
                        jsonWriter.key("AttributeValueList");
                        jsonWriter.array();
                        for (AttributeValue attributeValueListListValue : attributeValueListList) {
                            ListWithAutoConstructFlag bSList3;
                            ListWithAutoConstructFlag nSList3;
                            ListWithAutoConstructFlag sSList3;
                            if (attributeValueListListValue == null) continue;
                            jsonWriter.object();
                            if (attributeValueListListValue.getS() != null) {
                                jsonWriter.key("S").value((Object)attributeValueListListValue.getS());
                            }
                            if (attributeValueListListValue.getN() != null) {
                                jsonWriter.key("N").value((Object)attributeValueListListValue.getN());
                            }
                            if (attributeValueListListValue.getB() != null) {
                                jsonWriter.key("B").value(attributeValueListListValue.getB());
                            }
                            if (!((sSList3 = (ListWithAutoConstructFlag)attributeValueListListValue.getSS()) == null || sSList3.isAutoConstruct() && sSList3.isEmpty())) {
                                jsonWriter.key("SS");
                                jsonWriter.array();
                                for (String sSListValue : sSList3) {
                                    if (sSListValue == null) continue;
                                    jsonWriter.value((Object)sSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if (!((nSList3 = (ListWithAutoConstructFlag)attributeValueListListValue.getNS()) == null || nSList3.isAutoConstruct() && nSList3.isEmpty())) {
                                jsonWriter.key("NS");
                                jsonWriter.array();
                                for (String nSListValue : nSList3) {
                                    if (nSListValue == null) continue;
                                    jsonWriter.value((Object)nSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            if (!((bSList3 = (ListWithAutoConstructFlag)attributeValueListListValue.getBS()) == null || bSList3.isAutoConstruct() && bSList3.isEmpty())) {
                                jsonWriter.key("BS");
                                jsonWriter.array();
                                for (ByteBuffer bSListValue : bSList3) {
                                    if (bSListValue == null) continue;
                                    jsonWriter.value(bSListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getConditionalOperator() != null) {
                jsonWriter.key("ConditionalOperator").value((Object)updateItemRequest.getConditionalOperator());
            }
            if (updateItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value((Object)updateItemRequest.getReturnValues());
            }
            if (updateItemRequest.getReturnConsumedCapacity() != null) {
                jsonWriter.key("ReturnConsumedCapacity").value((Object)updateItemRequest.getReturnConsumedCapacity());
            }
            if (updateItemRequest.getReturnItemCollectionMetrics() != null) {
                jsonWriter.key("ReturnItemCollectionMetrics").value((Object)updateItemRequest.getReturnItemCollectionMetrics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

