/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class BatchWriteItemRequestMarshaller
implements Marshaller<Request<BatchWriteItemRequest>, BatchWriteItemRequest> {
    public Request<BatchWriteItemRequest> marshall(BatchWriteItemRequest batchWriteItemRequest) {
        if (batchWriteItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)batchWriteItemRequest, "AmazonDynamoDBv2");
        String string = "DynamoDB_20120810.BatchWriteItem";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.POST);
        defaultRequest.setResourcePath("");
        try {
            Object object;
            Object object2;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jSONWriter = new JSONWriter((Writer)stringWriter);
            jSONWriter.object();
            if (batchWriteItemRequest.getRequestItems() != null) {
                jSONWriter.key("RequestItems");
                jSONWriter.object();
                object2 = batchWriteItemRequest.getRequestItems().entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    if (object.getValue() == null) continue;
                    jSONWriter.key((String)object.getKey());
                    jSONWriter.array();
                    for (WriteRequest writeRequest : (List)object.getValue()) {
                        Object object3;
                        Object object4;
                        Object object5;
                        Object object6;
                        Object object7;
                        if (writeRequest == null) continue;
                        jSONWriter.object();
                        PutRequest putRequest = writeRequest.getPutRequest();
                        if (putRequest != null) {
                            jSONWriter.key("PutRequest");
                            jSONWriter.object();
                            if (putRequest.getItem() != null) {
                                jSONWriter.key("Item");
                                jSONWriter.object();
                                object7 = putRequest.getItem().entrySet().iterator();
                                while (object7.hasNext()) {
                                    ListWithAutoConstructFlag listWithAutoConstructFlag;
                                    Map.Entry entry2 = (Map.Entry)object7.next();
                                    if (entry2.getValue() == null) continue;
                                    jSONWriter.key((String)entry2.getKey());
                                    jSONWriter.object();
                                    if (((AttributeValue)entry2.getValue()).getS() != null) {
                                        jSONWriter.key("S").value((Object)((AttributeValue)entry2.getValue()).getS());
                                    }
                                    if (((AttributeValue)entry2.getValue()).getN() != null) {
                                        jSONWriter.key("N").value((Object)((AttributeValue)entry2.getValue()).getN());
                                    }
                                    if (((AttributeValue)entry2.getValue()).getB() != null) {
                                        jSONWriter.key("B").value(((AttributeValue)entry2.getValue()).getB());
                                    }
                                    if (!((listWithAutoConstructFlag = (ListWithAutoConstructFlag)((AttributeValue)entry2.getValue()).getSS()) == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                                        jSONWriter.key("SS");
                                        jSONWriter.array();
                                        object6 = listWithAutoConstructFlag.iterator();
                                        while (object6.hasNext()) {
                                            object5 = (String)object6.next();
                                            if (object5 == null) continue;
                                            jSONWriter.value(object5);
                                        }
                                        jSONWriter.endArray();
                                    }
                                    if (!((object6 = (ListWithAutoConstructFlag)((AttributeValue)entry2.getValue()).getNS()) == null || object6.isAutoConstruct() && object6.isEmpty())) {
                                        jSONWriter.key("NS");
                                        jSONWriter.array();
                                        object5 = object6.iterator();
                                        while (object5.hasNext()) {
                                            object4 = (String)object5.next();
                                            if (object4 == null) continue;
                                            jSONWriter.value(object4);
                                        }
                                        jSONWriter.endArray();
                                    }
                                    if (!((object5 = (ListWithAutoConstructFlag)((AttributeValue)entry2.getValue()).getBS()) == null || object5.isAutoConstruct() && object5.isEmpty())) {
                                        jSONWriter.key("BS");
                                        jSONWriter.array();
                                        object4 = object5.iterator();
                                        while (object4.hasNext()) {
                                            object3 = (ByteBuffer)object4.next();
                                            if (object3 == null) continue;
                                            jSONWriter.value((ByteBuffer)object3);
                                        }
                                        jSONWriter.endArray();
                                    }
                                    jSONWriter.endObject();
                                }
                                jSONWriter.endObject();
                            }
                            jSONWriter.endObject();
                        }
                        if ((object7 = writeRequest.getDeleteRequest()) != null) {
                            jSONWriter.key("DeleteRequest");
                            jSONWriter.object();
                            if (((DeleteRequest)object7).getKey() != null) {
                                jSONWriter.key("Key");
                                jSONWriter.object();
                                for (Map.Entry entry : ((DeleteRequest)object7).getKey().entrySet()) {
                                    if (entry.getValue() == null) continue;
                                    jSONWriter.key((String)entry.getKey());
                                    jSONWriter.object();
                                    if (((AttributeValue)entry.getValue()).getS() != null) {
                                        jSONWriter.key("S").value((Object)((AttributeValue)entry.getValue()).getS());
                                    }
                                    if (((AttributeValue)entry.getValue()).getN() != null) {
                                        jSONWriter.key("N").value((Object)((AttributeValue)entry.getValue()).getN());
                                    }
                                    if (((AttributeValue)entry.getValue()).getB() != null) {
                                        jSONWriter.key("B").value(((AttributeValue)entry.getValue()).getB());
                                    }
                                    if (!((object6 = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getSS()) == null || object6.isAutoConstruct() && object6.isEmpty())) {
                                        jSONWriter.key("SS");
                                        jSONWriter.array();
                                        object5 = object6.iterator();
                                        while (object5.hasNext()) {
                                            object4 = (String)object5.next();
                                            if (object4 == null) continue;
                                            jSONWriter.value(object4);
                                        }
                                        jSONWriter.endArray();
                                    }
                                    if (!((object5 = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getNS()) == null || object5.isAutoConstruct() && object5.isEmpty())) {
                                        jSONWriter.key("NS");
                                        jSONWriter.array();
                                        object4 = object5.iterator();
                                        while (object4.hasNext()) {
                                            object3 = (String)object4.next();
                                            if (object3 == null) continue;
                                            jSONWriter.value(object3);
                                        }
                                        jSONWriter.endArray();
                                    }
                                    if (!((object4 = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getBS()) == null || object4.isAutoConstruct() && object4.isEmpty())) {
                                        jSONWriter.key("BS");
                                        jSONWriter.array();
                                        object3 = object4.iterator();
                                        while (object3.hasNext()) {
                                            ByteBuffer byteBuffer = (ByteBuffer)object3.next();
                                            if (byteBuffer == null) continue;
                                            jSONWriter.value(byteBuffer);
                                        }
                                        jSONWriter.endArray();
                                    }
                                    jSONWriter.endObject();
                                }
                                jSONWriter.endObject();
                            }
                            jSONWriter.endObject();
                        }
                        jSONWriter.endObject();
                    }
                    jSONWriter.endArray();
                }
                jSONWriter.endObject();
            }
            if (batchWriteItemRequest.getReturnConsumedCapacity() != null) {
                jSONWriter.key("ReturnConsumedCapacity").value((Object)batchWriteItemRequest.getReturnConsumedCapacity());
            }
            if (batchWriteItemRequest.getReturnItemCollectionMetrics() != null) {
                jSONWriter.key("ReturnItemCollectionMetrics").value((Object)batchWriteItemRequest.getReturnItemCollectionMetrics());
            }
            jSONWriter.endObject();
            object2 = stringWriter.toString();
            object = ((String)object2).getBytes(StringUtils.UTF8);
            defaultRequest.setContent((InputStream)new StringInputStream((String)object2));
            defaultRequest.addHeader("Content-Length", Integer.toString(((Object)object).length));
            defaultRequest.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable throwable) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + throwable.getMessage(), throwable);
        }
        return defaultRequest;
    }
}

