/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateItemRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private Map<String, AttributeValue> key;
    private Map<String, AttributeValueUpdate> attributeUpdates;
    private Map<String, ExpectedAttributeValue> expected;
    private String conditionalOperator;
    private String returnValues;
    private String returnConsumedCapacity;
    private String returnItemCollectionMetrics;

    public UpdateItemRequest() {
    }

    public UpdateItemRequest(String string, Map<String, AttributeValue> map, Map<String, AttributeValueUpdate> map2) {
        this.setTableName(string);
        this.setKey(map);
        this.setAttributeUpdates(map2);
    }

    public UpdateItemRequest(String string, Map<String, AttributeValue> map, Map<String, AttributeValueUpdate> map2, String string2) {
        this.setTableName(string);
        this.setKey(map);
        this.setAttributeUpdates(map2);
        this.setReturnValues(string2);
    }

    public UpdateItemRequest(String string, Map<String, AttributeValue> map, Map<String, AttributeValueUpdate> map2, ReturnValue returnValue) {
        this.tableName = string;
        this.key = map;
        this.attributeUpdates = map2;
        this.returnValues = returnValue.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public UpdateItemRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public Map<String, AttributeValue> getKey() {
        return this.key;
    }

    public void setKey(Map<String, AttributeValue> map) {
        this.key = map;
    }

    public UpdateItemRequest withKey(Map<String, AttributeValue> map) {
        this.setKey(map);
        return this;
    }

    public void setKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        HashMap<String, AttributeValue> hashMap = new HashMap<String, AttributeValue>();
        if (entry == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        hashMap.put(entry.getKey(), entry.getValue());
        if (entry2 != null) {
            hashMap.put(entry2.getKey(), entry2.getValue());
        }
        this.setKey(hashMap);
    }

    public UpdateItemRequest withKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        this.setKey(entry, entry2);
        return this;
    }

    public UpdateItemRequest addKeyEntry(String string, AttributeValue attributeValue) {
        if (null == this.key) {
            this.key = new HashMap<String, AttributeValue>();
        }
        if (this.key.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.key.put(string, attributeValue);
        return this;
    }

    public UpdateItemRequest clearKeyEntries() {
        this.key = null;
        return this;
    }

    public Map<String, AttributeValueUpdate> getAttributeUpdates() {
        return this.attributeUpdates;
    }

    public void setAttributeUpdates(Map<String, AttributeValueUpdate> map) {
        this.attributeUpdates = map;
    }

    public UpdateItemRequest withAttributeUpdates(Map<String, AttributeValueUpdate> map) {
        this.setAttributeUpdates(map);
        return this;
    }

    public UpdateItemRequest addAttributeUpdatesEntry(String string, AttributeValueUpdate attributeValueUpdate) {
        if (null == this.attributeUpdates) {
            this.attributeUpdates = new HashMap<String, AttributeValueUpdate>();
        }
        if (this.attributeUpdates.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.attributeUpdates.put(string, attributeValueUpdate);
        return this;
    }

    public UpdateItemRequest clearAttributeUpdatesEntries() {
        this.attributeUpdates = null;
        return this;
    }

    public Map<String, ExpectedAttributeValue> getExpected() {
        return this.expected;
    }

    public void setExpected(Map<String, ExpectedAttributeValue> map) {
        this.expected = map;
    }

    public UpdateItemRequest withExpected(Map<String, ExpectedAttributeValue> map) {
        this.setExpected(map);
        return this;
    }

    public UpdateItemRequest addExpectedEntry(String string, ExpectedAttributeValue expectedAttributeValue) {
        if (null == this.expected) {
            this.expected = new HashMap<String, ExpectedAttributeValue>();
        }
        if (this.expected.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.expected.put(string, expectedAttributeValue);
        return this;
    }

    public UpdateItemRequest clearExpectedEntries() {
        this.expected = null;
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String string) {
        this.conditionalOperator = string;
    }

    public UpdateItemRequest withConditionalOperator(String string) {
        this.conditionalOperator = string;
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
    }

    public UpdateItemRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public String getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(String string) {
        this.returnValues = string;
    }

    public UpdateItemRequest withReturnValues(String string) {
        this.returnValues = string;
        return this;
    }

    public void setReturnValues(ReturnValue returnValue) {
        this.returnValues = returnValue.toString();
    }

    public UpdateItemRequest withReturnValues(ReturnValue returnValue) {
        this.returnValues = returnValue.toString();
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public UpdateItemRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public UpdateItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return this.returnItemCollectionMetrics;
    }

    public void setReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
    }

    public UpdateItemRequest withReturnItemCollectionMetrics(String string) {
        this.returnItemCollectionMetrics = string;
        return this;
    }

    public void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
    }

    public UpdateItemRequest withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        this.returnItemCollectionMetrics = returnItemCollectionMetrics.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getKey() != null) {
            stringBuilder.append("Key: " + this.getKey() + ",");
        }
        if (this.getAttributeUpdates() != null) {
            stringBuilder.append("AttributeUpdates: " + this.getAttributeUpdates() + ",");
        }
        if (this.getExpected() != null) {
            stringBuilder.append("Expected: " + this.getExpected() + ",");
        }
        if (this.getConditionalOperator() != null) {
            stringBuilder.append("ConditionalOperator: " + this.getConditionalOperator() + ",");
        }
        if (this.getReturnValues() != null) {
            stringBuilder.append("ReturnValues: " + this.getReturnValues() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity() + ",");
        }
        if (this.getReturnItemCollectionMetrics() != null) {
            stringBuilder.append("ReturnItemCollectionMetrics: " + this.getReturnItemCollectionMetrics());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getKey() == null ? 0 : ((Object)this.getKey()).hashCode());
        n = 31 * n + (this.getAttributeUpdates() == null ? 0 : ((Object)this.getAttributeUpdates()).hashCode());
        n = 31 * n + (this.getExpected() == null ? 0 : ((Object)this.getExpected()).hashCode());
        n = 31 * n + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        n = 31 * n + (this.getReturnValues() == null ? 0 : this.getReturnValues().hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        n = 31 * n + (this.getReturnItemCollectionMetrics() == null ? 0 : this.getReturnItemCollectionMetrics().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof UpdateItemRequest)) {
            return false;
        }
        UpdateItemRequest updateItemRequest = (UpdateItemRequest)object;
        if (updateItemRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (updateItemRequest.getTableName() != null && !updateItemRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (updateItemRequest.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (updateItemRequest.getKey() != null && !((Object)updateItemRequest.getKey()).equals(this.getKey())) {
            return false;
        }
        if (updateItemRequest.getAttributeUpdates() == null ^ this.getAttributeUpdates() == null) {
            return false;
        }
        if (updateItemRequest.getAttributeUpdates() != null && !((Object)updateItemRequest.getAttributeUpdates()).equals(this.getAttributeUpdates())) {
            return false;
        }
        if (updateItemRequest.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        if (updateItemRequest.getExpected() != null && !((Object)updateItemRequest.getExpected()).equals(this.getExpected())) {
            return false;
        }
        if (updateItemRequest.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        if (updateItemRequest.getConditionalOperator() != null && !updateItemRequest.getConditionalOperator().equals(this.getConditionalOperator())) {
            return false;
        }
        if (updateItemRequest.getReturnValues() == null ^ this.getReturnValues() == null) {
            return false;
        }
        if (updateItemRequest.getReturnValues() != null && !updateItemRequest.getReturnValues().equals(this.getReturnValues())) {
            return false;
        }
        if (updateItemRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (updateItemRequest.getReturnConsumedCapacity() != null && !updateItemRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (updateItemRequest.getReturnItemCollectionMetrics() == null ^ this.getReturnItemCollectionMetrics() == null) {
            return false;
        }
        return updateItemRequest.getReturnItemCollectionMetrics() == null || updateItemRequest.getReturnItemCollectionMetrics().equals(this.getReturnItemCollectionMetrics());
    }
}

