/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.IndexStatus;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GlobalSecondaryIndexDescription
implements Serializable {
    private String indexName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private Projection projection;
    private String indexStatus;
    private ProvisionedThroughputDescription provisionedThroughput;
    private Long indexSizeBytes;
    private Long itemCount;

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public GlobalSecondaryIndexDescription withIndexName(String string) {
        this.indexName = string;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.keySchema = listWithAutoConstructFlag;
    }

    public GlobalSecondaryIndexDescription withKeySchema(KeySchemaElement ... keySchemaElementArray) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchemaElementArray.length));
        }
        for (KeySchemaElement keySchemaElement : keySchemaElementArray) {
            this.getKeySchema().add(keySchemaElement);
        }
        return this;
    }

    public GlobalSecondaryIndexDescription withKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.keySchema = listWithAutoConstructFlag;
        }
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public GlobalSecondaryIndexDescription withProjection(Projection projection) {
        this.projection = projection;
        return this;
    }

    public String getIndexStatus() {
        return this.indexStatus;
    }

    public void setIndexStatus(String string) {
        this.indexStatus = string;
    }

    public GlobalSecondaryIndexDescription withIndexStatus(String string) {
        this.indexStatus = string;
        return this;
    }

    public void setIndexStatus(IndexStatus indexStatus) {
        this.indexStatus = indexStatus.toString();
    }

    public GlobalSecondaryIndexDescription withIndexStatus(IndexStatus indexStatus) {
        this.indexStatus = indexStatus.toString();
        return this;
    }

    public ProvisionedThroughputDescription getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughputDescription) {
        this.provisionedThroughput = provisionedThroughputDescription;
    }

    public GlobalSecondaryIndexDescription withProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughputDescription) {
        this.provisionedThroughput = provisionedThroughputDescription;
        return this;
    }

    public Long getIndexSizeBytes() {
        return this.indexSizeBytes;
    }

    public void setIndexSizeBytes(Long l) {
        this.indexSizeBytes = l;
    }

    public GlobalSecondaryIndexDescription withIndexSizeBytes(Long l) {
        this.indexSizeBytes = l;
        return this;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(Long l) {
        this.itemCount = l;
    }

    public GlobalSecondaryIndexDescription withItemCount(Long l) {
        this.itemCount = l;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIndexName() != null) {
            stringBuilder.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getKeySchema() != null) {
            stringBuilder.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getProjection() != null) {
            stringBuilder.append("Projection: " + this.getProjection() + ",");
        }
        if (this.getIndexStatus() != null) {
            stringBuilder.append("IndexStatus: " + this.getIndexStatus() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            stringBuilder.append("ProvisionedThroughput: " + this.getProvisionedThroughput() + ",");
        }
        if (this.getIndexSizeBytes() != null) {
            stringBuilder.append("IndexSizeBytes: " + this.getIndexSizeBytes() + ",");
        }
        if (this.getItemCount() != null) {
            stringBuilder.append("ItemCount: " + this.getItemCount());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        n = 31 * n + (this.getKeySchema() == null ? 0 : ((Object)this.getKeySchema()).hashCode());
        n = 31 * n + (this.getProjection() == null ? 0 : this.getProjection().hashCode());
        n = 31 * n + (this.getIndexStatus() == null ? 0 : this.getIndexStatus().hashCode());
        n = 31 * n + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        n = 31 * n + (this.getIndexSizeBytes() == null ? 0 : this.getIndexSizeBytes().hashCode());
        n = 31 * n + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GlobalSecondaryIndexDescription)) {
            return false;
        }
        GlobalSecondaryIndexDescription globalSecondaryIndexDescription = (GlobalSecondaryIndexDescription)object;
        if (globalSecondaryIndexDescription.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (globalSecondaryIndexDescription.getIndexName() != null && !globalSecondaryIndexDescription.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (globalSecondaryIndexDescription.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (globalSecondaryIndexDescription.getKeySchema() != null && !((Object)globalSecondaryIndexDescription.getKeySchema()).equals(this.getKeySchema())) {
            return false;
        }
        if (globalSecondaryIndexDescription.getProjection() == null ^ this.getProjection() == null) {
            return false;
        }
        if (globalSecondaryIndexDescription.getProjection() != null && !globalSecondaryIndexDescription.getProjection().equals(this.getProjection())) {
            return false;
        }
        if (globalSecondaryIndexDescription.getIndexStatus() == null ^ this.getIndexStatus() == null) {
            return false;
        }
        if (globalSecondaryIndexDescription.getIndexStatus() != null && !globalSecondaryIndexDescription.getIndexStatus().equals(this.getIndexStatus())) {
            return false;
        }
        if (globalSecondaryIndexDescription.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (globalSecondaryIndexDescription.getProvisionedThroughput() != null && !globalSecondaryIndexDescription.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (globalSecondaryIndexDescription.getIndexSizeBytes() == null ^ this.getIndexSizeBytes() == null) {
            return false;
        }
        if (globalSecondaryIndexDescription.getIndexSizeBytes() != null && !globalSecondaryIndexDescription.getIndexSizeBytes().equals(this.getIndexSizeBytes())) {
            return false;
        }
        if (globalSecondaryIndexDescription.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        return globalSecondaryIndexDescription.getItemCount() == null || globalSecondaryIndexDescription.getItemCount().equals(this.getItemCount());
    }
}

