/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public class ScanRequestMarshaller
implements Marshaller<Request<ScanRequest>, ScanRequest> {
    public Request<ScanRequest> marshall(ScanRequest scanRequest) {
        if (scanRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)scanRequest, "AmazonDynamoDBv2");
        String string = "DynamoDB_20120810.Scan";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.POST);
        defaultRequest.setResourcePath("");
        try {
            Object object;
            Object object2;
            Object object3;
            Iterator iterator;
            ListWithAutoConstructFlag listWithAutoConstructFlag;
            ListWithAutoConstructFlag listWithAutoConstructFlag2;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jSONWriter = new JSONWriter((Writer)stringWriter);
            jSONWriter.object();
            if (scanRequest.getTableName() != null) {
                jSONWriter.key("TableName").value((Object)scanRequest.getTableName());
            }
            if (!((listWithAutoConstructFlag2 = (ListWithAutoConstructFlag)scanRequest.getAttributesToGet()) == null || listWithAutoConstructFlag2.isAutoConstruct() && listWithAutoConstructFlag2.isEmpty())) {
                jSONWriter.key("AttributesToGet");
                jSONWriter.array();
                for (String entry2 : listWithAutoConstructFlag2) {
                    if (entry2 == null) continue;
                    jSONWriter.value((Object)entry2);
                }
                jSONWriter.endArray();
            }
            if (scanRequest.getLimit() != null) {
                jSONWriter.key("Limit").value((Object)scanRequest.getLimit());
            }
            if (scanRequest.getSelect() != null) {
                jSONWriter.key("Select").value((Object)scanRequest.getSelect());
            }
            if (scanRequest.getScanFilter() != null) {
                jSONWriter.key("ScanFilter");
                jSONWriter.object();
                for (Map.Entry<String, Condition> entry : scanRequest.getScanFilter().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jSONWriter.key(entry.getKey());
                    jSONWriter.object();
                    listWithAutoConstructFlag = (ListWithAutoConstructFlag)entry.getValue().getAttributeValueList();
                    if (!(listWithAutoConstructFlag == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                        jSONWriter.key("AttributeValueList");
                        jSONWriter.array();
                        iterator = listWithAutoConstructFlag.iterator();
                        while (iterator.hasNext()) {
                            Object object4;
                            Object object5;
                            object3 = (AttributeValue)iterator.next();
                            if (object3 == null) continue;
                            jSONWriter.object();
                            if (((AttributeValue)object3).getS() != null) {
                                jSONWriter.key("S").value((Object)((AttributeValue)object3).getS());
                            }
                            if (((AttributeValue)object3).getN() != null) {
                                jSONWriter.key("N").value((Object)((AttributeValue)object3).getN());
                            }
                            if (((AttributeValue)object3).getB() != null) {
                                jSONWriter.key("B").value(((AttributeValue)object3).getB());
                            }
                            if (!((object2 = (ListWithAutoConstructFlag)((AttributeValue)object3).getSS()) == null || object2.isAutoConstruct() && object2.isEmpty())) {
                                jSONWriter.key("SS");
                                jSONWriter.array();
                                object = object2.iterator();
                                while (object.hasNext()) {
                                    object5 = (String)object.next();
                                    if (object5 == null) continue;
                                    jSONWriter.value(object5);
                                }
                                jSONWriter.endArray();
                            }
                            if (!((object = (ListWithAutoConstructFlag)((AttributeValue)object3).getNS()) == null || object.isAutoConstruct() && object.isEmpty())) {
                                jSONWriter.key("NS");
                                jSONWriter.array();
                                object5 = object.iterator();
                                while (object5.hasNext()) {
                                    object4 = (String)object5.next();
                                    if (object4 == null) continue;
                                    jSONWriter.value(object4);
                                }
                                jSONWriter.endArray();
                            }
                            if (!((object5 = (ListWithAutoConstructFlag)((AttributeValue)object3).getBS()) == null || object5.isAutoConstruct() && object5.isEmpty())) {
                                jSONWriter.key("BS");
                                jSONWriter.array();
                                object4 = object5.iterator();
                                while (object4.hasNext()) {
                                    ByteBuffer byteBuffer = (ByteBuffer)object4.next();
                                    if (byteBuffer == null) continue;
                                    jSONWriter.value(byteBuffer);
                                }
                                jSONWriter.endArray();
                            }
                            jSONWriter.endObject();
                        }
                        jSONWriter.endArray();
                    }
                    if (entry.getValue().getComparisonOperator() != null) {
                        jSONWriter.key("ComparisonOperator").value((Object)entry.getValue().getComparisonOperator());
                    }
                    jSONWriter.endObject();
                }
                jSONWriter.endObject();
            }
            if (scanRequest.getConditionalOperator() != null) {
                jSONWriter.key("ConditionalOperator").value((Object)scanRequest.getConditionalOperator());
            }
            if (scanRequest.getExclusiveStartKey() != null) {
                jSONWriter.key("ExclusiveStartKey");
                jSONWriter.object();
                for (Map.Entry entry : scanRequest.getExclusiveStartKey().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jSONWriter.key((String)entry.getKey());
                    jSONWriter.object();
                    if (((AttributeValue)entry.getValue()).getS() != null) {
                        jSONWriter.key("S").value((Object)((AttributeValue)entry.getValue()).getS());
                    }
                    if (((AttributeValue)entry.getValue()).getN() != null) {
                        jSONWriter.key("N").value((Object)((AttributeValue)entry.getValue()).getN());
                    }
                    if (((AttributeValue)entry.getValue()).getB() != null) {
                        jSONWriter.key("B").value(((AttributeValue)entry.getValue()).getB());
                    }
                    if (!((listWithAutoConstructFlag = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getSS()) == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                        jSONWriter.key("SS");
                        jSONWriter.array();
                        iterator = listWithAutoConstructFlag.iterator();
                        while (iterator.hasNext()) {
                            object3 = (String)iterator.next();
                            if (object3 == null) continue;
                            jSONWriter.value(object3);
                        }
                        jSONWriter.endArray();
                    }
                    if (!((iterator = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getNS()) == null || iterator.isAutoConstruct() && iterator.isEmpty())) {
                        jSONWriter.key("NS");
                        jSONWriter.array();
                        object3 = iterator.iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            if (object2 == null) continue;
                            jSONWriter.value(object2);
                        }
                        jSONWriter.endArray();
                    }
                    if (!((object3 = (ListWithAutoConstructFlag)((AttributeValue)entry.getValue()).getBS()) == null || object3.isAutoConstruct() && object3.isEmpty())) {
                        jSONWriter.key("BS");
                        jSONWriter.array();
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (ByteBuffer)object2.next();
                            if (object == null) continue;
                            jSONWriter.value((ByteBuffer)object);
                        }
                        jSONWriter.endArray();
                    }
                    jSONWriter.endObject();
                }
                jSONWriter.endObject();
            }
            if (scanRequest.getReturnConsumedCapacity() != null) {
                jSONWriter.key("ReturnConsumedCapacity").value((Object)scanRequest.getReturnConsumedCapacity());
            }
            if (scanRequest.getTotalSegments() != null) {
                jSONWriter.key("TotalSegments").value((Object)scanRequest.getTotalSegments());
            }
            if (scanRequest.getSegment() != null) {
                jSONWriter.key("Segment").value((Object)scanRequest.getSegment());
            }
            jSONWriter.endObject();
            String string2 = stringWriter.toString();
            byte[] byArray = string2.getBytes(StringUtils.UTF8);
            defaultRequest.setContent((InputStream)new StringInputStream(string2));
            defaultRequest.addHeader("Content-Length", Integer.toString(byArray.length));
            defaultRequest.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable throwable) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + throwable.getMessage(), throwable);
        }
        return defaultRequest;
    }
}

