/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TableDescription
implements Serializable {
    private ListWithAutoConstructFlag<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private String tableStatus;
    private Date creationDateTime;
    private ProvisionedThroughputDescription provisionedThroughput;
    private Long tableSizeBytes;
    private Long itemCount;
    private ListWithAutoConstructFlag<LocalSecondaryIndexDescription> localSecondaryIndexes;
    private ListWithAutoConstructFlag<GlobalSecondaryIndexDescription> globalSecondaryIndexes;

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> collection) {
        if (collection == null) {
            this.attributeDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributeDefinitions = listWithAutoConstructFlag;
    }

    public TableDescription withAttributeDefinitions(AttributeDefinition ... attributeDefinitionArray) {
        if (this.getAttributeDefinitions() == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitionArray.length));
        }
        for (AttributeDefinition attributeDefinition : attributeDefinitionArray) {
            this.getAttributeDefinitions().add(attributeDefinition);
        }
        return this;
    }

    public TableDescription withAttributeDefinitions(Collection<AttributeDefinition> collection) {
        if (collection == null) {
            this.attributeDefinitions = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributeDefinitions = listWithAutoConstructFlag;
        }
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public TableDescription withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.keySchema = listWithAutoConstructFlag;
    }

    public TableDescription withKeySchema(KeySchemaElement ... keySchemaElementArray) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchemaElementArray.length));
        }
        for (KeySchemaElement keySchemaElement : keySchemaElementArray) {
            this.getKeySchema().add(keySchemaElement);
        }
        return this;
    }

    public TableDescription withKeySchema(Collection<KeySchemaElement> collection) {
        if (collection == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.keySchema = listWithAutoConstructFlag;
        }
        return this;
    }

    public String getTableStatus() {
        return this.tableStatus;
    }

    public void setTableStatus(String string) {
        this.tableStatus = string;
    }

    public TableDescription withTableStatus(String string) {
        this.tableStatus = string;
        return this;
    }

    public void setTableStatus(TableStatus tableStatus) {
        this.tableStatus = tableStatus.toString();
    }

    public TableDescription withTableStatus(TableStatus tableStatus) {
        this.tableStatus = tableStatus.toString();
        return this;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(Date date) {
        this.creationDateTime = date;
    }

    public TableDescription withCreationDateTime(Date date) {
        this.creationDateTime = date;
        return this;
    }

    public ProvisionedThroughputDescription getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughputDescription) {
        this.provisionedThroughput = provisionedThroughputDescription;
    }

    public TableDescription withProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughputDescription) {
        this.provisionedThroughput = provisionedThroughputDescription;
        return this;
    }

    public Long getTableSizeBytes() {
        return this.tableSizeBytes;
    }

    public void setTableSizeBytes(Long l) {
        this.tableSizeBytes = l;
    }

    public TableDescription withTableSizeBytes(Long l) {
        this.tableSizeBytes = l;
        return this;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(Long l) {
        this.itemCount = l;
    }

    public TableDescription withItemCount(Long l) {
        this.itemCount = l;
        return this;
    }

    public List<LocalSecondaryIndexDescription> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription> collection) {
        if (collection == null) {
            this.localSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.localSecondaryIndexes = listWithAutoConstructFlag;
    }

    public TableDescription withLocalSecondaryIndexes(LocalSecondaryIndexDescription ... localSecondaryIndexDescriptionArray) {
        if (this.getLocalSecondaryIndexes() == null) {
            this.setLocalSecondaryIndexes(new ArrayList<LocalSecondaryIndexDescription>(localSecondaryIndexDescriptionArray.length));
        }
        for (LocalSecondaryIndexDescription localSecondaryIndexDescription : localSecondaryIndexDescriptionArray) {
            this.getLocalSecondaryIndexes().add(localSecondaryIndexDescription);
        }
        return this;
    }

    public TableDescription withLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription> collection) {
        if (collection == null) {
            this.localSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.localSecondaryIndexes = listWithAutoConstructFlag;
        }
        return this;
    }

    public List<GlobalSecondaryIndexDescription> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> collection) {
        if (collection == null) {
            this.globalSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.globalSecondaryIndexes = listWithAutoConstructFlag;
    }

    public TableDescription withGlobalSecondaryIndexes(GlobalSecondaryIndexDescription ... globalSecondaryIndexDescriptionArray) {
        if (this.getGlobalSecondaryIndexes() == null) {
            this.setGlobalSecondaryIndexes(new ArrayList<GlobalSecondaryIndexDescription>(globalSecondaryIndexDescriptionArray.length));
        }
        for (GlobalSecondaryIndexDescription globalSecondaryIndexDescription : globalSecondaryIndexDescriptionArray) {
            this.getGlobalSecondaryIndexes().add(globalSecondaryIndexDescription);
        }
        return this;
    }

    public TableDescription withGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> collection) {
        if (collection == null) {
            this.globalSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.globalSecondaryIndexes = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getAttributeDefinitions() != null) {
            stringBuilder.append("AttributeDefinitions: " + this.getAttributeDefinitions() + ",");
        }
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getKeySchema() != null) {
            stringBuilder.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getTableStatus() != null) {
            stringBuilder.append("TableStatus: " + this.getTableStatus() + ",");
        }
        if (this.getCreationDateTime() != null) {
            stringBuilder.append("CreationDateTime: " + this.getCreationDateTime() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            stringBuilder.append("ProvisionedThroughput: " + this.getProvisionedThroughput() + ",");
        }
        if (this.getTableSizeBytes() != null) {
            stringBuilder.append("TableSizeBytes: " + this.getTableSizeBytes() + ",");
        }
        if (this.getItemCount() != null) {
            stringBuilder.append("ItemCount: " + this.getItemCount() + ",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            stringBuilder.append("LocalSecondaryIndexes: " + this.getLocalSecondaryIndexes() + ",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            stringBuilder.append("GlobalSecondaryIndexes: " + this.getGlobalSecondaryIndexes());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getAttributeDefinitions() == null ? 0 : ((Object)this.getAttributeDefinitions()).hashCode());
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getKeySchema() == null ? 0 : ((Object)this.getKeySchema()).hashCode());
        n = 31 * n + (this.getTableStatus() == null ? 0 : this.getTableStatus().hashCode());
        n = 31 * n + (this.getCreationDateTime() == null ? 0 : this.getCreationDateTime().hashCode());
        n = 31 * n + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        n = 31 * n + (this.getTableSizeBytes() == null ? 0 : this.getTableSizeBytes().hashCode());
        n = 31 * n + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        n = 31 * n + (this.getLocalSecondaryIndexes() == null ? 0 : ((Object)this.getLocalSecondaryIndexes()).hashCode());
        n = 31 * n + (this.getGlobalSecondaryIndexes() == null ? 0 : ((Object)this.getGlobalSecondaryIndexes()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof TableDescription)) {
            return false;
        }
        TableDescription tableDescription = (TableDescription)object;
        if (tableDescription.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (tableDescription.getAttributeDefinitions() != null && !((Object)tableDescription.getAttributeDefinitions()).equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (tableDescription.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (tableDescription.getTableName() != null && !tableDescription.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (tableDescription.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (tableDescription.getKeySchema() != null && !((Object)tableDescription.getKeySchema()).equals(this.getKeySchema())) {
            return false;
        }
        if (tableDescription.getTableStatus() == null ^ this.getTableStatus() == null) {
            return false;
        }
        if (tableDescription.getTableStatus() != null && !tableDescription.getTableStatus().equals(this.getTableStatus())) {
            return false;
        }
        if (tableDescription.getCreationDateTime() == null ^ this.getCreationDateTime() == null) {
            return false;
        }
        if (tableDescription.getCreationDateTime() != null && !tableDescription.getCreationDateTime().equals(this.getCreationDateTime())) {
            return false;
        }
        if (tableDescription.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (tableDescription.getProvisionedThroughput() != null && !tableDescription.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (tableDescription.getTableSizeBytes() == null ^ this.getTableSizeBytes() == null) {
            return false;
        }
        if (tableDescription.getTableSizeBytes() != null && !tableDescription.getTableSizeBytes().equals(this.getTableSizeBytes())) {
            return false;
        }
        if (tableDescription.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        if (tableDescription.getItemCount() != null && !tableDescription.getItemCount().equals(this.getItemCount())) {
            return false;
        }
        if (tableDescription.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (tableDescription.getLocalSecondaryIndexes() != null && !((Object)tableDescription.getLocalSecondaryIndexes()).equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (tableDescription.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        return tableDescription.getGlobalSecondaryIndexes() == null || ((Object)tableDescription.getGlobalSecondaryIndexes()).equals(this.getGlobalSecondaryIndexes());
    }
}

