/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ConditionalOperator;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private String indexName;
    private String select;
    private ListWithAutoConstructFlag<String> attributesToGet;
    private Integer limit;
    private Boolean consistentRead;
    private Map<String, Condition> keyConditions;
    private Map<String, Condition> queryFilter;
    private String conditionalOperator;
    private Boolean scanIndexForward;
    private Map<String, AttributeValue> exclusiveStartKey;
    private String returnConsumedCapacity;

    public QueryRequest() {
    }

    public QueryRequest(String string) {
        this.setTableName(string);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public QueryRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public QueryRequest withIndexName(String string) {
        this.indexName = string;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String string) {
        this.select = string;
    }

    public QueryRequest withSelect(String string) {
        this.select = string;
        return this;
    }

    public void setSelect(Select select) {
        this.select = select.toString();
    }

    public QueryRequest withSelect(Select select) {
        this.select = select.toString();
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributesToGet = listWithAutoConstructFlag;
    }

    public QueryRequest withAttributesToGet(String ... stringArray) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getAttributesToGet().add(string);
        }
        return this;
    }

    public QueryRequest withAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributesToGet = listWithAutoConstructFlag;
        }
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer n) {
        this.limit = n;
    }

    public QueryRequest withLimit(Integer n) {
        this.limit = n;
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setConsistentRead(Boolean bl) {
        this.consistentRead = bl;
    }

    public QueryRequest withConsistentRead(Boolean bl) {
        this.consistentRead = bl;
        return this;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public Map<String, Condition> getKeyConditions() {
        return this.keyConditions;
    }

    public void setKeyConditions(Map<String, Condition> map) {
        this.keyConditions = map;
    }

    public QueryRequest withKeyConditions(Map<String, Condition> map) {
        this.setKeyConditions(map);
        return this;
    }

    public QueryRequest addKeyConditionsEntry(String string, Condition condition) {
        if (null == this.keyConditions) {
            this.keyConditions = new HashMap<String, Condition>();
        }
        if (this.keyConditions.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.keyConditions.put(string, condition);
        return this;
    }

    public QueryRequest clearKeyConditionsEntries() {
        this.keyConditions = null;
        return this;
    }

    public Map<String, Condition> getQueryFilter() {
        return this.queryFilter;
    }

    public void setQueryFilter(Map<String, Condition> map) {
        this.queryFilter = map;
    }

    public QueryRequest withQueryFilter(Map<String, Condition> map) {
        this.setQueryFilter(map);
        return this;
    }

    public QueryRequest addQueryFilterEntry(String string, Condition condition) {
        if (null == this.queryFilter) {
            this.queryFilter = new HashMap<String, Condition>();
        }
        if (this.queryFilter.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.queryFilter.put(string, condition);
        return this;
    }

    public QueryRequest clearQueryFilterEntries() {
        this.queryFilter = null;
        return this;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String string) {
        this.conditionalOperator = string;
    }

    public QueryRequest withConditionalOperator(String string) {
        this.conditionalOperator = string;
        return this;
    }

    public void setConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
    }

    public QueryRequest withConditionalOperator(ConditionalOperator conditionalOperator) {
        this.conditionalOperator = conditionalOperator.toString();
        return this;
    }

    public Boolean isScanIndexForward() {
        return this.scanIndexForward;
    }

    public void setScanIndexForward(Boolean bl) {
        this.scanIndexForward = bl;
    }

    public QueryRequest withScanIndexForward(Boolean bl) {
        this.scanIndexForward = bl;
        return this;
    }

    public Boolean getScanIndexForward() {
        return this.scanIndexForward;
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Map<String, AttributeValue> map) {
        this.exclusiveStartKey = map;
    }

    public QueryRequest withExclusiveStartKey(Map<String, AttributeValue> map) {
        this.setExclusiveStartKey(map);
        return this;
    }

    public void setExclusiveStartKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        HashMap<String, AttributeValue> hashMap = new HashMap<String, AttributeValue>();
        if (entry == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        hashMap.put(entry.getKey(), entry.getValue());
        if (entry2 != null) {
            hashMap.put(entry2.getKey(), entry2.getValue());
        }
        this.setExclusiveStartKey(hashMap);
    }

    public QueryRequest withExclusiveStartKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        this.setExclusiveStartKey(entry, entry2);
        return this;
    }

    public QueryRequest addExclusiveStartKeyEntry(String string, AttributeValue attributeValue) {
        if (null == this.exclusiveStartKey) {
            this.exclusiveStartKey = new HashMap<String, AttributeValue>();
        }
        if (this.exclusiveStartKey.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.exclusiveStartKey.put(string, attributeValue);
        return this;
    }

    public QueryRequest clearExclusiveStartKeyEntries() {
        this.exclusiveStartKey = null;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public QueryRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public QueryRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getIndexName() != null) {
            stringBuilder.append("IndexName: " + this.getIndexName() + ",");
        }
        if (this.getSelect() != null) {
            stringBuilder.append("Select: " + this.getSelect() + ",");
        }
        if (this.getAttributesToGet() != null) {
            stringBuilder.append("AttributesToGet: " + this.getAttributesToGet() + ",");
        }
        if (this.getLimit() != null) {
            stringBuilder.append("Limit: " + this.getLimit() + ",");
        }
        if (this.isConsistentRead() != null) {
            stringBuilder.append("ConsistentRead: " + this.isConsistentRead() + ",");
        }
        if (this.getKeyConditions() != null) {
            stringBuilder.append("KeyConditions: " + this.getKeyConditions() + ",");
        }
        if (this.getQueryFilter() != null) {
            stringBuilder.append("QueryFilter: " + this.getQueryFilter() + ",");
        }
        if (this.getConditionalOperator() != null) {
            stringBuilder.append("ConditionalOperator: " + this.getConditionalOperator() + ",");
        }
        if (this.isScanIndexForward() != null) {
            stringBuilder.append("ScanIndexForward: " + this.isScanIndexForward() + ",");
        }
        if (this.getExclusiveStartKey() != null) {
            stringBuilder.append("ExclusiveStartKey: " + this.getExclusiveStartKey() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getIndexName() == null ? 0 : this.getIndexName().hashCode());
        n = 31 * n + (this.getSelect() == null ? 0 : this.getSelect().hashCode());
        n = 31 * n + (this.getAttributesToGet() == null ? 0 : ((Object)this.getAttributesToGet()).hashCode());
        n = 31 * n + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        n = 31 * n + (this.isConsistentRead() == null ? 0 : this.isConsistentRead().hashCode());
        n = 31 * n + (this.getKeyConditions() == null ? 0 : ((Object)this.getKeyConditions()).hashCode());
        n = 31 * n + (this.getQueryFilter() == null ? 0 : ((Object)this.getQueryFilter()).hashCode());
        n = 31 * n + (this.getConditionalOperator() == null ? 0 : this.getConditionalOperator().hashCode());
        n = 31 * n + (this.isScanIndexForward() == null ? 0 : this.isScanIndexForward().hashCode());
        n = 31 * n + (this.getExclusiveStartKey() == null ? 0 : ((Object)this.getExclusiveStartKey()).hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof QueryRequest)) {
            return false;
        }
        QueryRequest queryRequest = (QueryRequest)object;
        if (queryRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (queryRequest.getTableName() != null && !queryRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (queryRequest.getIndexName() == null ^ this.getIndexName() == null) {
            return false;
        }
        if (queryRequest.getIndexName() != null && !queryRequest.getIndexName().equals(this.getIndexName())) {
            return false;
        }
        if (queryRequest.getSelect() == null ^ this.getSelect() == null) {
            return false;
        }
        if (queryRequest.getSelect() != null && !queryRequest.getSelect().equals(this.getSelect())) {
            return false;
        }
        if (queryRequest.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (queryRequest.getAttributesToGet() != null && !((Object)queryRequest.getAttributesToGet()).equals(this.getAttributesToGet())) {
            return false;
        }
        if (queryRequest.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (queryRequest.getLimit() != null && !queryRequest.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (queryRequest.isConsistentRead() == null ^ this.isConsistentRead() == null) {
            return false;
        }
        if (queryRequest.isConsistentRead() != null && !queryRequest.isConsistentRead().equals(this.isConsistentRead())) {
            return false;
        }
        if (queryRequest.getKeyConditions() == null ^ this.getKeyConditions() == null) {
            return false;
        }
        if (queryRequest.getKeyConditions() != null && !((Object)queryRequest.getKeyConditions()).equals(this.getKeyConditions())) {
            return false;
        }
        if (queryRequest.getQueryFilter() == null ^ this.getQueryFilter() == null) {
            return false;
        }
        if (queryRequest.getQueryFilter() != null && !((Object)queryRequest.getQueryFilter()).equals(this.getQueryFilter())) {
            return false;
        }
        if (queryRequest.getConditionalOperator() == null ^ this.getConditionalOperator() == null) {
            return false;
        }
        if (queryRequest.getConditionalOperator() != null && !queryRequest.getConditionalOperator().equals(this.getConditionalOperator())) {
            return false;
        }
        if (queryRequest.isScanIndexForward() == null ^ this.isScanIndexForward() == null) {
            return false;
        }
        if (queryRequest.isScanIndexForward() != null && !queryRequest.isScanIndexForward().equals(this.isScanIndexForward())) {
            return false;
        }
        if (queryRequest.getExclusiveStartKey() == null ^ this.getExclusiveStartKey() == null) {
            return false;
        }
        if (queryRequest.getExclusiveStartKey() != null && !((Object)queryRequest.getExclusiveStartKey()).equals(this.getExclusiveStartKey())) {
            return false;
        }
        if (queryRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        return queryRequest.getReturnConsumedCapacity() == null || queryRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity());
    }
}

