/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GetItemResult
implements Serializable {
    private Map<String, AttributeValue> item;
    private ConsumedCapacity consumedCapacity;

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> map) {
        this.item = map;
    }

    public GetItemResult withItem(Map<String, AttributeValue> map) {
        this.setItem(map);
        return this;
    }

    public GetItemResult addItemEntry(String string, AttributeValue attributeValue) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.item.put(string, attributeValue);
        return this;
    }

    public GetItemResult clearItemEntries() {
        this.item = null;
        return this;
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public GetItemResult withConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getItem() != null) {
            stringBuilder.append("Item: " + this.getItem() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            stringBuilder.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getItem() == null ? 0 : ((Object)this.getItem()).hashCode());
        n = 31 * n + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GetItemResult)) {
            return false;
        }
        GetItemResult getItemResult = (GetItemResult)object;
        if (getItemResult.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        if (getItemResult.getItem() != null && !((Object)getItemResult.getItem()).equals(this.getItem())) {
            return false;
        }
        if (getItemResult.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return getItemResult.getConsumedCapacity() == null || getItemResult.getConsumedCapacity().equals(this.getConsumedCapacity());
    }
}

