/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BatchGetItemRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Map<String, KeysAndAttributes> requestItems;
    private String returnConsumedCapacity;

    public BatchGetItemRequest() {
    }

    public BatchGetItemRequest(Map<String, KeysAndAttributes> map) {
        this.setRequestItems(map);
    }

    public BatchGetItemRequest(Map<String, KeysAndAttributes> map, String string) {
        this.setRequestItems(map);
        this.setReturnConsumedCapacity(string);
    }

    public BatchGetItemRequest(Map<String, KeysAndAttributes> map, ReturnConsumedCapacity returnConsumedCapacity) {
        this.requestItems = map;
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public Map<String, KeysAndAttributes> getRequestItems() {
        return this.requestItems;
    }

    public void setRequestItems(Map<String, KeysAndAttributes> map) {
        this.requestItems = map;
    }

    public BatchGetItemRequest withRequestItems(Map<String, KeysAndAttributes> map) {
        this.setRequestItems(map);
        return this;
    }

    public BatchGetItemRequest addRequestItemsEntry(String string, KeysAndAttributes keysAndAttributes) {
        if (null == this.requestItems) {
            this.requestItems = new HashMap<String, KeysAndAttributes>();
        }
        if (this.requestItems.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.requestItems.put(string, keysAndAttributes);
        return this;
    }

    public BatchGetItemRequest clearRequestItemsEntries() {
        this.requestItems = null;
        return this;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public BatchGetItemRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public BatchGetItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getRequestItems() != null) {
            stringBuilder.append("RequestItems: " + this.getRequestItems() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getRequestItems() == null ? 0 : ((Object)this.getRequestItems()).hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BatchGetItemRequest)) {
            return false;
        }
        BatchGetItemRequest batchGetItemRequest = (BatchGetItemRequest)object;
        if (batchGetItemRequest.getRequestItems() == null ^ this.getRequestItems() == null) {
            return false;
        }
        if (batchGetItemRequest.getRequestItems() != null && !((Object)batchGetItemRequest.getRequestItems()).equals(this.getRequestItems())) {
            return false;
        }
        if (batchGetItemRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        return batchGetItemRequest.getReturnConsumedCapacity() == null || batchGetItemRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity());
    }
}

