/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)queryRequest, "AmazonDynamoDBv2");
        String string = "DynamoDB_20120810.Query";
        defaultRequest.addHeader("X-Amz-Target", string);
        defaultRequest.setHttpMethod(HttpMethodName.POST);
        defaultRequest.setResourcePath("");
        try {
            ByteBuffer byteBuffer;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Iterator iterator;
            ListWithAutoConstructFlag listWithAutoConstructFlag;
            ListWithAutoConstructFlag listWithAutoConstructFlag2;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jSONWriter = new JSONWriter((Writer)stringWriter);
            jSONWriter.object();
            if (queryRequest.getTableName() != null) {
                jSONWriter.key("TableName").value((Object)queryRequest.getTableName());
            }
            if (queryRequest.getIndexName() != null) {
                jSONWriter.key("IndexName").value((Object)queryRequest.getIndexName());
            }
            if (queryRequest.getSelect() != null) {
                jSONWriter.key("Select").value((Object)queryRequest.getSelect());
            }
            if (!((listWithAutoConstructFlag2 = (ListWithAutoConstructFlag)queryRequest.getAttributesToGet()) == null || listWithAutoConstructFlag2.isAutoConstruct() && listWithAutoConstructFlag2.isEmpty())) {
                jSONWriter.key("AttributesToGet");
                jSONWriter.array();
                for (String entry2 : listWithAutoConstructFlag2) {
                    if (entry2 == null) continue;
                    jSONWriter.value((Object)entry2);
                }
                jSONWriter.endArray();
            }
            if (queryRequest.getLimit() != null) {
                jSONWriter.key("Limit").value((Object)queryRequest.getLimit());
            }
            if (queryRequest.isConsistentRead() != null) {
                jSONWriter.key("ConsistentRead").value((Object)queryRequest.isConsistentRead());
            }
            if (queryRequest.getKeyConditions() != null) {
                jSONWriter.key("KeyConditions");
                jSONWriter.object();
                for (Map.Entry<String, Condition> entry : queryRequest.getKeyConditions().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jSONWriter.key(entry.getKey());
                    jSONWriter.object();
                    listWithAutoConstructFlag = (ListWithAutoConstructFlag)entry.getValue().getAttributeValueList();
                    if (!(listWithAutoConstructFlag == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                        jSONWriter.key("AttributeValueList");
                        jSONWriter.array();
                        iterator = listWithAutoConstructFlag.iterator();
                        while (iterator.hasNext()) {
                            object5 = (AttributeValue)iterator.next();
                            if (object5 == null) continue;
                            jSONWriter.object();
                            if (((AttributeValue)object5).getS() != null) {
                                jSONWriter.key("S").value((Object)((AttributeValue)object5).getS());
                            }
                            if (((AttributeValue)object5).getN() != null) {
                                jSONWriter.key("N").value((Object)((AttributeValue)object5).getN());
                            }
                            if (((AttributeValue)object5).getB() != null) {
                                jSONWriter.key("B").value(((AttributeValue)object5).getB());
                            }
                            if (!((object4 = (ListWithAutoConstructFlag)((AttributeValue)object5).getSS()) == null || object4.isAutoConstruct() && object4.isEmpty())) {
                                jSONWriter.key("SS");
                                jSONWriter.array();
                                object3 = object4.iterator();
                                while (object3.hasNext()) {
                                    object2 = (String)object3.next();
                                    if (object2 == null) continue;
                                    jSONWriter.value(object2);
                                }
                                jSONWriter.endArray();
                            }
                            if (!((object3 = (ListWithAutoConstructFlag)((AttributeValue)object5).getNS()) == null || object3.isAutoConstruct() && object3.isEmpty())) {
                                jSONWriter.key("NS");
                                jSONWriter.array();
                                object2 = object3.iterator();
                                while (object2.hasNext()) {
                                    object = (String)object2.next();
                                    if (object == null) continue;
                                    jSONWriter.value(object);
                                }
                                jSONWriter.endArray();
                            }
                            if (!((object2 = (ListWithAutoConstructFlag)((AttributeValue)object5).getBS()) == null || object2.isAutoConstruct() && object2.isEmpty())) {
                                jSONWriter.key("BS");
                                jSONWriter.array();
                                object = object2.iterator();
                                while (object.hasNext()) {
                                    byteBuffer = (ByteBuffer)object.next();
                                    if (byteBuffer == null) continue;
                                    jSONWriter.value(byteBuffer);
                                }
                                jSONWriter.endArray();
                            }
                            jSONWriter.endObject();
                        }
                        jSONWriter.endArray();
                    }
                    if (entry.getValue().getComparisonOperator() != null) {
                        jSONWriter.key("ComparisonOperator").value((Object)entry.getValue().getComparisonOperator());
                    }
                    jSONWriter.endObject();
                }
                jSONWriter.endObject();
            }
            if (queryRequest.getQueryFilter() != null) {
                jSONWriter.key("QueryFilter");
                jSONWriter.object();
                for (Map.Entry<String, Condition> entry : queryRequest.getQueryFilter().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jSONWriter.key(entry.getKey());
                    jSONWriter.object();
                    listWithAutoConstructFlag = (ListWithAutoConstructFlag)entry.getValue().getAttributeValueList();
                    if (!(listWithAutoConstructFlag == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                        jSONWriter.key("AttributeValueList");
                        jSONWriter.array();
                        iterator = listWithAutoConstructFlag.iterator();
                        while (iterator.hasNext()) {
                            object5 = (AttributeValue)iterator.next();
                            if (object5 == null) continue;
                            jSONWriter.object();
                            if (((AttributeValue)object5).getS() != null) {
                                jSONWriter.key("S").value((Object)((AttributeValue)object5).getS());
                            }
                            if (((AttributeValue)object5).getN() != null) {
                                jSONWriter.key("N").value((Object)((AttributeValue)object5).getN());
                            }
                            if (((AttributeValue)object5).getB() != null) {
                                jSONWriter.key("B").value(((AttributeValue)object5).getB());
                            }
                            if (!((object4 = (ListWithAutoConstructFlag)((AttributeValue)object5).getSS()) == null || object4.isAutoConstruct() && object4.isEmpty())) {
                                jSONWriter.key("SS");
                                jSONWriter.array();
                                object3 = object4.iterator();
                                while (object3.hasNext()) {
                                    object2 = (String)object3.next();
                                    if (object2 == null) continue;
                                    jSONWriter.value(object2);
                                }
                                jSONWriter.endArray();
                            }
                            if (!((object3 = (ListWithAutoConstructFlag)((AttributeValue)object5).getNS()) == null || object3.isAutoConstruct() && object3.isEmpty())) {
                                jSONWriter.key("NS");
                                jSONWriter.array();
                                object2 = object3.iterator();
                                while (object2.hasNext()) {
                                    object = (String)object2.next();
                                    if (object == null) continue;
                                    jSONWriter.value(object);
                                }
                                jSONWriter.endArray();
                            }
                            if (!((object2 = (ListWithAutoConstructFlag)((AttributeValue)object5).getBS()) == null || object2.isAutoConstruct() && object2.isEmpty())) {
                                jSONWriter.key("BS");
                                jSONWriter.array();
                                object = object2.iterator();
                                while (object.hasNext()) {
                                    byteBuffer = (ByteBuffer)object.next();
                                    if (byteBuffer == null) continue;
                                    jSONWriter.value(byteBuffer);
                                }
                                jSONWriter.endArray();
                            }
                            jSONWriter.endObject();
                        }
                        jSONWriter.endArray();
                    }
                    if (entry.getValue().getComparisonOperator() != null) {
                        jSONWriter.key("ComparisonOperator").value((Object)entry.getValue().getComparisonOperator());
                    }
                    jSONWriter.endObject();
                }
                jSONWriter.endObject();
            }
            if (queryRequest.getConditionalOperator() != null) {
                jSONWriter.key("ConditionalOperator").value((Object)queryRequest.getConditionalOperator());
            }
            if (queryRequest.isScanIndexForward() != null) {
                jSONWriter.key("ScanIndexForward").value((Object)queryRequest.isScanIndexForward());
            }
            if (queryRequest.getExclusiveStartKey() != null) {
                jSONWriter.key("ExclusiveStartKey");
                jSONWriter.object();
                for (Map.Entry<String, AttributeValue> entry : queryRequest.getExclusiveStartKey().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jSONWriter.key(entry.getKey());
                    jSONWriter.object();
                    if (entry.getValue().getS() != null) {
                        jSONWriter.key("S").value((Object)entry.getValue().getS());
                    }
                    if (entry.getValue().getN() != null) {
                        jSONWriter.key("N").value((Object)entry.getValue().getN());
                    }
                    if (entry.getValue().getB() != null) {
                        jSONWriter.key("B").value(entry.getValue().getB());
                    }
                    if (!((listWithAutoConstructFlag = (ListWithAutoConstructFlag)entry.getValue().getSS()) == null || listWithAutoConstructFlag.isAutoConstruct() && listWithAutoConstructFlag.isEmpty())) {
                        jSONWriter.key("SS");
                        jSONWriter.array();
                        iterator = listWithAutoConstructFlag.iterator();
                        while (iterator.hasNext()) {
                            object5 = (String)iterator.next();
                            if (object5 == null) continue;
                            jSONWriter.value(object5);
                        }
                        jSONWriter.endArray();
                    }
                    if (!((iterator = (ListWithAutoConstructFlag)entry.getValue().getNS()) == null || iterator.isAutoConstruct() && iterator.isEmpty())) {
                        jSONWriter.key("NS");
                        jSONWriter.array();
                        object5 = iterator.iterator();
                        while (object5.hasNext()) {
                            object4 = (String)object5.next();
                            if (object4 == null) continue;
                            jSONWriter.value(object4);
                        }
                        jSONWriter.endArray();
                    }
                    if (!((object5 = (ListWithAutoConstructFlag)entry.getValue().getBS()) == null || object5.isAutoConstruct() && object5.isEmpty())) {
                        jSONWriter.key("BS");
                        jSONWriter.array();
                        object4 = object5.iterator();
                        while (object4.hasNext()) {
                            object3 = (ByteBuffer)object4.next();
                            if (object3 == null) continue;
                            jSONWriter.value((ByteBuffer)object3);
                        }
                        jSONWriter.endArray();
                    }
                    jSONWriter.endObject();
                }
                jSONWriter.endObject();
            }
            if (queryRequest.getReturnConsumedCapacity() != null) {
                jSONWriter.key("ReturnConsumedCapacity").value((Object)queryRequest.getReturnConsumedCapacity());
            }
            jSONWriter.endObject();
            Iterator<Map.Entry<String, AttributeValue>> iterator2 = stringWriter.toString();
            byte[] byArray = ((String)((Object)iterator2)).getBytes(StringUtils.UTF8);
            defaultRequest.setContent((InputStream)new StringInputStream(iterator2));
            defaultRequest.addHeader("Content-Length", Integer.toString(byArray.length));
            defaultRequest.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable throwable) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + throwable.getMessage(), throwable);
        }
        return defaultRequest;
    }
}

