/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanResult
implements Serializable {
    private ListWithAutoConstructFlag<Map<String, AttributeValue>> items;
    private Integer count;
    private Integer scannedCount;
    private Map<String, AttributeValue> lastEvaluatedKey;
    private ConsumedCapacity consumedCapacity;

    public List<Map<String, AttributeValue>> getItems() {
        return this.items;
    }

    public void setItems(Collection<Map<String, AttributeValue>> collection) {
        if (collection == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.items = listWithAutoConstructFlag;
    }

    public ScanResult withItems(Map<String, AttributeValue> ... mapArray) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<Map<String, AttributeValue>>(mapArray.length));
        }
        for (Map<String, AttributeValue> map : mapArray) {
            this.getItems().add(map);
        }
        return this;
    }

    public ScanResult withItems(Collection<Map<String, AttributeValue>> collection) {
        if (collection == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.items = listWithAutoConstructFlag;
        }
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer n) {
        this.count = n;
    }

    public ScanResult withCount(Integer n) {
        this.count = n;
        return this;
    }

    public Integer getScannedCount() {
        return this.scannedCount;
    }

    public void setScannedCount(Integer n) {
        this.scannedCount = n;
    }

    public ScanResult withScannedCount(Integer n) {
        this.scannedCount = n;
        return this;
    }

    public Map<String, AttributeValue> getLastEvaluatedKey() {
        return this.lastEvaluatedKey;
    }

    public void setLastEvaluatedKey(Map<String, AttributeValue> map) {
        this.lastEvaluatedKey = map;
    }

    public ScanResult withLastEvaluatedKey(Map<String, AttributeValue> map) {
        this.setLastEvaluatedKey(map);
        return this;
    }

    public ScanResult addLastEvaluatedKeyEntry(String string, AttributeValue attributeValue) {
        if (null == this.lastEvaluatedKey) {
            this.lastEvaluatedKey = new HashMap<String, AttributeValue>();
        }
        if (this.lastEvaluatedKey.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.lastEvaluatedKey.put(string, attributeValue);
        return this;
    }

    public ScanResult clearLastEvaluatedKeyEntries() {
        this.lastEvaluatedKey = null;
        return this;
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public ScanResult withConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getItems() != null) {
            stringBuilder.append("Items: " + this.getItems() + ",");
        }
        if (this.getCount() != null) {
            stringBuilder.append("Count: " + this.getCount() + ",");
        }
        if (this.getScannedCount() != null) {
            stringBuilder.append("ScannedCount: " + this.getScannedCount() + ",");
        }
        if (this.getLastEvaluatedKey() != null) {
            stringBuilder.append("LastEvaluatedKey: " + this.getLastEvaluatedKey() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            stringBuilder.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        n = 31 * n + (this.getCount() == null ? 0 : this.getCount().hashCode());
        n = 31 * n + (this.getScannedCount() == null ? 0 : this.getScannedCount().hashCode());
        n = 31 * n + (this.getLastEvaluatedKey() == null ? 0 : ((Object)this.getLastEvaluatedKey()).hashCode());
        n = 31 * n + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ScanResult)) {
            return false;
        }
        ScanResult scanResult = (ScanResult)object;
        if (scanResult.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (scanResult.getItems() != null && !((Object)scanResult.getItems()).equals(this.getItems())) {
            return false;
        }
        if (scanResult.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (scanResult.getCount() != null && !scanResult.getCount().equals(this.getCount())) {
            return false;
        }
        if (scanResult.getScannedCount() == null ^ this.getScannedCount() == null) {
            return false;
        }
        if (scanResult.getScannedCount() != null && !scanResult.getScannedCount().equals(this.getScannedCount())) {
            return false;
        }
        if (scanResult.getLastEvaluatedKey() == null ^ this.getLastEvaluatedKey() == null) {
            return false;
        }
        if (scanResult.getLastEvaluatedKey() != null && !((Object)scanResult.getLastEvaluatedKey()).equals(this.getLastEvaluatedKey())) {
            return false;
        }
        if (scanResult.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return scanResult.getConsumedCapacity() == null || scanResult.getConsumedCapacity().equals(this.getConsumedCapacity());
    }
}

