/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Projection
implements Serializable {
    private String projectionType;
    private ListWithAutoConstructFlag<String> nonKeyAttributes;

    public String getProjectionType() {
        return this.projectionType;
    }

    public void setProjectionType(String string) {
        this.projectionType = string;
    }

    public Projection withProjectionType(String string) {
        this.projectionType = string;
        return this;
    }

    public void setProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType.toString();
    }

    public Projection withProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType.toString();
        return this;
    }

    public List<String> getNonKeyAttributes() {
        return this.nonKeyAttributes;
    }

    public void setNonKeyAttributes(Collection<String> collection) {
        if (collection == null) {
            this.nonKeyAttributes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.nonKeyAttributes = listWithAutoConstructFlag;
    }

    public Projection withNonKeyAttributes(String ... stringArray) {
        if (this.getNonKeyAttributes() == null) {
            this.setNonKeyAttributes(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getNonKeyAttributes().add(string);
        }
        return this;
    }

    public Projection withNonKeyAttributes(Collection<String> collection) {
        if (collection == null) {
            this.nonKeyAttributes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.nonKeyAttributes = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getProjectionType() != null) {
            stringBuilder.append("ProjectionType: " + this.getProjectionType() + ",");
        }
        if (this.getNonKeyAttributes() != null) {
            stringBuilder.append("NonKeyAttributes: " + this.getNonKeyAttributes());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getProjectionType() == null ? 0 : this.getProjectionType().hashCode());
        n = 31 * n + (this.getNonKeyAttributes() == null ? 0 : ((Object)this.getNonKeyAttributes()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Projection)) {
            return false;
        }
        Projection projection = (Projection)object;
        if (projection.getProjectionType() == null ^ this.getProjectionType() == null) {
            return false;
        }
        if (projection.getProjectionType() != null && !projection.getProjectionType().equals(this.getProjectionType())) {
            return false;
        }
        if (projection.getNonKeyAttributes() == null ^ this.getNonKeyAttributes() == null) {
            return false;
        }
        return projection.getNonKeyAttributes() == null || ((Object)projection.getNonKeyAttributes()).equals(this.getNonKeyAttributes());
    }
}

