/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetItemRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String tableName;
    private Map<String, AttributeValue> key;
    private ListWithAutoConstructFlag<String> attributesToGet;
    private Boolean consistentRead;
    private String returnConsumedCapacity;

    public GetItemRequest() {
    }

    public GetItemRequest(String string, Map<String, AttributeValue> map) {
        this.setTableName(string);
        this.setKey(map);
    }

    public GetItemRequest(String string, Map<String, AttributeValue> map, Boolean bl) {
        this.setTableName(string);
        this.setKey(map);
        this.setConsistentRead(bl);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public GetItemRequest withTableName(String string) {
        this.tableName = string;
        return this;
    }

    public Map<String, AttributeValue> getKey() {
        return this.key;
    }

    public void setKey(Map<String, AttributeValue> map) {
        this.key = map;
    }

    public GetItemRequest withKey(Map<String, AttributeValue> map) {
        this.setKey(map);
        return this;
    }

    public void setKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        HashMap<String, AttributeValue> hashMap = new HashMap<String, AttributeValue>();
        if (entry == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        hashMap.put(entry.getKey(), entry.getValue());
        if (entry2 != null) {
            hashMap.put(entry2.getKey(), entry2.getValue());
        }
        this.setKey(hashMap);
    }

    public GetItemRequest withKey(Map.Entry<String, AttributeValue> entry, Map.Entry<String, AttributeValue> entry2) throws IllegalArgumentException {
        this.setKey(entry, entry2);
        return this;
    }

    public GetItemRequest addKeyEntry(String string, AttributeValue attributeValue) {
        if (null == this.key) {
            this.key = new HashMap<String, AttributeValue>();
        }
        if (this.key.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.key.put(string, attributeValue);
        return this;
    }

    public GetItemRequest clearKeyEntries() {
        this.key = null;
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributesToGet = listWithAutoConstructFlag;
    }

    public GetItemRequest withAttributesToGet(String ... stringArray) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getAttributesToGet().add(string);
        }
        return this;
    }

    public GetItemRequest withAttributesToGet(Collection<String> collection) {
        if (collection == null) {
            this.attributesToGet = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributesToGet = listWithAutoConstructFlag;
        }
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setConsistentRead(Boolean bl) {
        this.consistentRead = bl;
    }

    public GetItemRequest withConsistentRead(Boolean bl) {
        this.consistentRead = bl;
        return this;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public void setReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
    }

    public GetItemRequest withReturnConsumedCapacity(String string) {
        this.returnConsumedCapacity = string;
        return this;
    }

    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
    }

    public GetItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getTableName() != null) {
            stringBuilder.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getKey() != null) {
            stringBuilder.append("Key: " + this.getKey() + ",");
        }
        if (this.getAttributesToGet() != null) {
            stringBuilder.append("AttributesToGet: " + this.getAttributesToGet() + ",");
        }
        if (this.isConsistentRead() != null) {
            stringBuilder.append("ConsistentRead: " + this.isConsistentRead() + ",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            stringBuilder.append("ReturnConsumedCapacity: " + this.getReturnConsumedCapacity());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        n = 31 * n + (this.getKey() == null ? 0 : ((Object)this.getKey()).hashCode());
        n = 31 * n + (this.getAttributesToGet() == null ? 0 : ((Object)this.getAttributesToGet()).hashCode());
        n = 31 * n + (this.isConsistentRead() == null ? 0 : this.isConsistentRead().hashCode());
        n = 31 * n + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GetItemRequest)) {
            return false;
        }
        GetItemRequest getItemRequest = (GetItemRequest)object;
        if (getItemRequest.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (getItemRequest.getTableName() != null && !getItemRequest.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (getItemRequest.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (getItemRequest.getKey() != null && !((Object)getItemRequest.getKey()).equals(this.getKey())) {
            return false;
        }
        if (getItemRequest.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (getItemRequest.getAttributesToGet() != null && !((Object)getItemRequest.getAttributesToGet()).equals(this.getAttributesToGet())) {
            return false;
        }
        if (getItemRequest.isConsistentRead() == null ^ this.isConsistentRead() == null) {
            return false;
        }
        if (getItemRequest.isConsistentRead() != null && !getItemRequest.isConsistentRead().equals(this.isConsistentRead())) {
            return false;
        }
        if (getItemRequest.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        return getItemRequest.getReturnConsumedCapacity() == null || getItemRequest.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity());
    }
}

