/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import com.amazonaws.services.securitytoken.model.ProvidedContext;
import com.amazonaws.services.securitytoken.model.Tag;
import com.amazonaws.services.securitytoken.model.transform.PolicyDescriptorTypeStaxMarshaller;
import com.amazonaws.services.securitytoken.model.transform.ProvidedContextStaxMarshaller;
import com.amazonaws.services.securitytoken.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AssumeRoleRequestMarshaller
implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {
    @Override
    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {
        String prefix;
        if (assumeRoleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AssumeRoleRequest)");
        }
        DefaultRequest<AssumeRoleRequest> request = new DefaultRequest<AssumeRoleRequest>(assumeRoleRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "AssumeRole");
        request.addParameter("Version", "2011-06-15");
        if (assumeRoleRequest.getRoleArn() != null) {
            prefix = "RoleArn";
            String roleArn = assumeRoleRequest.getRoleArn();
            request.addParameter(prefix, StringUtils.fromString(roleArn));
        }
        if (assumeRoleRequest.getRoleSessionName() != null) {
            prefix = "RoleSessionName";
            String roleSessionName = assumeRoleRequest.getRoleSessionName();
            request.addParameter(prefix, StringUtils.fromString(roleSessionName));
        }
        if (assumeRoleRequest.getPolicyArns() != null) {
            prefix = "PolicyArns";
            List<PolicyDescriptorType> policyArns = assumeRoleRequest.getPolicyArns();
            int policyArnsIndex = 1;
            String policyArnsPrefix = prefix;
            for (PolicyDescriptorType policyArnsItem : policyArns) {
                prefix = policyArnsPrefix + ".member." + policyArnsIndex;
                if (policyArnsItem != null) {
                    PolicyDescriptorTypeStaxMarshaller.getInstance().marshall(policyArnsItem, request, prefix + ".");
                }
                ++policyArnsIndex;
            }
            prefix = policyArnsPrefix;
        }
        if (assumeRoleRequest.getPolicy() != null) {
            prefix = "Policy";
            String policy = assumeRoleRequest.getPolicy();
            request.addParameter(prefix, StringUtils.fromString(policy));
        }
        if (assumeRoleRequest.getDurationSeconds() != null) {
            prefix = "DurationSeconds";
            Integer durationSeconds = assumeRoleRequest.getDurationSeconds();
            request.addParameter(prefix, StringUtils.fromInteger(durationSeconds));
        }
        if (assumeRoleRequest.getTags() != null) {
            prefix = "Tags";
            List<Tag> tags = assumeRoleRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, request, prefix + ".");
                }
                ++tagsIndex;
            }
            prefix = tagsPrefix;
        }
        if (assumeRoleRequest.getTransitiveTagKeys() != null) {
            prefix = "TransitiveTagKeys";
            List<String> transitiveTagKeys = assumeRoleRequest.getTransitiveTagKeys();
            int transitiveTagKeysIndex = 1;
            String transitiveTagKeysPrefix = prefix;
            for (String transitiveTagKeysItem : transitiveTagKeys) {
                prefix = transitiveTagKeysPrefix + ".member." + transitiveTagKeysIndex;
                if (transitiveTagKeysItem != null) {
                    request.addParameter(prefix, StringUtils.fromString(transitiveTagKeysItem));
                }
                ++transitiveTagKeysIndex;
            }
            prefix = transitiveTagKeysPrefix;
        }
        if (assumeRoleRequest.getExternalId() != null) {
            prefix = "ExternalId";
            String externalId = assumeRoleRequest.getExternalId();
            request.addParameter(prefix, StringUtils.fromString(externalId));
        }
        if (assumeRoleRequest.getSerialNumber() != null) {
            prefix = "SerialNumber";
            String serialNumber = assumeRoleRequest.getSerialNumber();
            request.addParameter(prefix, StringUtils.fromString(serialNumber));
        }
        if (assumeRoleRequest.getTokenCode() != null) {
            prefix = "TokenCode";
            String tokenCode = assumeRoleRequest.getTokenCode();
            request.addParameter(prefix, StringUtils.fromString(tokenCode));
        }
        if (assumeRoleRequest.getSourceIdentity() != null) {
            prefix = "SourceIdentity";
            String sourceIdentity = assumeRoleRequest.getSourceIdentity();
            request.addParameter(prefix, StringUtils.fromString(sourceIdentity));
        }
        if (assumeRoleRequest.getProvidedContexts() != null) {
            prefix = "ProvidedContexts";
            List<ProvidedContext> providedContexts = assumeRoleRequest.getProvidedContexts();
            int providedContextsIndex = 1;
            String providedContextsPrefix = prefix;
            for (ProvidedContext providedContextsItem : providedContexts) {
                prefix = providedContextsPrefix + ".member." + providedContextsIndex;
                if (providedContextsItem != null) {
                    ProvidedContextStaxMarshaller.getInstance().marshall(providedContextsItem, request, prefix + ".");
                }
                ++providedContextsIndex;
            }
            String string = providedContextsPrefix;
        }
        return request;
    }
}

