/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpClientFactory;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class ApacheHttpClient
implements HttpClient {
    private final org.apache.http.client.HttpClient httpClient;
    private HttpParams params = null;

    public ApacheHttpClient(ClientConfiguration config) {
        HttpClientFactory httpClientFactory = new HttpClientFactory();
        this.httpClient = httpClientFactory.createHttpClient(config);
        ((AbstractHttpClient)this.httpClient).setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        SchemeRegistry schemeRegistry = this.httpClient.getConnectionManager().getSchemeRegistry();
        Scheme https = schemeRegistry.getScheme("https");
        ((SSLSocketFactory)https.getSocketFactory()).setHostnameVerifier(SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws IOException {
        HttpUriRequest httpRequest = this.createHttpRequest(request);
        org.apache.http.HttpResponse httpResponse = this.httpClient.execute(httpRequest);
        String statusText = httpResponse.getStatusLine().getReasonPhrase();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        InputStream content = null;
        if (httpResponse.getEntity() != null) {
            content = httpResponse.getEntity().getContent();
        }
        HttpResponse.Builder builder = HttpResponse.builder().statusCode(statusCode).statusText(statusText).content(content);
        for (Header header : httpResponse.getAllHeaders()) {
            builder.header(header.getName(), header.getValue());
        }
        return builder.build();
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private HttpUriRequest createHttpRequest(HttpRequest request) {
        HttpGet httpRequest;
        String method = request.getMethod();
        if (method.equals("POST")) {
            HttpPost postRequest = new HttpPost(request.getUri());
            if (request.getContent() != null) {
                postRequest.setEntity((HttpEntity)new InputStreamEntity(request.getContent(), request.getContentLength()));
            }
            httpRequest = postRequest;
        } else if (method.equals("GET")) {
            httpRequest = new HttpGet(request.getUri());
        } else if (method.equals("PUT")) {
            HttpPut putRequest = new HttpPut(request.getUri());
            if (request.getContent() != null) {
                putRequest.setEntity((HttpEntity)new InputStreamEntity(request.getContent(), request.getContentLength()));
            }
            httpRequest = putRequest;
        } else if (method.equals("DELETE")) {
            httpRequest = new HttpDelete(request.getUri());
        } else if (method.equals("HEAD")) {
            httpRequest = new HttpHead(request.getUri());
        } else {
            throw new UnsupportedOperationException("Unsupported method: " + method);
        }
        if (request.getHeaders() != null && !request.getHeaders().isEmpty()) {
            for (Map.Entry<String, String> header : request.getHeaders().entrySet()) {
                String key = header.getKey();
                if (key.equals("Content-Length") || key.equals("Host")) continue;
                httpRequest.addHeader(header.getKey(), header.getValue());
            }
        }
        if (this.params == null) {
            this.params = new BasicHttpParams();
            this.params.setParameter("http.protocol.handle-redirects", (Object)false);
        }
        httpRequest.setParams(this.params);
        return httpRequest;
    }
}

