/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSBasicCognitoIdentityProvider;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSEnhancedCognitoIdentityProvider;
import com.amazonaws.auth.AWSIdentityProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentity;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.Credentials;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityResult;
import com.amazonaws.services.cognitoidentity.model.ResourceNotFoundException;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CognitoCredentialsProvider
implements AWSCredentialsProvider {
    private AmazonCognitoIdentity cib;
    private final AWSCognitoIdentityProvider identityProvider;
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    public static final int DEFAULT_THRESHOLD_SECONDS = 500;
    protected AWSSessionCredentials sessionCredentials;
    protected Date sessionCredentialsExpiration;
    protected String token;
    protected AWSSecurityTokenService securityTokenService;
    protected int sessionDuration;
    protected int refreshThreshold;
    protected String unauthRoleArn;
    protected String authRoleArn;
    protected String customRoleArn;
    protected boolean useEnhancedFlow;
    protected ReentrantReadWriteLock credentialsLock;

    public CognitoCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region) {
        this(accountId, identityPoolId, unauthRoleArn, authRoleArn, region, new ClientConfiguration());
    }

    public CognitoCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, Regions region, ClientConfiguration clientConfiguration) {
        this(accountId, identityPoolId, unauthRoleArn, authRoleArn, new AmazonCognitoIdentityClient(new AnonymousAWSCredentials(), clientConfiguration), (AWSSecurityTokenService)(unauthRoleArn == null && authRoleArn == null ? null : new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), clientConfiguration)));
        this.cib.setRegion(Region.getRegion(region));
    }

    public CognitoCredentialsProvider(String identityPoolId, Regions region) {
        this(null, identityPoolId, null, null, region, new ClientConfiguration());
    }

    public CognitoCredentialsProvider(String identityPoolId, Regions region, ClientConfiguration clientConfiguration) {
        this(null, identityPoolId, null, null, region, clientConfiguration);
    }

    public CognitoCredentialsProvider(String accountId, String identityPoolId, String unauthRoleArn, String authRoleArn, AmazonCognitoIdentityClient cibClient, AWSSecurityTokenService stsClient) {
        this.cib = cibClient;
        this.securityTokenService = stsClient;
        this.unauthRoleArn = unauthRoleArn;
        this.authRoleArn = authRoleArn;
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
        this.useEnhancedFlow = unauthRoleArn == null && authRoleArn == null;
        this.identityProvider = this.useEnhancedFlow ? new AWSEnhancedCognitoIdentityProvider(accountId, identityPoolId, cibClient) : new AWSBasicCognitoIdentityProvider(accountId, identityPoolId, cibClient);
        this.credentialsLock = new ReentrantReadWriteLock(true);
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider provider, String unauthArn, String authArn) {
        this(provider, unauthArn, authArn, new AWSSecurityTokenServiceClient(new AnonymousAWSCredentials(), new ClientConfiguration()));
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider provider, String unauthArn, String authArn, AWSSecurityTokenService stsClient) {
        this.identityProvider = provider;
        this.unauthRoleArn = unauthArn;
        this.authRoleArn = authArn;
        this.securityTokenService = stsClient;
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
        this.useEnhancedFlow = false;
        this.credentialsLock = new ReentrantReadWriteLock(true);
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider provider, Regions region) {
        this(provider, region, new ClientConfiguration());
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider provider, Regions region, ClientConfiguration clientConfiguration) {
        this(provider, new AmazonCognitoIdentityClient(new AnonymousAWSCredentials(), clientConfiguration));
        this.cib.setRegion(Region.getRegion(region));
    }

    public CognitoCredentialsProvider(AWSCognitoIdentityProvider provider, AmazonCognitoIdentityClient cib) {
        this.cib = cib;
        this.identityProvider = provider;
        this.unauthRoleArn = null;
        this.authRoleArn = null;
        this.securityTokenService = null;
        this.sessionDuration = 3600;
        this.refreshThreshold = 500;
        this.useEnhancedFlow = true;
        this.credentialsLock = new ReentrantReadWriteLock(true);
    }

    public String getIdentityId() {
        return this.identityProvider.getIdentityId();
    }

    public String getToken() {
        return this.identityProvider.getToken();
    }

    public AWSIdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setSessionCredentialsExpiration(Date expiration) {
        this.credentialsLock.writeLock().lock();
        try {
            this.sessionCredentialsExpiration = expiration;
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    public Date getSessionCredentitalsExpiration() {
        this.credentialsLock.readLock().lock();
        try {
            Date date = this.sessionCredentialsExpiration;
            return date;
        }
        finally {
            this.credentialsLock.readLock().unlock();
        }
    }

    public String getIdentityPoolId() {
        return this.identityProvider.getIdentityPoolId();
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        this.credentialsLock.writeLock().lock();
        try {
            if (this.needsNewSession()) {
                this.startSession();
            }
            AWSSessionCredentials aWSSessionCredentials = this.sessionCredentials;
            return aWSSessionCredentials;
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    public void setSessionDuration(int sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public CognitoCredentialsProvider withSessionDuration(int sessionDuration) {
        this.setSessionDuration(sessionDuration);
        return this;
    }

    public int getSessionDuration() {
        return this.sessionDuration;
    }

    public void setRefreshThreshold(int refreshThreshold) {
        this.refreshThreshold = refreshThreshold;
    }

    public CognitoCredentialsProvider withRefreshThreshold(int refreshThreshold) {
        this.setRefreshThreshold(refreshThreshold);
        return this;
    }

    public int getRefreshThreshold() {
        return this.refreshThreshold;
    }

    protected void setIdentityId(String identityId) {
        this.identityProvider.identityChanged(identityId);
    }

    public void setLogins(Map<String, String> logins) {
        this.credentialsLock.writeLock().lock();
        try {
            this.identityProvider.setLogins(logins);
            this.clearCredentials();
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    public String getCustomRoleArn() {
        return this.customRoleArn;
    }

    public void setCustomRoleArn(String customRoleArn) {
        this.customRoleArn = customRoleArn;
    }

    public AWSCredentialsProvider withLogins(Map<String, String> logins) {
        this.setLogins(logins);
        return this;
    }

    public Map<String, String> getLogins() {
        return this.identityProvider.getLogins();
    }

    @Override
    public void refresh() {
        this.credentialsLock.writeLock().lock();
        try {
            this.startSession();
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.credentialsLock.writeLock().lock();
        try {
            this.clearCredentials();
            this.setIdentityId(null);
            this.identityProvider.setLogins(new HashMap<String, String>());
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    public void clearCredentials() {
        this.credentialsLock.writeLock().lock();
        try {
            this.sessionCredentials = null;
            this.sessionCredentialsExpiration = null;
        }
        finally {
            this.credentialsLock.writeLock().unlock();
        }
    }

    protected void startSession() {
        try {
            this.token = this.identityProvider.refresh();
        }
        catch (ResourceNotFoundException rnfe) {
            this.token = this.retryRefresh();
        }
        catch (AmazonServiceException ase) {
            if (ase.getErrorCode().equals("ValidationException")) {
                this.token = this.retryRefresh();
            }
            throw ase;
        }
        if (this.useEnhancedFlow) {
            this.populateCredentialsWithCognito(this.token);
        } else {
            this.populateCredentialsWithSts(this.token);
        }
    }

    private String retryRefresh() {
        this.setIdentityId(null);
        this.token = this.identityProvider.refresh();
        return this.token;
    }

    private GetCredentialsForIdentityResult retryGetCredentialsForIdentity() {
        Map<String, String> logins;
        this.token = this.retryRefresh();
        if (this.token != null && !this.token.isEmpty()) {
            logins = new HashMap<String, String>();
            logins.put("cognito-identity.amazonaws.com", this.token);
        } else {
            logins = this.getLogins();
        }
        GetCredentialsForIdentityRequest request = new GetCredentialsForIdentityRequest().withIdentityId(this.getIdentityId()).withLogins(logins).withCustomRoleArn(this.customRoleArn);
        return this.cib.getCredentialsForIdentity(request);
    }

    private void populateCredentialsWithCognito(String token) {
        Map<String, String> logins;
        if (token != null && !token.isEmpty()) {
            logins = new HashMap<String, String>();
            logins.put("cognito-identity.amazonaws.com", token);
        } else {
            logins = this.getLogins();
        }
        GetCredentialsForIdentityRequest request = new GetCredentialsForIdentityRequest().withIdentityId(this.getIdentityId()).withLogins(logins).withCustomRoleArn(this.customRoleArn);
        GetCredentialsForIdentityResult result = null;
        try {
            result = this.cib.getCredentialsForIdentity(request);
        }
        catch (ResourceNotFoundException rnfe) {
            result = this.retryGetCredentialsForIdentity();
        }
        catch (AmazonServiceException ase) {
            if (ase.getErrorCode().equals("ValidationException")) {
                result = this.retryGetCredentialsForIdentity();
            }
            throw ase;
        }
        Credentials credentials = result.getCredentials();
        this.sessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretKey(), credentials.getSessionToken());
        this.setSessionCredentialsExpiration(credentials.getExpiration());
        if (!result.getIdentityId().equals(this.getIdentityId())) {
            this.setIdentityId(result.getIdentityId());
        }
    }

    private void populateCredentialsWithSts(String token) {
        boolean isAuthenticated = this.identityProvider.isAuthenticated();
        String roleArn = isAuthenticated ? this.authRoleArn : this.unauthRoleArn;
        AssumeRoleWithWebIdentityRequest sessionTokenRequest = new AssumeRoleWithWebIdentityRequest().withWebIdentityToken(token).withRoleArn(roleArn).withRoleSessionName("ProviderSession").withDurationSeconds(this.sessionDuration);
        this.appendUserAgent(sessionTokenRequest, this.getUserAgent());
        AssumeRoleWithWebIdentityResult sessionTokenResult = this.securityTokenService.assumeRoleWithWebIdentity(sessionTokenRequest);
        com.amazonaws.services.securitytoken.model.Credentials stsCredentials = sessionTokenResult.getCredentials();
        this.sessionCredentials = new BasicSessionCredentials(stsCredentials.getAccessKeyId(), stsCredentials.getSecretAccessKey(), stsCredentials.getSessionToken());
        this.setSessionCredentialsExpiration(stsCredentials.getExpiration());
    }

    protected boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long currentTime = System.currentTimeMillis() - (long)(SDKGlobalConfiguration.getGlobalTimeOffset() * 1000);
        long timeRemaining = this.sessionCredentialsExpiration.getTime() - currentTime;
        return timeRemaining < (long)(this.refreshThreshold * 1000);
    }

    private void appendUserAgent(AmazonWebServiceRequest request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
    }

    protected String getUserAgent() {
        return "";
    }

    public void registerIdentityChangedListener(IdentityChangedListener listener) {
        this.identityProvider.registerIdentityChangedListener(listener);
    }

    public void unregisterIdentityChangedListener(IdentityChangedListener listener) {
        this.identityProvider.unregisterIdentityChangedListener(listener);
    }
}

