/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.NamespaceRemovingInputStream;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XpathUtils {
    private static Log log = LogFactory.getLog(XpathUtils.class);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Document documentFrom(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        is = new NamespaceRemovingInputStream(is);
        Document doc = factory.newDocumentBuilder().parse(is);
        is.close();
        return doc;
    }

    public static Document documentFrom(String xml) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(new ByteArrayInputStream(xml.getBytes(StringUtils.UTF8)));
    }

    public static Document documentFrom(URL url) throws SAXException, IOException, ParserConfigurationException {
        return XpathUtils.documentFrom(url.openStream());
    }

    public static Double asDouble(String expression, Node node) throws XPathExpressionException {
        String doubleString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(doubleString) ? null : Double.valueOf(doubleString);
    }

    public static String asString(String expression, Node node) throws XPathExpressionException {
        return XpathUtils.evaluateAsString(expression, node);
    }

    public static Integer asInteger(String expression, Node node) throws XPathExpressionException {
        String intString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(intString) ? null : Integer.valueOf(intString);
    }

    public static Boolean asBoolean(String expression, Node node) throws XPathExpressionException {
        String booleanString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(booleanString) ? null : Boolean.valueOf(booleanString);
    }

    public static Float asFloat(String expression, Node node) throws XPathExpressionException {
        String floatString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(floatString) ? null : Float.valueOf(floatString);
    }

    public static Long asLong(String expression, Node node) throws XPathExpressionException {
        String longString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(longString) ? null : Long.valueOf(longString);
    }

    public static Byte asByte(String expression, Node node) throws XPathExpressionException {
        String byteString = XpathUtils.evaluateAsString(expression, node);
        return XpathUtils.isEmptyString(byteString) ? null : Byte.valueOf(byteString);
    }

    public static Date asDate(String expression, Node node) throws XPathExpressionException {
        String dateString = XpathUtils.evaluateAsString(expression, node);
        if (XpathUtils.isEmptyString(dateString)) {
            return null;
        }
        return DateUtils.parseISO8601Date(dateString);
    }

    public static ByteBuffer asByteBuffer(String expression, Node node) throws XPathExpressionException {
        String base64EncodedString = XpathUtils.evaluateAsString(expression, node);
        if (XpathUtils.isEmptyString(base64EncodedString)) {
            return null;
        }
        if (!XpathUtils.isEmpty(node)) {
            byte[] decodedBytes = Base64.decode(base64EncodedString);
            return ByteBuffer.wrap(decodedBytes);
        }
        return null;
    }

    public static boolean isEmpty(Node node) {
        return node == null;
    }

    public static int nodeLength(NodeList list) {
        return list == null ? 0 : list.getLength();
    }

    private static String evaluateAsString(String expression, Node node) throws XPathExpressionException {
        if (XpathUtils.isEmpty(node)) {
            return null;
        }
        if (!expression.equals(".") && XpathUtils.asNode(expression, node) == null) {
            return null;
        }
        String s = XpathUtils.xpath().evaluate(expression, node);
        return s.trim();
    }

    public static Node asNode(String nodeName, Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        return (Node)XpathUtils.xpath().evaluate(nodeName, node, XPathConstants.NODE);
    }

    private static boolean isEmptyString(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().equals("");
    }

    public static XPath xpath() {
        return XPathFactory.newInstance().newXPath();
    }
}

