/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GetIdRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String accountId;
    private String identityPoolId;
    private Map<String, String> logins;

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public GetIdRequest withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public GetIdRequest withIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
        return this;
    }

    public Map<String, String> getLogins() {
        if (this.logins == null) {
            this.logins = new HashMap<String, String>();
        }
        return this.logins;
    }

    public void setLogins(Map<String, String> logins) {
        this.logins = logins;
    }

    public GetIdRequest withLogins(Map<String, String> logins) {
        this.setLogins(logins);
        return this;
    }

    public GetIdRequest addLoginsEntry(String key, String value) {
        if (null == this.logins) {
            this.logins = new HashMap<String, String>();
        }
        if (this.logins.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.logins.put(key, value);
        return this;
    }

    public GetIdRequest clearLoginsEntries() {
        this.logins = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: " + this.getAccountId() + ",");
        }
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getLogins() != null) {
            sb.append("Logins: " + this.getLogins());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getLogins() == null ? 0 : this.getLogins().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdRequest)) {
            return false;
        }
        GetIdRequest other = (GetIdRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getLogins() == null ^ this.getLogins() == null) {
            return false;
        }
        return other.getLogins() == null || other.getLogins().equals(this.getLogins());
    }
}

