/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.http.HttpRequestFactory;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.UrlHttpClient;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.TimingInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

public class AmazonHttpClient {
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_SDK_TRANSACTION_ID = "aws-sdk-invocation-id";
    private static final String HEADER_SDK_RETRY_INFO = "aws-sdk-retry";
    private static final int HTTP_STATUS_OK = 200;
    private static final int HTTP_STATUS_TEMP_REDIRECT = 307;
    private static final int HTTP_STATUS_MULTIPLE_CHOICES = 300;
    private static final int HTTP_STATUS_REQ_TOO_LONG = 413;
    private static final int HTTP_STATUS_SERVICE_UNAVAILABLE = 503;
    private static final int TIME_MILLISEC = 1000;
    private static final Log REQUEST_LOG = LogFactory.getLog("com.amazonaws.request");
    static final Log log = LogFactory.getLog(AmazonHttpClient.class);
    final HttpClient httpClient;
    final ClientConfiguration config;
    private final RequestMetricCollector requestMetricCollector;
    private final HttpRequestFactory requestFactory = new HttpRequestFactory();

    public AmazonHttpClient(ClientConfiguration config) {
        this(config, new UrlHttpClient(config));
    }

    @Deprecated
    public AmazonHttpClient(ClientConfiguration config, RequestMetricCollector requestMetricCollector) {
        this(config, new UrlHttpClient(config), requestMetricCollector);
    }

    public AmazonHttpClient(ClientConfiguration config, HttpClient httpClient) {
        this.config = config;
        this.httpClient = httpClient;
        this.requestMetricCollector = null;
    }

    @Deprecated
    public AmazonHttpClient(ClientConfiguration config, HttpClient httpClient, RequestMetricCollector requestMetricCollector) {
        this.config = config;
        this.httpClient = httpClient;
        this.requestMetricCollector = requestMetricCollector;
    }

    @Deprecated
    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest request) {
        return null;
    }

    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new AmazonClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler2> requestHandler2s = this.requestHandler2s(request, executionContext);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Response<T> response = null;
        try {
            response = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext);
            TimingInfo timingInfo = awsRequestMetrics.getTimingInfo().endTiming();
            this.afterResponse(request, requestHandler2s, response, timingInfo);
            return response;
        }
        catch (AmazonClientException e) {
            this.afterError(request, response, requestHandler2s, e);
            throw e;
        }
    }

    void afterError(Request<?> request, Response<?> response, List<RequestHandler2> requestHandler2s, AmazonClientException e) {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterError(request, response, e);
        }
    }

    <T> void afterResponse(Request<?> request, List<RequestHandler2> requestHandler2s, Response<T> response, TimingInfo timingInfo) {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterResponse(request, response);
        }
    }

    List<RequestHandler2> requestHandler2s(Request<?> request, ExecutionContext executionContext) {
        List<RequestHandler2> requestHandler2s = executionContext.getRequestHandler2s();
        if (requestHandler2s == null) {
            return Collections.emptyList();
        }
        for (RequestHandler2 requestHandler2 : requestHandler2s) {
            if (requestHandler2 instanceof CredentialsRequestHandler) {
                ((CredentialsRequestHandler)requestHandler2).setCredentials(executionContext.getCredentials());
            }
            requestHandler2.beforeRequest(request);
        }
        return requestHandler2s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Response<T> executeHelper(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) {
        boolean leaveHttpConnectionOpen = false;
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.addProperty(AWSRequestMetrics.Field.ServiceName, (Object)request.getServiceName());
        awsRequestMetrics.addProperty(AWSRequestMetrics.Field.ServiceEndpoint, (Object)request.getEndpoint());
        this.setUserAgent(request);
        request.addHeader(HEADER_SDK_TRANSACTION_ID, UUID.randomUUID().toString());
        int requestCount = 0;
        long lastBackoffDelay = 0L;
        URI redirectedURI = null;
        AmazonClientException retriedException = null;
        LinkedHashMap<String, String> originalParameters = new LinkedHashMap<String, String>(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>(request.getHeaders());
        InputStream originalContent = request.getContent();
        if (originalContent != null && originalContent.markSupported()) {
            originalContent.mark(-1);
        }
        AWSCredentials credentials = executionContext.getCredentials();
        Signer signer = null;
        HttpResponse httpResponse = null;
        HttpRequest httpRequest = null;
        while (true) {
            awsRequestMetrics.setCounter(AWSRequestMetrics.Field.RequestCount, (long)(++requestCount));
            if (requestCount > 1) {
                request.setParameters(originalParameters);
                request.setHeaders(originalHeaders);
                request.setContent(originalContent);
            }
            if (redirectedURI != null && request.getEndpoint() == null && request.getResourcePath() == null) {
                request.setEndpoint(URI.create(redirectedURI.getScheme() + "://" + redirectedURI.getAuthority()));
                request.setResourcePath(redirectedURI.getPath());
            }
            try {
                if (requestCount > 1) {
                    awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RetryPauseTime);
                    try {
                        lastBackoffDelay = this.pauseBeforeNextRetry(request.getOriginalRequest(), retriedException, requestCount, this.config.getRetryPolicy());
                    }
                    finally {
                        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RetryPauseTime);
                    }
                    InputStream content = request.getContent();
                    if (content != null && content.markSupported()) {
                        content.reset();
                    }
                }
                request.addHeader(HEADER_SDK_RETRY_INFO, requestCount - 1 + "/" + lastBackoffDelay);
                if (signer == null) {
                    signer = executionContext.getSignerByURI(request.getEndpoint());
                }
                if (signer != null && credentials != null) {
                    awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestSigningTime);
                    try {
                        signer.sign(request, credentials);
                    }
                    finally {
                        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestSigningTime);
                    }
                }
                if (REQUEST_LOG.isDebugEnabled()) {
                    REQUEST_LOG.debug("Sending Request: " + request.toString());
                }
                httpRequest = this.requestFactory.createHttpRequest(request, this.config, executionContext);
                retriedException = null;
                awsRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpRequestTime);
                try {
                    httpResponse = this.httpClient.execute(httpRequest);
                }
                finally {
                    awsRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpRequestTime);
                }
                if (this.isRequestSuccessful(httpResponse)) {
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)httpResponse.getStatusCode());
                    leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
                    T response = this.handleResponse(request, responseHandler, httpResponse, executionContext);
                    Response<T> response2 = new Response<T>(response, httpResponse);
                    return response2;
                }
                if (AmazonHttpClient.isTemporaryRedirect(httpResponse)) {
                    String redirectedLocation = httpResponse.getHeaders().get("Location");
                    log.debug("Redirecting to: " + redirectedLocation);
                    redirectedURI = URI.create(redirectedLocation);
                    request.setEndpoint(null);
                    request.setResourcePath(null);
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)httpResponse.getStatusCode());
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.RedirectLocation, (Object)redirectedLocation);
                    awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                    continue;
                }
                leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
                AmazonServiceException ase = this.handleErrorResponse(request, errorResponseHandler, httpResponse);
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)ase.getRequestId());
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSErrorCode, (Object)ase.getErrorCode());
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)ase.getStatusCode());
                if (!this.shouldRetry(request.getOriginalRequest(), httpRequest.getContent(), ase, requestCount, this.config.getRetryPolicy())) {
                    throw ase;
                }
                retriedException = ase;
                if (RetryUtils.isClockSkewError(ase)) {
                    int timeOffset = this.parseClockSkewOffset(httpResponse, ase);
                    SDKGlobalConfiguration.setGlobalTimeOffset(timeOffset);
                }
                this.resetRequestAfterError(request, ase);
                continue;
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
                }
                awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.Exception);
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.Exception, (Object)ioe);
                awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                AmazonClientException ace = new AmazonClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
                if (!this.shouldRetry(request.getOriginalRequest(), httpRequest.getContent(), ace, requestCount, this.config.getRetryPolicy())) {
                    throw ace;
                }
                retriedException = ace;
                this.resetRequestAfterError(request, ioe);
                continue;
            }
            catch (RuntimeException e) {
                throw this.handleUnexpectedFailure(e, awsRequestMetrics);
            }
            catch (Error e) {
                throw this.handleUnexpectedFailure(e, awsRequestMetrics);
            }
            finally {
                if (leaveHttpConnectionOpen || httpResponse == null) continue;
                try {
                    if (httpResponse.getRawContent() == null) continue;
                    httpResponse.getRawContent().close();
                }
                catch (IOException e) {
                    log.warn("Cannot close the response content.", e);
                }
                continue;
            }
            break;
        }
    }

    private <T extends Throwable> T handleUnexpectedFailure(T t, AWSRequestMetrics awsRequestMetrics) {
        awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.Exception);
        awsRequestMetrics.addProperty(AWSRequestMetrics.Field.Exception, t);
        return t;
    }

    void resetRequestAfterError(Request<?> request, Exception cause) {
        if (request.getContent() == null) {
            return;
        }
        if (!request.getContent().markSupported()) {
            throw new AmazonClientException("Encountered an exception and stream is not resettable", cause);
        }
        try {
            request.getContent().reset();
        }
        catch (IOException e) {
            throw new AmazonClientException("Encountered an exception and couldn't reset the stream to retry", cause);
        }
    }

    void setUserAgent(Request<?> request) {
        String userAgentMarker;
        RequestClientOptions opts;
        String userAgent = ClientConfiguration.DEFAULT_USER_AGENT;
        AmazonWebServiceRequest awsreq = request.getOriginalRequest();
        if (awsreq != null && (opts = awsreq.getRequestClientOptions()) != null && (userAgentMarker = opts.getClientMarker(RequestClientOptions.Marker.USER_AGENT)) != null) {
            userAgent = AmazonHttpClient.createUserAgentString(userAgent, userAgentMarker);
        }
        if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(this.config.getUserAgent())) {
            userAgent = AmazonHttpClient.createUserAgentString(userAgent, this.config.getUserAgent());
        }
        request.addHeader(HEADER_USER_AGENT, this.config.getUserAgentOverride() != null ? this.config.getUserAgentOverride() : userAgent);
    }

    static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString.trim() + " " + userAgent.trim();
    }

    public void shutdown() {
        this.httpClient.shutdown();
    }

    private boolean shouldRetry(AmazonWebServiceRequest originalRequest, InputStream inputStream, AmazonClientException exception, int requestCount, RetryPolicy retryPolicy) {
        int retries = requestCount - 1;
        int maxErrorRetry = this.config.getMaxErrorRetry();
        if (maxErrorRetry < 0 || !retryPolicy.isMaxErrorRetryInClientConfigHonored()) {
            maxErrorRetry = retryPolicy.getMaxErrorRetry();
        }
        if (retries >= maxErrorRetry) {
            return false;
        }
        if (inputStream != null && !inputStream.markSupported()) {
            if (log.isDebugEnabled()) {
                log.debug("Content not repeatable");
            }
            return false;
        }
        return retryPolicy.getRetryCondition().shouldRetry(originalRequest, exception, retries);
    }

    private static boolean isTemporaryRedirect(HttpResponse response) {
        int statusCode = response.getStatusCode();
        String location = response.getHeaders().get("Location");
        return statusCode == 307 && location != null && !location.isEmpty();
    }

    private boolean isRequestSuccessful(HttpResponse response) {
        int statusCode = response.getStatusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T handleResponse(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponse response, ExecutionContext executionContext) throws IOException {
        try {
            AmazonWebServiceResponse<T> awsResponse;
            AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            try {
                awsResponse = responseHandler.handle(response);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            }
            if (awsResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata. Response Code: " + response.getStatusCode() + ", Response Text: " + response.getStatusText());
            }
            if (REQUEST_LOG.isDebugEnabled()) {
                REQUEST_LOG.debug("Received successful response: " + response.getStatusCode() + ", AWS Request ID: " + awsResponse.getRequestId());
            }
            awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)awsResponse.getRequestId());
            return awsResponse.getResult();
        }
        catch (CRC32MismatchException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + "). Response Code: " + response.getStatusCode() + ", Response Text: " + response.getStatusText();
            throw new AmazonClientException(errorMessage, e);
        }
    }

    AmazonServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<AmazonServiceException> errorResponseHandler, HttpResponse response) throws IOException {
        int status = response.getStatusCode();
        AmazonServiceException exception = null;
        try {
            exception = errorResponseHandler.handle(response);
            REQUEST_LOG.debug("Received error response: " + exception.toString());
        }
        catch (Exception e) {
            if (status == 413) {
                exception = new AmazonServiceException("Request entity too large");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(413);
                exception.setErrorType(AmazonServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (status == 503 && "Service Unavailable".equalsIgnoreCase(response.getStatusText())) {
                exception = new AmazonServiceException("Service unavailable");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(503);
                exception.setErrorType(AmazonServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + "). Response Code: " + status + ", Response Text: " + response.getStatusText() + ", Response Headers: " + response.getHeaders();
            throw new AmazonClientException(errorMessage, e);
        }
        exception.setStatusCode(status);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private long pauseBeforeNextRetry(AmazonWebServiceRequest originalRequest, AmazonClientException previousException, int requestCount, RetryPolicy retryPolicy) {
        int retries = requestCount - 1 - 1;
        long delay = retryPolicy.getBackoffStrategy().delayBeforeNextRetry(originalRequest, previousException, retries);
        if (log.isDebugEnabled()) {
            log.debug("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries);
        }
        try {
            Thread.sleep(delay);
            return delay;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AmazonClientException(e.getMessage(), e);
        }
    }

    private String getServerDateFromException(String body) {
        int startPos = body.indexOf("(");
        int endPos = 0;
        endPos = body.contains(" + 15") ? body.indexOf(" + 15") : body.indexOf(" - 15");
        String msg = body.substring(startPos + 1, endPos);
        return msg;
    }

    int parseClockSkewOffset(HttpResponse response, AmazonServiceException exception) {
        Date deviceDate = new Date();
        Date serverDate = null;
        String serverDateStr = null;
        String responseDateHeader = response.getHeaders().get("Date");
        try {
            if (responseDateHeader == null || responseDateHeader.isEmpty()) {
                serverDateStr = this.getServerDateFromException(exception.getMessage());
                serverDate = DateUtils.parseCompressedISO8601Date(serverDateStr);
            } else {
                serverDateStr = responseDateHeader;
                serverDate = DateUtils.parseRFC822Date(serverDateStr);
            }
        }
        catch (RuntimeException e) {
            log.warn("Unable to parse clock skew offset from response: " + serverDateStr, e);
            return 0;
        }
        long diff = deviceDate.getTime() - serverDate.getTime();
        return (int)(diff / 1000L);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }
}

