/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobile.config;

import android.content.Context;
import java.io.InputStream;
import java.util.Scanner;
import org.json.JSONException;
import org.json.JSONObject;

public class AWSConfiguration {
    private static final String DEFAULT = "Default";
    private static final String DEFAULT_IDENTIFIER = "awsconfiguration";
    private JSONObject mJSONObject;
    private String configName;

    public AWSConfiguration(JSONObject jsonObject) {
        this(jsonObject, DEFAULT);
    }

    public AWSConfiguration(JSONObject jsonObject, String configName) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("JSONObject cannot be null.");
        }
        this.configName = configName;
        this.mJSONObject = jsonObject;
    }

    public AWSConfiguration(Context context) {
        this(context, AWSConfiguration.getConfigResourceId(context));
    }

    private static int getConfigResourceId(Context context) {
        try {
            return context.getResources().getIdentifier(DEFAULT_IDENTIFIER, "raw", context.getPackageName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read awsconfiguration.json please check that it is correctly formed.", e);
        }
    }

    public AWSConfiguration(Context context, int configResourceId) {
        this(context, configResourceId, DEFAULT);
    }

    public AWSConfiguration(Context context, int configResourceId, String configName) {
        this.configName = configName;
        this.readInputJson(context, configResourceId);
    }

    private void readInputJson(Context context, int resourceId) {
        try {
            InputStream inputStream = context.getResources().openRawResource(resourceId);
            Scanner in = new Scanner(inputStream);
            StringBuilder sb = new StringBuilder();
            while (in.hasNextLine()) {
                sb.append(in.nextLine());
            }
            in.close();
            this.mJSONObject = new JSONObject(sb.toString());
        }
        catch (Exception je) {
            throw new RuntimeException("Failed to read awsconfiguration.json please check that it is correctly formed.", je);
        }
    }

    public JSONObject optJsonObject(String key) {
        try {
            JSONObject value = this.mJSONObject.getJSONObject(key);
            if (value.has(this.configName)) {
                value = value.getJSONObject(this.configName);
            }
            return new JSONObject(value.toString());
        }
        catch (JSONException je) {
            return null;
        }
    }

    public String getUserAgent() {
        try {
            return this.mJSONObject.getString("UserAgent");
        }
        catch (JSONException je) {
            return "";
        }
    }

    public void setConfiguration(String configurationName) {
        this.configName = configurationName;
    }

    public String getConfiguration() {
        return this.configName;
    }

    public String toString() {
        return this.mJSONObject.toString();
    }
}

