/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    public static final String ISO8601_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String ALTERNATE_ISO8601_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String RFC822_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    public static final String COMPRESSED_DATE_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static final Map<String, ThreadLocal<SimpleDateFormat>> SDF_MAP = new HashMap<String, ThreadLocal<SimpleDateFormat>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadLocal<SimpleDateFormat> getSimpleDateFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> sdf = SDF_MAP.get(pattern);
        if (sdf == null) {
            Map<String, ThreadLocal<SimpleDateFormat>> map = SDF_MAP;
            synchronized (map) {
                sdf = SDF_MAP.get(pattern);
                if (sdf == null) {
                    sdf = new ThreadLocal<SimpleDateFormat>(){

                        @Override
                        protected SimpleDateFormat initialValue() {
                            SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.US);
                            sdf.setTimeZone(GMT_TIMEZONE);
                            sdf.setLenient(false);
                            return sdf;
                        }
                    };
                    SDF_MAP.put(pattern, sdf);
                }
            }
        }
        return sdf;
    }

    public static Date parse(String pattern, String dateString) {
        try {
            return DateUtils.getSimpleDateFormat(pattern).get().parse(dateString);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe);
        }
    }

    public static String format(String pattern, Date date) {
        return DateUtils.getSimpleDateFormat(pattern).get().format(date);
    }

    public static Date parseISO8601Date(String dateString) {
        try {
            return DateUtils.parse(ISO8601_DATE_PATTERN, dateString);
        }
        catch (IllegalArgumentException e) {
            return DateUtils.parse(ALTERNATE_ISO8601_DATE_PATTERN, dateString);
        }
    }

    public static String formatISO8601Date(Date date) {
        return DateUtils.format(ISO8601_DATE_PATTERN, date);
    }

    public static Date parseRFC822Date(String dateString) {
        return DateUtils.parse(RFC822_DATE_PATTERN, dateString);
    }

    public static String formatRFC822Date(Date date) {
        return DateUtils.format(RFC822_DATE_PATTERN, date);
    }

    public static Date parseCompressedISO8601Date(String dateString) {
        return DateUtils.parse(COMPRESSED_DATE_PATTERN, dateString);
    }

    public static Date cloneDate(Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static long numberOfDaysSinceEpoch(long milliSinceEpoch) {
        return TimeUnit.MILLISECONDS.toDays(milliSinceEpoch);
    }
}

