/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.Request;
import com.amazonaws.util.HttpUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class RuntimeHttpUtils {
    private static final String COMMA = ", ";
    private static final String SPACE = " ";

    public static URI toUri(String endpoint, ClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("ClientConfiguration cannot be null");
        }
        return RuntimeHttpUtils.toUri(endpoint, config.getProtocol());
    }

    public static URI toUri(String endpoint, Protocol protocol) {
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        if (!endpoint.contains("://")) {
            endpoint = protocol.toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL convertRequestToUrl(Request<?> request, boolean removeLeadingSlashInResourcePath, boolean urlEncode) {
        String resourcePath;
        String string = resourcePath = urlEncode ? HttpUtils.urlEncode(request.getResourcePath(), true) : request.getResourcePath();
        if (removeLeadingSlashInResourcePath && resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        String urlPath = "/" + resourcePath;
        urlPath = urlPath.replaceAll("(?<=/)/", "%2F");
        StringBuilder url = new StringBuilder(request.getEndpoint().toString());
        url.append(urlPath);
        StringBuilder queryParams = new StringBuilder();
        Map<String, String> requestParams = request.getParameters();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            queryParams = queryParams.length() > 0 ? queryParams.append("&") : queryParams.append("?");
            queryParams.append(HttpUtils.urlEncode(entry.getKey(), false)).append("=").append(HttpUtils.urlEncode(entry.getValue(), false));
        }
        url.append(queryParams.toString());
        try {
            return new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new AmazonClientException("Unable to convert request to well formed URL: " + e.getMessage(), e);
        }
    }
}

