/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.logging;

import com.amazonaws.logging.AndroidLog;
import com.amazonaws.logging.ApacheCommonsLogging;
import com.amazonaws.logging.Log;
import java.util.HashMap;
import java.util.Map;

public class LogFactory {
    private static final String TAG = LogFactory.class.getSimpleName();
    private static final String APACHE_COMMONS_LOGGING_LOGFACTORY = "org.apache.commons.logging.LogFactory";
    private static Map<String, Log> logMap = new HashMap<String, Log>();

    public static synchronized Log getLog(Class clazz) {
        return LogFactory.getLog(LogFactory.getTruncatedLogTag(clazz.getSimpleName()));
    }

    public static synchronized Log getLog(String logTag) {
        Log log = logMap.get(logTag = LogFactory.getTruncatedLogTag(logTag));
        if (log == null) {
            if (LogFactory.checkApacheCommonsLoggingExists()) {
                try {
                    log = new ApacheCommonsLogging(logTag);
                    logMap.put(logTag, log);
                }
                catch (Exception e) {
                    android.util.Log.w((String)TAG, (String)"Could not create log from org.apache.commons.logging.LogFactory", (Throwable)e);
                }
            }
            if (log == null) {
                log = new AndroidLog(logTag);
                logMap.put(logTag, log);
            }
        }
        return log;
    }

    private static boolean checkApacheCommonsLoggingExists() {
        try {
            Class<?> classObject = Class.forName(APACHE_COMMONS_LOGGING_LOGFACTORY);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        catch (Exception ex) {
            android.util.Log.e((String)TAG, (String)ex.getMessage());
            return false;
        }
    }

    private static String getTruncatedLogTag(String logTag) {
        if (logTag.length() > 23) {
            if (LogFactory.checkApacheCommonsLoggingExists()) {
                ApacheCommonsLogging log = new ApacheCommonsLogging(TAG);
                log.warn("Truncating log tag length as it exceed 23, the limit imposed by Android on certain API Levels");
            } else {
                android.util.Log.w((String)TAG, (String)"Truncating log tag length as it exceed 23, the limit imposed by Android on certain API Levels");
            }
            logTag = logTag.substring(0, 23);
        }
        return logTag;
    }
}

