/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.util.StringUtils;

public class VersionInfoUtils {
    private static final int DEFAULT_STRING_LENGTH = 128;
    private static volatile String version = "2.14.0";
    private static volatile String platform = "android";
    private static volatile String userAgent;
    private static final Log log;

    public static String getVersion() {
        return version;
    }

    public static String getPlatform() {
        return platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUserAgent() {
        if (userAgent != null) return userAgent;
        Class<VersionInfoUtils> clazz = VersionInfoUtils.class;
        synchronized (VersionInfoUtils.class) {
            if (userAgent != null) return userAgent;
            VersionInfoUtils.initializeUserAgent();
            // ** MonitorExit[var0] (shouldn't be in output)
            return userAgent;
        }
    }

    private static void initializeUserAgent() {
        userAgent = VersionInfoUtils.userAgent();
    }

    static String userAgent() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("aws-sdk-");
        buffer.append(StringUtils.lowerCase(VersionInfoUtils.getPlatform()));
        buffer.append("/");
        buffer.append(VersionInfoUtils.getVersion());
        buffer.append(" ");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.name")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.version")));
        buffer.append(" ");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.name")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.version")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.version")));
        String language = System.getProperty("user.language");
        String region = System.getProperty("user.region");
        if (language != null && region != null) {
            buffer.append(" ");
            buffer.append(VersionInfoUtils.replaceSpaces(language));
            buffer.append("_");
            buffer.append(VersionInfoUtils.replaceSpaces(region));
        }
        return buffer.toString();
    }

    private static String replaceSpaces(String input) {
        return input.replace(' ', '_');
    }

    static {
        log = LogFactory.getLog(VersionInfoUtils.class);
    }
}

