/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.keyvaluestore;

import android.content.Context;
import android.content.SharedPreferences;
import com.amazonaws.internal.keyvaluestore.KeyProvider;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.util.Base64;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class KeyProvider10
implements KeyProvider {
    private static final Log logger = LogFactory.getLog(KeyProvider10.class.getSimpleName());
    static final String AES_KEY_ALGORITHM = "AES";
    static final int CIPHER_AES_GCM_NOPADDING_KEY_LENGTH_IN_BITS = 256;
    static final String SHARED_PREFERENCES_KEY_NAME_FOR_ENCRYPTION_KEY = "AesGcmNoPaddingEncryption10-encryption-key";
    private SecureRandom secureRandom = new SecureRandom();
    private static final Object LOCK = new Object();

    KeyProvider10() {
    }

    @Override
    public Key getKey(SharedPreferences sharedPreferences, String keyAlias, Context context) {
        Object object = LOCK;
        synchronized (object) {
            try {
                if (sharedPreferences.contains(SHARED_PREFERENCES_KEY_NAME_FOR_ENCRYPTION_KEY)) {
                    String keyInStringFormat = sharedPreferences.getString(SHARED_PREFERENCES_KEY_NAME_FOR_ENCRYPTION_KEY, null);
                    return new SecretKeySpec(Base64.decode(keyInStringFormat), AES_KEY_ALGORITHM);
                }
                KeyGenerator generator = KeyGenerator.getInstance(AES_KEY_ALGORITHM);
                generator.init(256, this.secureRandom);
                SecretKey secretKey = generator.generateKey();
                sharedPreferences.edit().putString(SHARED_PREFERENCES_KEY_NAME_FOR_ENCRYPTION_KEY, Base64.encodeAsString(secretKey.getEncoded())).apply();
                return secretKey;
            }
            catch (Exception ex) {
                logger.error("Error in loading the key from keystore.");
                throw new IllegalStateException(ex);
            }
        }
    }
}

