/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.keyvaluestore;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import com.amazonaws.internal.keyvaluestore.KeyProvider;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;

class KeyProvider23
implements KeyProvider {
    private static final Log logger = LogFactory.getLog(KeyProvider23.class);
    static final String AES_KEY_ALGORITHM = "AES";
    static final int CIPHER_AES_GCM_NOPADDING_KEY_LENGTH_IN_BITS = 256;
    static final String ANDROID_KEY_STORE_NAME = "AndroidKeyStore";
    private static final Object LOCK = new Object();

    KeyProvider23() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Key getKey(SharedPreferences sharedPreferences, String keyAlias, Context context) {
        Object object = LOCK;
        synchronized (object) {
            try {
                KeyStore keyStore = KeyStore.getInstance(ANDROID_KEY_STORE_NAME);
                keyStore.load(null);
                if (!keyStore.containsAlias(keyAlias)) {
                    KeyGenerator generator = KeyGenerator.getInstance(AES_KEY_ALGORITHM, ANDROID_KEY_STORE_NAME);
                    generator.init((AlgorithmParameterSpec)new KeyGenParameterSpec.Builder(keyAlias, 3).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(256).setRandomizedEncryptionRequired(false).build());
                    return generator.generateKey();
                }
                logger.debug("AndroidKeyStore contains keyAlias " + keyAlias);
                return keyStore.getKey(keyAlias, null);
            }
            catch (Exception ex) {
                logger.error("Error in accessing the Android KeyStore.", ex);
                return null;
            }
        }
    }
}

