/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal.keyvaluestore;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.amazonaws.internal.keyvaluestore.KeyProvider;
import com.amazonaws.internal.keyvaluestore.KeyProvider10;
import com.amazonaws.internal.keyvaluestore.KeyProvider18;
import com.amazonaws.internal.keyvaluestore.KeyProvider23;
import com.amazonaws.logging.Log;
import com.amazonaws.logging.LogFactory;
import com.amazonaws.util.Base64;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class AWSKeyValueStore {
    private static final Log logger = LogFactory.getLog(AWSKeyValueStore.class);
    static Map<String, HashMap<String, String>> cacheFactory = new HashMap<String, HashMap<String, String>>();
    private Map<String, String> cache;
    boolean isPersistenceEnabled = true;
    SharedPreferences sharedPreferences;
    SharedPreferences sharedPreferencesForEncryptionKey;
    private KeyProvider keyProvider;
    private Key encryptionKey;
    private SecureRandom secureRandom;
    private String keyAlias;
    private static final int ANDROID_API_LEVEL_23 = 23;
    private static final int ANDROID_API_LEVEL_18 = 18;
    private static final int ANDROID_API_LEVEL_10 = 10;
    static final String CIPHER_AES_GCM_NOPADDING = "AES/GCM/NoPadding";
    static final int CIPHER_AES_GCM_NOPADDING_IV_LENGTH_IN_BYTES = 12;
    static final int CIPHER_AES_GCM_NOPADDING_TAG_LENGTH_LENGTH_IN_BITS = 128;
    static final String CHARSET_NAME = "UTF-8";
    static final String SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX = ".encrypted";
    static final String SHARED_PREFERENCES_IV_SUFFIX = ".iv";
    static final String SHARED_PREFERENCES_STORE_VERSION_SUFFIX = ".keyvaluestoreversion";
    static final String SHARED_PREFERENCES_ENCRYPTION_KEY_NAMPESPACE_SUFFIX = ".encryptionkey";
    static final String KEY_STORE_ALIAS_FOR_AES_SUFFIX = ".aesKeyStoreAlias";
    static final String KEY_STORE_ALIAS_FOR_RSA_SUFFIX = ".rsaKeyStoreAlias";
    private static final int AWS_KEY_VALUE_STORE_VERSION = 1;
    private static final Object LOCK = new Object();
    private int apiLevel;

    private static Map<String, String> getCacheForKey(String key) {
        if (cacheFactory.containsKey(key)) {
            return cacheFactory.get(key);
        }
        HashMap<String, String> cache = new HashMap<String, String>();
        cacheFactory.put(key, cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWSKeyValueStore(Context context, String sharedPreferencesName, boolean isPersistenceEnabled) {
        Object object = LOCK;
        synchronized (object) {
            this.isPersistenceEnabled = isPersistenceEnabled;
            this.secureRandom = new SecureRandom();
            this.cache = AWSKeyValueStore.getCacheForKey(sharedPreferencesName);
            this.apiLevel = Build.VERSION.SDK_INT;
            if (this.isPersistenceEnabled) {
                this.sharedPreferences = context.getSharedPreferences(sharedPreferencesName, 0);
                this.sharedPreferencesForEncryptionKey = context.getSharedPreferences(sharedPreferencesName + SHARED_PREFERENCES_ENCRYPTION_KEY_NAMPESPACE_SUFFIX, 0);
                logger.info("Detected Android API Level = " + this.apiLevel);
                if (this.apiLevel >= 23) {
                    this.keyAlias = sharedPreferencesName + KEY_STORE_ALIAS_FOR_AES_SUFFIX;
                    logger.info("Using keyAlias = " + this.keyAlias);
                    this.keyProvider = new KeyProvider23();
                    this.encryptionKey = this.keyProvider.getKey(this.sharedPreferencesForEncryptionKey, this.keyAlias, context);
                } else if (this.apiLevel >= 18) {
                    this.keyAlias = sharedPreferencesName + KEY_STORE_ALIAS_FOR_RSA_SUFFIX;
                    logger.info("Using keyAlias = " + this.keyAlias);
                    this.keyProvider = new KeyProvider18();
                    this.encryptionKey = this.keyProvider.getKey(this.sharedPreferencesForEncryptionKey, this.keyAlias, context);
                } else if (this.apiLevel >= 10) {
                    this.keyProvider = new KeyProvider10();
                    this.encryptionKey = this.keyProvider.getKey(this.sharedPreferencesForEncryptionKey, null, context);
                } else {
                    logger.error("API Level " + String.valueOf(Build.VERSION.SDK_INT) + " not supported by the SDK. Setting persistence to false.");
                    this.isPersistenceEnabled = false;
                }
                logger.info("Creating the AWSKeyValueStore with key for sharedPreferences = " + sharedPreferencesName);
                this.onMigrateFromNoEncryption();
            } else {
                logger.info("Persistence is disabled. Data will be accessed from memory.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistenceEnabled(boolean isPersistenceEnabled) {
        Object object = LOCK;
        synchronized (object) {
            this.isPersistenceEnabled = isPersistenceEnabled;
            if (!isPersistenceEnabled) {
                this.sharedPreferences.edit().clear().apply();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        Object object = LOCK;
        synchronized (object) {
            if (this.isPersistenceEnabled) {
                String actualKey = key + SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX;
                return this.sharedPreferences.contains(actualKey);
            }
            return this.cache.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String get(String key) {
        Object object = LOCK;
        synchronized (object) {
            if (this.isPersistenceEnabled) {
                String actualKey = key + SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX;
                if (!this.sharedPreferences.contains(actualKey)) {
                    return null;
                }
                try {
                    int keyValueStoreVersion = Integer.parseInt(this.sharedPreferences.getString(actualKey + SHARED_PREFERENCES_STORE_VERSION_SUFFIX, null));
                    if (keyValueStoreVersion != 1) {
                        logger.error("The version of the data read from SharedPreferences for " + key + " does not match the version of the store.");
                        return null;
                    }
                    String encryptedData = this.sharedPreferences.getString(actualKey, null);
                    byte[] iv = this.getInitializationVector(actualKey);
                    String decryptedDataInString = this.decrypt(this.apiLevel >= 23 ? new GCMParameterSpec(128, iv) : new IvParameterSpec(iv), encryptedData);
                    this.cache.put(key, decryptedDataInString);
                    return decryptedDataInString;
                }
                catch (Exception ex) {
                    logger.error("Error in decrypting data. ", ex);
                    return null;
                }
            }
            return this.cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, String value) {
        Object object = LOCK;
        synchronized (object) {
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            this.cache.put(key, value);
            if (this.isPersistenceEnabled) {
                if (value == null) {
                    logger.debug("Value is null. Removing the data, IV and version from SharedPreferences");
                    this.remove(key);
                    return;
                }
                String actualKey = key + SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX;
                try {
                    byte[] iv = this.generateInitializationVector();
                    String encryptedData = this.encrypt(this.apiLevel >= 23 ? new GCMParameterSpec(128, iv) : new IvParameterSpec(iv), value);
                    this.sharedPreferences.edit().putString(actualKey, encryptedData).putString(actualKey + SHARED_PREFERENCES_IV_SUFFIX, Base64.encodeAsString(iv)).putString(actualKey + SHARED_PREFERENCES_STORE_VERSION_SUFFIX, String.valueOf(1)).apply();
                }
                catch (Exception ex) {
                    logger.error("Error in encrypting data. ", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Object object = LOCK;
        synchronized (object) {
            this.cache.remove(key);
            if (this.isPersistenceEnabled) {
                String actualKey = key + SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX;
                this.sharedPreferences.edit().remove(actualKey).remove(actualKey + SHARED_PREFERENCES_IV_SUFFIX).remove(actualKey + SHARED_PREFERENCES_STORE_VERSION_SUFFIX).apply();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = LOCK;
        synchronized (object) {
            this.cache.clear();
            if (this.isPersistenceEnabled) {
                this.sharedPreferences.edit().clear().apply();
            }
        }
    }

    private void onMigrateFromNoEncryption() {
        for (String spKey : this.sharedPreferences.getAll().keySet()) {
            if (spKey.endsWith(SHARED_PREFERENCES_DATA_IDENTIFIER_SUFFIX) || spKey.endsWith(SHARED_PREFERENCES_IV_SUFFIX) || spKey.endsWith(SHARED_PREFERENCES_STORE_VERSION_SUFFIX)) continue;
            this.put(spKey, this.sharedPreferences.getString(spKey, null));
            this.sharedPreferences.edit().remove(spKey).apply();
        }
    }

    private String encrypt(AlgorithmParameterSpec ivSpec, String data) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_AES_GCM_NOPADDING);
            cipher.init(1, this.encryptionKey, ivSpec);
            byte[] encryptedData = cipher.doFinal(data.getBytes(CHARSET_NAME));
            return Base64.encodeAsString(encryptedData);
        }
        catch (Exception ex) {
            logger.error("Error in encrypting data. ", ex);
            return null;
        }
    }

    private String decrypt(AlgorithmParameterSpec ivSpec, String encryptedData) {
        try {
            byte[] encryptedDecodedData = Base64.decode(encryptedData);
            Cipher cipher = Cipher.getInstance(CIPHER_AES_GCM_NOPADDING);
            cipher.init(2, this.encryptionKey, ivSpec);
            byte[] decryptedData = cipher.doFinal(encryptedDecodedData);
            return new String(decryptedData, CHARSET_NAME);
        }
        catch (Exception ex) {
            logger.error("Error in decrypting data. ", ex);
            return null;
        }
    }

    private byte[] getInitializationVector(String keyOfDataInSharedPreferences) {
        String keyOfIV = keyOfDataInSharedPreferences + SHARED_PREFERENCES_IV_SUFFIX;
        if (this.sharedPreferences.contains(keyOfIV)) {
            return Base64.decode(this.sharedPreferences.getString(keyOfIV, null));
        }
        return null;
    }

    private byte[] generateInitializationVector() {
        byte[] initializationVector = new byte[12];
        this.secureRandom.nextBytes(initializationVector);
        return initializationVector;
    }
}

