/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.StringWriter;

public class MergeDeveloperIdentitiesRequestMarshaller
implements Marshaller<Request<MergeDeveloperIdentitiesRequest>, MergeDeveloperIdentitiesRequest> {
    @Override
    public Request<MergeDeveloperIdentitiesRequest> marshall(MergeDeveloperIdentitiesRequest mergeDeveloperIdentitiesRequest) {
        if (mergeDeveloperIdentitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<MergeDeveloperIdentitiesRequest> request = new DefaultRequest<MergeDeveloperIdentitiesRequest>(mergeDeveloperIdentitiesRequest, "AmazonCognitoIdentity");
        String target = "AWSCognitoIdentityService.MergeDeveloperIdentities";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter(stringWriter);
            jsonWriter.beginObject();
            if (mergeDeveloperIdentitiesRequest.getSourceUserIdentifier() != null) {
                jsonWriter.name("SourceUserIdentifier").value(mergeDeveloperIdentitiesRequest.getSourceUserIdentifier());
            }
            if (mergeDeveloperIdentitiesRequest.getDestinationUserIdentifier() != null) {
                jsonWriter.name("DestinationUserIdentifier").value(mergeDeveloperIdentitiesRequest.getDestinationUserIdentifier());
            }
            if (mergeDeveloperIdentitiesRequest.getDeveloperProviderName() != null) {
                jsonWriter.name("DeveloperProviderName").value(mergeDeveloperIdentitiesRequest.getDeveloperProviderName());
            }
            if (mergeDeveloperIdentitiesRequest.getIdentityPoolId() != null) {
                jsonWriter.name("IdentityPoolId").value(mergeDeveloperIdentitiesRequest.getIdentityPoolId());
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

