/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.RequestClientOptions;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.CredentialsRequestHandler;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClientFactory;
import com.amazonaws.http.HttpMethodReleaseInputStream;
import com.amazonaws.http.HttpRequestFactory;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.IdleConnectionReaper;
import com.amazonaws.internal.CRC32MismatchException;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.Header;
import com.amazonaws.org.apache.http.HttpEntity;
import com.amazonaws.org.apache.http.HttpEntityEnclosingRequest;
import com.amazonaws.org.apache.http.client.HttpClient;
import com.amazonaws.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.amazonaws.org.apache.http.client.methods.HttpRequestBase;
import com.amazonaws.org.apache.http.conn.ClientConnectionManager;
import com.amazonaws.org.apache.http.conn.scheme.Scheme;
import com.amazonaws.org.apache.http.conn.scheme.SchemeRegistry;
import com.amazonaws.org.apache.http.conn.ssl.SSLSocketFactory;
import com.amazonaws.org.apache.http.pool.ConnPoolControl;
import com.amazonaws.org.apache.http.pool.PoolStats;
import com.amazonaws.org.apache.http.protocol.BasicHttpContext;
import com.amazonaws.org.apache.http.protocol.HttpContext;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CountingInputStream;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.ResponseMetadataCache;
import com.amazonaws.util.TimingInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.net.ssl.SSLContext;

public class AmazonHttpClient {
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final Log requestLog;
    static final Log log;
    private final HttpClient httpClient;
    private final ClientConfiguration config;
    private final ResponseMetadataCache responseMetadataCache = new ResponseMetadataCache(50);
    private final RequestMetricCollector requestMetricCollector;
    private static final HttpRequestFactory httpRequestFactory;
    private static final HttpClientFactory httpClientFactory;

    public AmazonHttpClient(ClientConfiguration config) {
        this(config, null);
    }

    public AmazonHttpClient(ClientConfiguration config, RequestMetricCollector requestMetricCollector) {
        this(config, httpClientFactory.createHttpClient(config), requestMetricCollector);
    }

    AmazonHttpClient(ClientConfiguration config, HttpClient httpClient, RequestMetricCollector requestMetricCollector) {
        this.config = config;
        this.httpClient = httpClient;
        this.requestMetricCollector = requestMetricCollector;
    }

    public ResponseMetadata getResponseMetadataForRequest(AmazonWebServiceRequest request) {
        return this.responseMetadataCache.get(request);
    }

    public void disableStrictHostnameVerification() {
        if (System.getProperty("com.amazonaws.sdk.disableCertChecking") != null) {
            return;
        }
        try {
            SchemeRegistry schemeRegistry = this.httpClient.getConnectionManager().getSchemeRegistry();
            SSLSocketFactory sf = new SSLSocketFactory(SSLContext.getDefault(), SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", 443, sf);
            schemeRegistry.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to access default SSL context to disable strict hostname verification");
        }
    }

    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> responseHandler, HttpResponseHandler<AmazonServiceException> errorResponseHandler, ExecutionContext executionContext) throws AmazonClientException, AmazonServiceException {
        if (executionContext == null) {
            throw new AmazonClientException("Internal SDK Error: No execution context parameter specified.");
        }
        List<RequestHandler2> requestHandler2s = this.requestHandler2s(request, executionContext);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Response<T> response = null;
        try {
            response = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext);
            TimingInfo timingInfo = awsRequestMetrics.getTimingInfo().endTiming();
            this.afterResponse(request, requestHandler2s, response, timingInfo);
            return response;
        }
        catch (AmazonClientException e) {
            this.afterError(request, response, requestHandler2s, e);
            throw e;
        }
    }

    private void afterError(Request<?> request, Response<?> response, List<RequestHandler2> requestHandler2s, AmazonClientException e) {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterError(request, response, e);
        }
    }

    private <T> void afterResponse(Request<?> request, List<RequestHandler2> requestHandler2s, Response<T> response, TimingInfo timingInfo) {
        for (RequestHandler2 handler2 : requestHandler2s) {
            handler2.afterResponse(request, response);
        }
    }

    private List<RequestHandler2> requestHandler2s(Request<?> request, ExecutionContext executionContext) {
        List<RequestHandler2> requestHandler2s = executionContext.getRequestHandler2s();
        if (requestHandler2s == null) {
            return Collections.emptyList();
        }
        for (RequestHandler2 requestHandler2 : requestHandler2s) {
            if (requestHandler2 instanceof CredentialsRequestHandler) {
                ((CredentialsRequestHandler)requestHandler2).setCredentials(executionContext.getCredentials());
            }
            requestHandler2.beforeRequest(request);
        }
        return requestHandler2s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Response<T> executeHelper(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> httpResponseHandler, HttpResponseHandler<AmazonServiceException> httpResponseHandler2, ExecutionContext executionContext) throws AmazonClientException, AmazonServiceException {
        boolean bl = false;
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.ServiceName, (Object)request.getServiceName());
        aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.ServiceEndpoint, (Object)request.getEndpoint());
        this.setUserAgent(request);
        int n = 0;
        URI uRI = null;
        HttpEntity httpEntity = null;
        Object object = null;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.putAll(request.getParameters());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(request.getHeaders());
        AWSCredentials aWSCredentials = executionContext.getCredentials();
        Signer signer = null;
        while (true) {
            Object object2;
            aWSRequestMetrics.setCounter(AWSRequestMetrics.Field.RequestCount, (long)(++n));
            if (n > 1) {
                request.setParameters(linkedHashMap);
                request.setHeaders(hashMap);
            }
            HttpRequestBase httpRequestBase = null;
            com.amazonaws.org.apache.http.HttpResponse httpResponse = null;
            try {
                Object object3;
                if (signer == null) {
                    signer = executionContext.getSignerByURI(request.getEndpoint());
                }
                if (signer != null && aWSCredentials != null) {
                    aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestSigningTime);
                    try {
                        signer.sign(request, aWSCredentials);
                    }
                    finally {
                        aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestSigningTime);
                    }
                }
                if (requestLog.isDebugEnabled()) {
                    requestLog.debug("Sending Request: " + request.toString());
                }
                if ((httpRequestBase = httpRequestFactory.createHttpRequest(request, this.config, executionContext)) instanceof HttpEntityEnclosingRequest) {
                    httpEntity = ((HttpEntityEnclosingRequest)((Object)httpRequestBase)).getEntity();
                }
                if (uRI != null) {
                    httpRequestBase.setURI(uRI);
                }
                if (n > 1) {
                    aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RetryPauseTime);
                    try {
                        this.pauseBeforeNextRetry(request.getOriginalRequest(), (AmazonClientException)object, n, this.config.getRetryPolicy());
                    }
                    finally {
                        aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RetryPauseTime);
                    }
                }
                if (httpEntity != null) {
                    object3 = httpEntity.getContent();
                    if (n > 1) {
                        if (((InputStream)object3).markSupported()) {
                            ((InputStream)object3).reset();
                            ((InputStream)object3).mark(-1);
                        }
                    } else if (((InputStream)object3).markSupported()) {
                        ((InputStream)object3).mark(-1);
                    }
                }
                this.captureConnectionPoolMetrics(this.httpClient.getConnectionManager(), aWSRequestMetrics);
                object3 = new BasicHttpContext();
                object3.setAttribute(AWSRequestMetrics.class.getSimpleName(), aWSRequestMetrics);
                object = null;
                aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.HttpRequestTime);
                try {
                    httpResponse = this.httpClient.execute(httpRequestBase, (HttpContext)object3);
                }
                finally {
                    aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.HttpRequestTime);
                }
                if (this.isRequestSuccessful(httpResponse)) {
                    aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)httpResponse.getStatusLine().getStatusCode());
                    bl = httpResponseHandler.needsConnectionLeftOpen();
                    object2 = this.createResponse(httpRequestBase, request, httpResponse);
                    T t = this.handleResponse(request, httpResponseHandler, httpRequestBase, (HttpResponse)object2, httpResponse, executionContext);
                    Response<T> response = new Response<T>(t, (HttpResponse)object2);
                    return response;
                }
                if (AmazonHttpClient.isTemporaryRedirect(httpResponse)) {
                    object2 = httpResponse.getHeaders("location");
                    String string = object2[0].getValue();
                    log.debug("Redirecting to: " + string);
                    uRI = URI.create(string);
                    httpRequestBase.setURI(uRI);
                    aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)httpResponse.getStatusLine().getStatusCode());
                    aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.RedirectLocation, (Object)string);
                    aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                    continue;
                }
                bl = httpResponseHandler2.needsConnectionLeftOpen();
                object2 = this.handleErrorResponse(request, httpResponseHandler2, httpRequestBase, httpResponse);
                aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)((AmazonServiceException)object2).getRequestId());
                aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSErrorCode, (Object)((AmazonServiceException)object2).getErrorCode());
                aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.StatusCode, (Object)((AmazonServiceException)object2).getStatusCode());
                if (!this.shouldRetry(request.getOriginalRequest(), httpRequestBase, (AmazonClientException)object2, n, this.config.getRetryPolicy())) {
                    throw object2;
                }
                object = object2;
                if (RetryUtils.isClockSkewError((AmazonServiceException)object2)) {
                    int n2 = this.parseClockSkewOffset(httpResponse, (AmazonServiceException)object2);
                    SDKGlobalConfiguration.setGlobalTimeOffset(n2);
                }
                this.resetRequestAfterError(request, (Exception)object2);
                continue;
            }
            catch (IOException iOException) {
                if (log.isInfoEnabled()) {
                    log.info("Unable to execute HTTP request: " + iOException.getMessage(), iOException);
                }
                aWSRequestMetrics.incrementCounter(AWSRequestMetrics.Field.Exception);
                aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.Exception, (Object)iOException);
                aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, null);
                object2 = new AmazonClientException("Unable to execute HTTP request: " + iOException.getMessage(), iOException);
                if (!this.shouldRetry(request.getOriginalRequest(), httpRequestBase, (AmazonClientException)object2, n, this.config.getRetryPolicy())) {
                    throw object2;
                }
                object = object2;
                this.resetRequestAfterError(request, iOException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw this.handleUnexpectedFailure(runtimeException, aWSRequestMetrics);
            }
            catch (Error error) {
                throw this.handleUnexpectedFailure(error, aWSRequestMetrics);
            }
            finally {
                if (bl) continue;
                try {
                    if (httpResponse == null || httpResponse.getEntity() == null || httpResponse.getEntity().getContent() == null) continue;
                    httpResponse.getEntity().getContent().close();
                }
                catch (IOException iOException) {
                    log.warn("Cannot close the response content.", iOException);
                }
                continue;
            }
            break;
        }
    }

    private void captureConnectionPoolMetrics(ClientConnectionManager connectionManager, AWSRequestMetrics awsRequestMetrics) {
        if (awsRequestMetrics.isEnabled() && connectionManager instanceof ConnPoolControl) {
            ConnPoolControl control = (ConnPoolControl)((Object)connectionManager);
            PoolStats stats = control.getTotalStats();
            awsRequestMetrics.setCounter(AWSRequestMetrics.Field.HttpClientPoolAvailableCount, (long)stats.getAvailable());
            awsRequestMetrics.setCounter(AWSRequestMetrics.Field.HttpClientPoolLeasedCount, (long)stats.getLeased());
            awsRequestMetrics.setCounter(AWSRequestMetrics.Field.HttpClientPoolPendingCount, (long)stats.getPending());
        }
    }

    private <T extends Throwable> T handleUnexpectedFailure(T t, AWSRequestMetrics awsRequestMetrics) {
        awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.Exception);
        awsRequestMetrics.addProperty(AWSRequestMetrics.Field.Exception, t);
        return t;
    }

    private void resetRequestAfterError(Request<?> request, Exception exception) throws AmazonClientException {
        if (request.getContent() == null) {
            return;
        }
        if (!request.getContent().markSupported()) {
            throw new AmazonClientException("Encountered an exception and stream is not resettable", exception);
        }
        try {
            request.getContent().reset();
        }
        catch (IOException iOException) {
            throw new AmazonClientException("Encountered an exception and couldn't reset the stream to retry", exception);
        }
    }

    private void setUserAgent(Request<?> request) {
        String string;
        RequestClientOptions requestClientOptions;
        AmazonWebServiceRequest amazonWebServiceRequest;
        String string2 = this.config.getUserAgent();
        if (!string2.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            string2 = string2 + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        if (string2 != null) {
            request.addHeader(HEADER_USER_AGENT, string2);
        }
        if ((amazonWebServiceRequest = request.getOriginalRequest()) != null && (requestClientOptions = amazonWebServiceRequest.getRequestClientOptions()) != null && (string = requestClientOptions.getClientMarker(RequestClientOptions.Marker.USER_AGENT)) != null) {
            request.addHeader(HEADER_USER_AGENT, AmazonHttpClient.createUserAgentString(string2, string));
        }
    }

    private static String createUserAgentString(String string, String string2) {
        if (string.contains(string2)) {
            return string;
        }
        return string.trim() + " " + string2.trim();
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.httpClient.getConnectionManager());
        this.httpClient.getConnectionManager().shutdown();
    }

    private boolean shouldRetry(AmazonWebServiceRequest amazonWebServiceRequest, HttpRequestBase httpRequestBase, AmazonClientException amazonClientException, int n, RetryPolicy retryPolicy) {
        HttpEntity httpEntity;
        int n2 = n - 1;
        int n3 = this.config.getMaxErrorRetry();
        if (n3 < 0 || !retryPolicy.isMaxErrorRetryInClientConfigHonored()) {
            n3 = retryPolicy.getMaxErrorRetry();
        }
        if (n2 >= n3) {
            return false;
        }
        if (httpRequestBase instanceof HttpEntityEnclosingRequest && (httpEntity = ((HttpEntityEnclosingRequest)((Object)httpRequestBase)).getEntity()) != null && !httpEntity.isRepeatable()) {
            if (log.isDebugEnabled()) {
                log.debug("Entity not repeatable");
            }
            return false;
        }
        return retryPolicy.getRetryCondition().shouldRetry(amazonWebServiceRequest, amazonClientException, n2);
    }

    private static boolean isTemporaryRedirect(com.amazonaws.org.apache.http.HttpResponse httpResponse) {
        int n = httpResponse.getStatusLine().getStatusCode();
        return n == 307 && httpResponse.getHeaders("Location") != null && httpResponse.getHeaders("Location").length > 0;
    }

    private boolean isRequestSuccessful(com.amazonaws.org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T handleResponse(Request<?> request, HttpResponseHandler<AmazonWebServiceResponse<T>> httpResponseHandler, HttpRequestBase httpRequestBase, HttpResponse httpResponse, com.amazonaws.org.apache.http.HttpResponse httpResponse2, ExecutionContext executionContext) throws IOException {
        Object object;
        if (httpResponseHandler.needsConnectionLeftOpen() && httpRequestBase instanceof HttpEntityEnclosingRequest) {
            object = (HttpEntityEnclosingRequest)((Object)httpRequestBase);
            httpResponse.setContent(new HttpMethodReleaseInputStream((HttpEntityEnclosingRequest)object));
        }
        try {
            AmazonWebServiceResponse<T> amazonWebServiceResponse;
            object = null;
            if (System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null) {
                object = new CountingInputStream(httpResponse.getContent());
                httpResponse.setContent((InputStream)object);
            }
            AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            try {
                amazonWebServiceResponse = httpResponseHandler.handle(httpResponse);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.ResponseProcessingTime);
            }
            if (object != null) {
                aWSRequestMetrics.setCounter(AWSRequestMetrics.Field.BytesProcessed, ((CountingInputStream)object).getByteCount());
            }
            if (amazonWebServiceResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata. Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText());
            }
            this.responseMetadataCache.add(request.getOriginalRequest(), amazonWebServiceResponse.getResponseMetadata());
            if (requestLog.isDebugEnabled()) {
                requestLog.debug("Received successful response: " + httpResponse2.getStatusLine().getStatusCode() + ", AWS Request ID: " + amazonWebServiceResponse.getRequestId());
            }
            aWSRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)amazonWebServiceResponse.getRequestId());
            return amazonWebServiceResponse.getResult();
        }
        catch (CRC32MismatchException cRC32MismatchException) {
            throw cRC32MismatchException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = "Unable to unmarshall response (" + exception.getMessage() + "). Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText();
            throw new AmazonClientException(string, exception);
        }
    }

    private AmazonServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<AmazonServiceException> httpResponseHandler, HttpRequestBase httpRequestBase, com.amazonaws.org.apache.http.HttpResponse httpResponse) throws IOException {
        Object object;
        int n = httpResponse.getStatusLine().getStatusCode();
        HttpResponse httpResponse2 = this.createResponse(httpRequestBase, request, httpResponse);
        if (httpResponseHandler.needsConnectionLeftOpen() && httpRequestBase instanceof HttpEntityEnclosingRequestBase) {
            object = (HttpEntityEnclosingRequestBase)httpRequestBase;
            httpResponse2.setContent(new HttpMethodReleaseInputStream((HttpEntityEnclosingRequest)object));
        }
        object = null;
        try {
            object = httpResponseHandler.handle(httpResponse2);
            requestLog.debug("Received error response: " + ((Throwable)object).toString());
        }
        catch (Exception exception) {
            if (n == 413) {
                object = new AmazonServiceException("Request entity too large");
                ((AmazonServiceException)object).setServiceName(request.getServiceName());
                ((AmazonServiceException)object).setStatusCode(413);
                ((AmazonServiceException)object).setErrorType(AmazonServiceException.ErrorType.Client);
                ((AmazonServiceException)object).setErrorCode("Request entity too large");
            }
            if (n == 503 && "Service Unavailable".equalsIgnoreCase(httpResponse.getStatusLine().getReasonPhrase())) {
                object = new AmazonServiceException("Service unavailable");
                ((AmazonServiceException)object).setServiceName(request.getServiceName());
                ((AmazonServiceException)object).setStatusCode(503);
                ((AmazonServiceException)object).setErrorType(AmazonServiceException.ErrorType.Service);
                ((AmazonServiceException)object).setErrorCode("Service unavailable");
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            String string = "Unable to unmarshall error response (" + exception.getMessage() + "). Response Code: " + n + ", Response Text: " + httpResponse.getStatusLine().getReasonPhrase();
            throw new AmazonClientException(string, exception);
        }
        ((AmazonServiceException)object).setStatusCode(n);
        ((AmazonServiceException)object).setServiceName(request.getServiceName());
        ((Throwable)object).fillInStackTrace();
        return object;
    }

    private HttpResponse createResponse(HttpRequestBase method, Request<?> request, com.amazonaws.org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private void pauseBeforeNextRetry(AmazonWebServiceRequest amazonWebServiceRequest, AmazonClientException amazonClientException, int n, RetryPolicy retryPolicy) {
        int n2 = n - 1 - 1;
        long l = retryPolicy.getBackoffStrategy().delayBeforeNextRetry(amazonWebServiceRequest, amazonClientException, n2);
        if (log.isDebugEnabled()) {
            log.debug("Retriable error detected, will retry in " + l + "ms, attempt number: " + n2);
        }
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new AmazonClientException(interruptedException.getMessage(), interruptedException);
        }
    }

    private String getServerDateFromException(String string) {
        int n = string.indexOf("(");
        int n2 = 0;
        n2 = string.contains(" + 15") ? string.indexOf(" + 15") : string.indexOf(" - 15");
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    private int parseClockSkewOffset(com.amazonaws.org.apache.http.HttpResponse httpResponse, AmazonServiceException amazonServiceException) {
        Date date = new Date();
        Date date2 = null;
        String string = null;
        Header[] headerArray = httpResponse.getHeaders("Date");
        try {
            if (headerArray.length == 0) {
                string = this.getServerDateFromException(amazonServiceException.getMessage());
                date2 = DateUtils.parseCompressedISO8601Date(string);
            } else {
                string = headerArray[0].getValue();
                date2 = DateUtils.parseRFC822Date(string);
            }
        }
        catch (RuntimeException runtimeException) {
            log.warn("Unable to parse clock skew offset from response: " + string, runtimeException);
            return 0;
        }
        long l = date.getTime() - date2.getTime();
        return (int)(l / 1000L);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public RequestMetricCollector getRequestMetricCollector() {
        return this.requestMetricCollector;
    }

    static {
        String string;
        requestLog = LogFactory.getLog("com.amazonaws.request");
        log = LogFactory.getLog(AmazonHttpClient.class);
        httpRequestFactory = new HttpRequestFactory();
        httpClientFactory = new HttpClientFactory();
        List<String> list = Arrays.asList("1.6.0_06", "1.6.0_13", "1.6.0_17");
        if (list.contains(string = System.getProperty("java.version"))) {
            log.warn("Detected a possible problem with the current JVM version (" + string + ").  " + "If you experience XML parsing problems using the SDK, try upgrading to a more recent JVM update.");
        }
    }
}

