/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.Presigner;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.HttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class AWS4Signer
extends AbstractAWSSigner
implements Presigner,
RegionAwareSigner,
ServiceAwareSigner {
    protected static final String ALGORITHM = "AWS4-HMAC-SHA256";
    protected static final String TERMINATOR = "aws4_request";
    private static final String DATE_PATTERN = "yyyyMMdd";
    private static final String TIME_PATTERN = "yyyyMMdd'T'HHmmss'Z'";
    private static final long MAX_EXPIRATION_TIME_IN_SECONDS = 604800L;
    protected String serviceName;
    protected String regionName;
    protected Date overriddenDate;
    protected boolean doubleUrlEncode;
    protected static final Log log = LogFactory.getLog(AWS4Signer.class);

    public AWS4Signer() {
        this(true);
    }

    public AWS4Signer(boolean doubleUrlEncoding) {
        this.doubleUrlEncode = doubleUrlEncoding;
    }

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) {
        if (credentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
        }
        this.addHostHeader(request);
        long dateMilli = this.getDateFromRequest(request);
        String dateStamp = this.getDateStamp(dateMilli);
        String scope = this.getScope(request, dateStamp);
        String contentSha256 = this.calculateContentHash(request);
        String timeStamp = this.getTimeStamp(dateMilli);
        request.addHeader("X-Amz-Date", timeStamp);
        if (request.getHeaders().get("x-amz-content-sha256") != null && request.getHeaders().get("x-amz-content-sha256").equals("required")) {
            request.addHeader("x-amz-content-sha256", contentSha256);
        }
        String signingCredentials = sanitizedCredentials.getAWSAccessKeyId() + "/" + scope;
        HeaderSigningResult headerSigningResult = this.computeSignature(request, dateStamp, timeStamp, ALGORITHM, contentSha256, sanitizedCredentials);
        String credentialsAuthorizationHeader = "Credential=" + signingCredentials;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + this.getSignedHeadersString(request);
        String signatureAuthorizationHeader = "Signature=" + BinaryUtils.toHex(headerSigningResult.getSignature());
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        request.addHeader("Authorization", authorizationHeader);
        this.processRequestPayload(request, headerSigningResult);
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials credentials) {
        request.addHeader("x-amz-security-token", credentials.getSessionToken());
    }

    protected String extractRegionName(URI endpoint) {
        if (this.regionName != null) {
            return this.regionName;
        }
        return AwsHostNameUtils.parseRegionName(endpoint.getHost(), this.serviceName);
    }

    protected String extractServiceName(URI endpoint) {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        return AwsHostNameUtils.parseServiceName(endpoint);
    }

    void overrideDate(Date overriddenDate) {
        this.overriddenDate = overriddenDate;
    }

    protected String getCanonicalizedHeaderString(Request<?> request) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(request.getHeaders().keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            String string2 = string.toLowerCase().replaceAll("\\s+", " ");
            String string3 = request.getHeaders().get(string);
            stringBuilder.append(string2).append(":");
            if (string3 != null) {
                stringBuilder.append(string3.replaceAll("\\s+", " "));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected String getSignedHeadersString(Request<?> request) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(request.getHeaders().keySet());
        Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(string.toLowerCase());
        }
        return stringBuilder.toString();
    }

    protected String getCanonicalRequest(Request<?> request, String string) {
        String string2 = HttpUtils.appendUri(request.getEndpoint().getPath(), request.getResourcePath());
        String string3 = request.getHttpMethod().toString() + "\n" + this.getCanonicalizedResourcePath(string2, this.doubleUrlEncode) + "\n" + this.getCanonicalizedQueryString(request) + "\n" + this.getCanonicalizedHeaderString(request) + "\n" + this.getSignedHeadersString(request) + "\n" + string;
        log.debug("AWS4 Canonical Request: '\"" + string3 + "\"");
        return string3;
    }

    protected String getStringToSign(String string, String string2, String string3, String string4) {
        String string5 = string + "\n" + string2 + "\n" + string3 + "\n" + BinaryUtils.toHex(this.hash(string4));
        log.debug("AWS4 String to Sign: '\"" + string5 + "\"");
        return string5;
    }

    protected final HeaderSigningResult computeSignature(Request<?> request, String string, String string2, String string3, String string4, AWSCredentials aWSCredentials) {
        String string5 = this.extractRegionName(request.getEndpoint());
        String string6 = this.extractServiceName(request.getEndpoint());
        String string7 = string + "/" + string5 + "/" + string6 + "/" + TERMINATOR;
        String string8 = this.getStringToSign(string3, string2, string7, this.getCanonicalRequest(request, string4));
        byte[] byArray = ("AWS4" + aWSCredentials.getAWSSecretKey()).getBytes();
        byte[] byArray2 = this.sign(string, byArray, SigningAlgorithm.HmacSHA256);
        byte[] byArray3 = this.sign(string5, byArray2, SigningAlgorithm.HmacSHA256);
        byte[] byArray4 = this.sign(string6, byArray3, SigningAlgorithm.HmacSHA256);
        byte[] byArray5 = this.sign(TERMINATOR, byArray4, SigningAlgorithm.HmacSHA256);
        byte[] byArray6 = this.sign(string8.getBytes(), byArray5, SigningAlgorithm.HmacSHA256);
        return new HeaderSigningResult(string2, string7, byArray5, byArray6);
    }

    protected final String getTimeStamp(long dateMilli) {
        return DateUtils.format(TIME_PATTERN, new Date(dateMilli));
    }

    protected final String getDateStamp(long dateMilli) {
        return DateUtils.format(DATE_PATTERN, new Date(dateMilli));
    }

    protected final long getDateFromRequest(Request<?> request) {
        int timeOffset = this.getTimeOffset(request);
        Date date = this.getSignatureDate(timeOffset);
        if (this.overriddenDate != null) {
            date = this.overriddenDate;
        }
        return date.getTime();
    }

    protected void addHostHeader(Request<?> request) {
        String string = request.getEndpoint().getHost();
        if (HttpUtils.isUsingNonDefaultPort(request.getEndpoint())) {
            string = string + ":" + request.getEndpoint().getPort();
        }
        request.addHeader("Host", string);
    }

    protected String getScope(Request<?> request, String dateStamp) {
        String regionName = this.extractRegionName(request.getEndpoint());
        String serviceName = this.extractServiceName(request.getEndpoint());
        String scope = dateStamp + "/" + regionName + "/" + serviceName + "/" + TERMINATOR;
        return scope;
    }

    protected String calculateContentHash(Request<?> request) {
        InputStream inputStream = this.getBinaryRequestPayloadStream(request);
        inputStream.mark(-1);
        String string = BinaryUtils.toHex(this.hash(inputStream));
        try {
            inputStream.reset();
        }
        catch (IOException iOException) {
            throw new AmazonClientException("Unable to reset stream after calculating AWS4 signature", iOException);
        }
        return string;
    }

    protected void processRequestPayload(Request<?> request, HeaderSigningResult headerSigningResult) {
    }

    @Override
    public void presignRequest(Request<?> request, AWSCredentials aWSCredentials, Date date) {
        if (aWSCredentials instanceof AnonymousAWSCredentials) {
            return;
        }
        long l = 604800L;
        if (date != null) {
            l = (date.getTime() - System.currentTimeMillis()) / 1000L;
        }
        if (l > 604800L) {
            throw new AmazonClientException("Requests that are pre-signed by SigV4 algorithm are valid for at most 7 days. The expiration date set on the current request [" + this.getTimeStamp(date.getTime()) + "] has exceeded this limit.");
        }
        this.addHostHeader(request);
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            request.addParameter("X-Amz-Security-Token", ((AWSSessionCredentials)aWSCredentials2).getSessionToken());
        }
        long l2 = this.getDateFromRequest(request);
        String string = this.getDateStamp(l2);
        String string2 = this.getScope(request, string);
        String string3 = aWSCredentials2.getAWSAccessKeyId() + "/" + string2;
        long l3 = System.currentTimeMillis();
        String string4 = this.getTimeStamp(l3);
        request.addParameter("X-Amz-Algorithm", ALGORITHM);
        request.addParameter("X-Amz-Date", string4);
        request.addParameter("X-Amz-SignedHeaders", this.getSignedHeadersString(request));
        request.addParameter("X-Amz-Expires", Long.toString(l));
        request.addParameter("X-Amz-Credential", string3);
        String string5 = this.calculateContentHashPresign(request);
        HeaderSigningResult headerSigningResult = this.computeSignature(request, string, string4, ALGORITHM, string5, aWSCredentials2);
        request.addParameter("X-Amz-Signature", BinaryUtils.toHex(headerSigningResult.getSignature()));
    }

    protected String calculateContentHashPresign(Request<?> request) {
        return this.calculateContentHash(request);
    }

    protected static class HeaderSigningResult {
        private String dateTime;
        private String scope;
        private byte[] kSigning;
        private byte[] signature;

        public HeaderSigningResult(String dateTime, String scope, byte[] kSigning, byte[] signature) {
            this.dateTime = dateTime;
            this.scope = scope;
            this.kSigning = kSigning;
            this.signature = signature;
        }

        public String getDateTime() {
            return this.dateTime;
        }

        public String getScope() {
            return this.scope;
        }

        public byte[] getKSigning() {
            byte[] kSigningCopy = new byte[this.kSigning.length];
            System.arraycopy(this.kSigning, 0, kSigningCopy, 0, this.kSigning.length);
            return kSigningCopy;
        }

        public byte[] getSignature() {
            byte[] signatureCopy = new byte[this.signature.length];
            System.arraycopy(this.signature, 0, signatureCopy, 0, this.signature.length);
            return signatureCopy;
        }
    }
}

