/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser.impl;

import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import java.io.IOException;

public final class PropertyValueBuffer {
    protected final JsonParser _parser;
    protected final DeserializationContext _context;
    protected final Object[] _creatorParameters;
    protected final ObjectIdReader _objectIdReader;
    private int _paramsNeeded;
    private PropertyValue _buffered;
    private Object _idValue;

    public PropertyValueBuffer(JsonParser jp, DeserializationContext ctxt, int paramCount, ObjectIdReader oir) {
        this._parser = jp;
        this._context = ctxt;
        this._paramsNeeded = paramCount;
        this._objectIdReader = oir;
        this._creatorParameters = new Object[paramCount];
    }

    public void inject(SettableBeanProperty[] injectableProperties) {
        for (SettableBeanProperty prop : injectableProperties) {
            if (prop == null) continue;
            this._creatorParameters[i] = this._context.findInjectableValue(prop.getInjectableValueId(), prop, null);
        }
    }

    protected final Object[] getParameters(Object[] defaults) {
        if (defaults != null) {
            int len = this._creatorParameters.length;
            for (int i = 0; i < len; ++i) {
                Object value;
                if (this._creatorParameters[i] != null || (value = defaults[i]) == null) continue;
                this._creatorParameters[i] = value;
            }
        }
        return this._creatorParameters;
    }

    public boolean readIdProperty(String propName) throws IOException {
        if (this._objectIdReader != null && propName.equals(this._objectIdReader.propertyName)) {
            this._idValue = this._objectIdReader.deserializer.deserialize(this._parser, this._context);
            return true;
        }
        return false;
    }

    public Object handleIdValue(DeserializationContext ctxt, Object bean) throws IOException {
        if (this._objectIdReader != null && this._idValue != null) {
            ReadableObjectId roid = ctxt.findObjectId(this._idValue, this._objectIdReader.generator);
            roid.bindItem(bean);
            SettableBeanProperty idProp = this._objectIdReader.idProperty;
            if (idProp != null) {
                return idProp.setAndReturn(bean, this._idValue);
            }
        }
        return bean;
    }

    protected PropertyValue buffered() {
        return this._buffered;
    }

    public boolean assignParameter(int index, Object value) {
        this._creatorParameters[index] = value;
        return --this._paramsNeeded <= 0;
    }

    public void bufferProperty(SettableBeanProperty prop, Object value) {
        this._buffered = new PropertyValue.Regular(this._buffered, value, prop);
    }

    public void bufferAnyProperty(SettableAnyProperty prop, String propName, Object value) {
        this._buffered = new PropertyValue.Any(this._buffered, value, prop, propName);
    }

    public void bufferMapProperty(Object key, Object value) {
        this._buffered = new PropertyValue.Map(this._buffered, value, key);
    }
}

