/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.base;

import com.amazonaws.org.joda.time.Chronology;
import com.amazonaws.org.joda.time.DateTimeUtils;
import com.amazonaws.org.joda.time.DateTimeZone;
import com.amazonaws.org.joda.time.ReadableDateTime;
import com.amazonaws.org.joda.time.base.AbstractDateTime;
import com.amazonaws.org.joda.time.chrono.ISOChronology;
import java.io.Serializable;

public abstract class BaseDateTime
extends AbstractDateTime
implements ReadableDateTime,
Serializable {
    private volatile long iMillis;
    private volatile Chronology iChronology;

    public BaseDateTime() {
        this(DateTimeUtils.currentTimeMillis(), ISOChronology.getInstance());
    }

    public BaseDateTime(long l, DateTimeZone dateTimeZone) {
        this(l, ISOChronology.getInstance(dateTimeZone));
    }

    public BaseDateTime(long l, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        this.iMillis = this.checkInstant(l, this.iChronology);
    }

    protected Chronology checkChronology(Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    protected long checkInstant(long l, Chronology chronology) {
        return l;
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setMillis(long l) {
        this.iMillis = this.checkInstant(l, this.iChronology);
    }
}

