/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream.events;

import com.amazonaws.javax.xml.namespace.QName;
import com.amazonaws.javax.xml.stream.XMLStreamException;
import com.amazonaws.javax.xml.stream.XMLStreamException2;
import com.amazonaws.javax.xml.stream.XMLStreamReader;
import com.amazonaws.javax.xml.stream.events.AttributeImpl;
import com.amazonaws.javax.xml.stream.events.CharacterEvent;
import com.amazonaws.javax.xml.stream.events.CommentEvent;
import com.amazonaws.javax.xml.stream.events.DTDEvent;
import com.amazonaws.javax.xml.stream.events.DummyEvent;
import com.amazonaws.javax.xml.stream.events.EndDocumentEvent;
import com.amazonaws.javax.xml.stream.events.EndElementEvent;
import com.amazonaws.javax.xml.stream.events.EntityDeclarationImpl;
import com.amazonaws.javax.xml.stream.events.EntityReferenceEvent;
import com.amazonaws.javax.xml.stream.events.NamespaceImpl;
import com.amazonaws.javax.xml.stream.events.ProcessingInstructionEvent;
import com.amazonaws.javax.xml.stream.events.StartDocumentEvent;
import com.amazonaws.javax.xml.stream.events.StartElementEvent;
import com.amazonaws.javax.xml.stream.events.XMLEvent;
import com.amazonaws.javax.xml.stream.util.XMLEventAllocator;
import com.amazonaws.javax.xml.stream.xerces.util.NamespaceContextWrapper;
import com.amazonaws.javax.xml.stream.xerces.util.NamespaceSupport;
import java.util.List;

public class XMLEventAllocatorImpl
implements XMLEventAllocator {
    public XMLEvent allocate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (xMLStreamReader == null) {
            throw new XMLStreamException2("Reader cannot be null");
        }
        return this.getXMLEvent(xMLStreamReader);
    }

    XMLEvent getXMLEvent(XMLStreamReader streamReader) {
        DummyEvent event = null;
        int eventType = streamReader.getEventType();
        switch (eventType) {
            case 1: {
                StartElementEvent startElementEvent = new StartElementEvent(this.getQName(streamReader));
                this.fillAttributes(startElementEvent, streamReader);
                if (((Boolean)streamReader.getProperty("com.amazonaws.javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(startElementEvent, streamReader);
                    this.setNamespaceContext(startElementEvent, streamReader);
                }
                startElementEvent.setLocation(streamReader.getLocation());
                event = startElementEvent;
                break;
            }
            case 2: {
                EndElementEvent endElementEvent = new EndElementEvent(this.getQName(streamReader));
                endElementEvent.setLocation(streamReader.getLocation());
                if (((Boolean)streamReader.getProperty("com.amazonaws.javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(endElementEvent, streamReader);
                }
                event = endElementEvent;
                break;
            }
            case 3: {
                ProcessingInstructionEvent piEvent = new ProcessingInstructionEvent(streamReader.getPITarget(), streamReader.getPIData());
                piEvent.setLocation(streamReader.getLocation());
                event = piEvent;
                break;
            }
            case 4: {
                CharacterEvent cDataEvent = new CharacterEvent(streamReader.getText());
                cDataEvent.setLocation(streamReader.getLocation());
                event = cDataEvent;
                break;
            }
            case 5: {
                CommentEvent commentEvent = new CommentEvent(streamReader.getText());
                commentEvent.setLocation(streamReader.getLocation());
                event = commentEvent;
                break;
            }
            case 7: {
                StartDocumentEvent sdEvent = new StartDocumentEvent();
                sdEvent.setVersion(streamReader.getVersion());
                sdEvent.setEncoding(streamReader.getEncoding());
                if (streamReader.getCharacterEncodingScheme() != null) {
                    sdEvent.setDeclaredEncoding(true);
                } else {
                    sdEvent.setDeclaredEncoding(false);
                }
                sdEvent.setStandalone(streamReader.isStandalone());
                sdEvent.setLocation(streamReader.getLocation());
                event = sdEvent;
                break;
            }
            case 8: {
                EndDocumentEvent endDocumentEvent = new EndDocumentEvent();
                endDocumentEvent.setLocation(streamReader.getLocation());
                event = endDocumentEvent;
                break;
            }
            case 9: {
                EntityReferenceEvent entityEvent = new EntityReferenceEvent(streamReader.getLocalName(), new EntityDeclarationImpl(streamReader.getLocalName(), streamReader.getText()));
                entityEvent.setLocation(streamReader.getLocation());
                event = entityEvent;
                break;
            }
            case 10: {
                event = null;
                break;
            }
            case 11: {
                List notations;
                DTDEvent dtdEvent = new DTDEvent(streamReader.getText());
                dtdEvent.setLocation(streamReader.getLocation());
                List entities = (List)streamReader.getProperty("com.amazonaws.javax.xml.stream.entities");
                if (entities != null && entities.size() != 0) {
                    dtdEvent.setEntities(entities);
                }
                if ((notations = (List)streamReader.getProperty("com.amazonaws.javax.xml.stream.notations")) != null && notations.size() != 0) {
                    dtdEvent.setNotations(notations);
                }
                event = dtdEvent;
                break;
            }
            case 12: {
                CharacterEvent cDataEvent = new CharacterEvent(streamReader.getText(), true);
                cDataEvent.setLocation(streamReader.getLocation());
                event = cDataEvent;
                break;
            }
            case 6: {
                CharacterEvent spaceEvent = new CharacterEvent(streamReader.getText(), false, true);
                spaceEvent.setLocation(streamReader.getLocation());
                event = spaceEvent;
                break;
            }
        }
        return event;
    }

    protected void fillAttributes(StartElementEvent event, XMLStreamReader xmlr) {
        int len = xmlr.getAttributeCount();
        QName qname = null;
        String prefix = null;
        String localpart = null;
        AttributeImpl attr = null;
        Object nattr = null;
        for (int i = 0; i < len; ++i) {
            qname = xmlr.getAttributeName(i);
            prefix = qname.getPrefix();
            localpart = qname.getLocalPart();
            attr = new AttributeImpl();
            attr.setName(qname);
            attr.setAttributeType(xmlr.getAttributeType(i));
            attr.setSpecified(xmlr.isAttributeSpecified(i));
            attr.setValue(xmlr.getAttributeValue(i));
            event.addAttribute(attr);
        }
    }

    protected void fillNamespaceAttributes(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getNamespaceCount();
        String string = null;
        String string2 = null;
        NamespaceImpl namespaceImpl = null;
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getNamespaceURI(i);
            string2 = xMLStreamReader.getNamespacePrefix(i);
            if (string2 == null) {
                string2 = "";
            }
            namespaceImpl = new NamespaceImpl(string2, string);
            startElementEvent.addNamespaceAttribute(namespaceImpl);
        }
    }

    protected void fillNamespaceAttributes(EndElementEvent endElementEvent, XMLStreamReader xMLStreamReader) {
        int n = xMLStreamReader.getNamespaceCount();
        String string = null;
        String string2 = null;
        NamespaceImpl namespaceImpl = null;
        for (int i = 0; i < n; ++i) {
            string = xMLStreamReader.getNamespaceURI(i);
            string2 = xMLStreamReader.getNamespacePrefix(i);
            if (string2 == null) {
                string2 = "";
            }
            namespaceImpl = new NamespaceImpl(string2, string);
            endElementEvent.addNamespace(namespaceImpl);
        }
    }

    private void setNamespaceContext(StartElementEvent event, XMLStreamReader xmlr) {
        NamespaceContextWrapper contextWrapper = (NamespaceContextWrapper)xmlr.getNamespaceContext();
        NamespaceSupport ns = new NamespaceSupport(contextWrapper.getNamespaceContext());
        event.setNamespaceContext(new NamespaceContextWrapper(ns));
    }

    private QName getQName(XMLStreamReader xmlr) {
        return new QName(xmlr.getNamespaceURI(), xmlr.getLocalName(), xmlr.getPrefix());
    }
}

