/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.ser;

import com.amazonaws.com.fasterxml.jackson.annotation.JsonFormat;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializable;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.MapperFeature;
import com.amazonaws.com.fasterxml.jackson.databind.SerializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.amazonaws.com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.ser.Serializers;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.EnumMapSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.StdContainerSerializers;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.type.ArrayType;
import com.amazonaws.com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.amazonaws.com.fasterxml.jackson.databind.type.CollectionType;
import com.amazonaws.com.fasterxml.jackson.databind.type.MapLikeType;
import com.amazonaws.com.fasterxml.jackson.databind.type.MapType;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeFactory;
import com.amazonaws.com.fasterxml.jackson.databind.util.ClassUtil;
import com.amazonaws.com.fasterxml.jackson.databind.util.EnumValues;
import com.amazonaws.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;

public abstract class BasicSerializerFactory
extends SerializerFactory
implements Serializable {
    protected static final HashMap<String, JsonSerializer<?>> _concrete = new HashMap();
    protected static final HashMap<String, Class<? extends JsonSerializer<?>>> _concreteLazy = new HashMap();
    protected final SerializerFactoryConfig _factoryConfig;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicSerializerFactory(SerializerFactoryConfig config) {
        this._factoryConfig = config == null ? new SerializerFactoryConfig() : config;
    }

    @Override
    public JsonSerializer<Object> createKeySerializer(SerializationConfig config, JavaType type) {
        Serializers serializers;
        if (!this._factoryConfig.hasKeySerializers()) {
            return null;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(type.getRawClass());
        JsonSerializer<?> ser = null;
        Iterator<Serializers> i$ = this._factoryConfig.keySerializers().iterator();
        while (i$.hasNext() && (ser = (serializers = i$.next()).findSerializer(config, type, beanDesc)) == null) {
        }
        return ser;
    }

    @Override
    public TypeSerializer createTypeSerializer(SerializationConfig config, JavaType baseType) {
        BeanDescription bean = config.introspectClassAnnotations(baseType.getRawClass());
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        if (b == null) {
            return null;
        }
        return b.buildTypeSerializer(config, baseType, subtypes);
    }

    protected abstract Iterable<Serializers> customSerializers();

    protected final JsonSerializer<?> findSerializerByLookup(JavaType type, SerializationConfig config, BeanDescription beanDesc, boolean staticTyping) {
        Class<?> raw = type.getRawClass();
        String clsName = raw.getName();
        JsonSerializer<?> ser = _concrete.get(clsName);
        if (ser != null) {
            return ser;
        }
        Class<JsonSerializer<?>> serClass = _concreteLazy.get(clsName);
        if (serClass != null) {
            try {
                return serClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + serClass.getName() + "): " + e.getMessage(), e);
            }
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByAnnotations(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(clazz)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod annotatedMethod = beanDescription.findJsonValueMethod();
        if (annotatedMethod != null) {
            Method method = annotatedMethod.getAnnotated();
            if (serializerProvider.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            JsonSerializer<Object> jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMethod);
            return new JsonValueSerializer(method, jsonSerializer);
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByPrimaryType(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<Enum<?>> clazz = javaType.getRawClass();
        if (InetAddress.class.isAssignableFrom(clazz)) {
            return InetAddressSerializer.instance;
        }
        if (TimeZone.class.isAssignableFrom(clazz)) {
            return TimeZoneSerializer.instance;
        }
        if (Charset.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        JsonSerializer<?> jsonSerializer = this.optionalHandlers.findSerializer(serializerProvider.getConfig(), javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NumberSerializers.NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            JsonFormat.Value value = beanDescription.findExpectedFormat(null);
            if (value != null && value.getShape() == JsonFormat.Shape.OBJECT) {
                ((BasicBeanDescription)beanDescription).removeProperty("declaringClass");
            } else {
                Class<Enum<?>> clazz2 = clazz;
                return EnumSerializer.construct(clazz2, serializerProvider.getConfig(), beanDescription, value);
            }
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return CalendarSerializer.instance;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return DateSerializer.instance;
        }
        return null;
    }

    protected final JsonSerializer<?> findSerializerByAddonType(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) throws JsonMappingException {
        Class<?> clazz = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(clazz)) {
            return this.buildIteratorSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return this.buildIterableSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer<Object> findSerializerFromAnnotation(SerializerProvider prov, Annotated a) throws JsonMappingException {
        Object serDef = prov.getAnnotationIntrospector().findSerializer(a);
        if (serDef == null) {
            return null;
        }
        return prov.serializerInstance(a, serDef);
    }

    protected JsonSerializer<?> buildContainerSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType elementType;
        SerializationConfig config = prov.getConfig();
        TypeSerializer elementTypeSerializer = this.createTypeSerializer(config, elementType = type.getContentType());
        if (elementTypeSerializer != null) {
            staticTyping = false;
        }
        JsonSerializer<Object> elementValueSerializer = this._findContentSerializer(prov, beanDesc.getClassInfo());
        if (type.isMapLikeType()) {
            MapLikeType mlt = (MapLikeType)type;
            JsonSerializer<Object> keySerializer = this._findKeySerializer(prov, beanDesc.getClassInfo());
            if (mlt.isTrueMapType()) {
                return this.buildMapSerializer(config, (MapType)mlt, beanDesc, staticTyping, keySerializer, elementTypeSerializer, elementValueSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer<?> ser = serializers.findMapLikeSerializer(config, (MapLikeType)type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer);
                if (ser == null) continue;
                return ser;
            }
            return null;
        }
        if (type.isCollectionLikeType()) {
            CollectionLikeType clt = (CollectionLikeType)type;
            if (clt.isTrueCollectionType()) {
                CollectionType trueCT = (CollectionType)clt;
                for (Serializers serializers : this.customSerializers()) {
                    JsonSerializer<?> ser = serializers.findCollectionSerializer(config, trueCT, beanDesc, elementTypeSerializer, elementValueSerializer);
                    if (ser == null) continue;
                    return ser;
                }
                JsonFormat.Value format = beanDesc.findExpectedFormat(null);
                if (format == null || format.getShape() != JsonFormat.Shape.OBJECT) {
                    return this.buildCollectionSerializer(config, trueCT, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
                }
            } else {
                for (Serializers serializers : this.customSerializers()) {
                    JsonSerializer<?> ser = serializers.findCollectionLikeSerializer(config, (CollectionLikeType)type, beanDesc, elementTypeSerializer, elementValueSerializer);
                    if (ser == null) continue;
                    return ser;
                }
                return null;
            }
        }
        if (type.isArrayType()) {
            return this.buildArraySerializer(config, (ArrayType)type, beanDesc, staticTyping, elementTypeSerializer, elementValueSerializer);
        }
        return null;
    }

    protected JsonSerializer<?> buildCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        Class<?> clazz = collectionType.getRawClass();
        if (EnumSet.class.isAssignableFrom(clazz)) {
            JavaType javaType = collectionType.getContentType();
            if (!javaType.isEnumType()) {
                javaType = null;
            }
            return StdContainerSerializers.enumSetSerializer(javaType);
        }
        Class<?> clazz2 = collectionType.getContentType().getRawClass();
        if (this.isIndexedList(clazz)) {
            if (clazz2 == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
                return IndexedStringListSerializer.instance;
            }
            return StdContainerSerializers.indexedListSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
        }
        if (clazz2 == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
            return StringCollectionSerializer.instance;
        }
        return StdContainerSerializers.collectionSerializer(collectionType.getContentType(), bl, typeSerializer, jsonSerializer);
    }

    protected boolean isIndexedList(Class<?> clazz) {
        return RandomAccess.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    protected JsonSerializer<?> buildMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, boolean bl, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) throws JsonMappingException {
        JsonSerializer<?> jsonSerializer3;
        for (Serializers object : this.customSerializers()) {
            jsonSerializer3 = object.findMapSerializer(serializationConfig, mapType, beanDescription, jsonSerializer, typeSerializer, jsonSerializer2);
            if (jsonSerializer3 == null) continue;
            return jsonSerializer3;
        }
        if (EnumMap.class.isAssignableFrom(mapType.getRawClass())) {
            void var9_12;
            JavaType javaType = mapType.getKeyType();
            Object var9_10 = null;
            if (javaType.isEnumType()) {
                jsonSerializer3 = javaType.getRawClass();
                EnumValues enumValues = EnumValues.construct(jsonSerializer3, serializationConfig.getAnnotationIntrospector());
            }
            return new EnumMapSerializer(mapType.getContentType(), bl, (EnumValues)var9_12, typeSerializer, jsonSerializer2);
        }
        return MapSerializer.construct(serializationConfig.getAnnotationIntrospector().findPropertiesToIgnore(beanDescription.getClassInfo()), mapType, bl, typeSerializer, jsonSerializer, jsonSerializer2);
    }

    protected JsonSerializer<?> buildArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) throws JsonMappingException {
        for (Serializers jsonSerializer2 : this.customSerializers()) {
            JsonSerializer<?> jsonSerializer3 = jsonSerializer2.findArraySerializer(serializationConfig, arrayType, beanDescription, typeSerializer, jsonSerializer);
            if (jsonSerializer3 == null) continue;
            return jsonSerializer3;
        }
        Class<?> clazz = arrayType.getRawClass();
        if (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer)) {
            if (String[].class == clazz) {
                return StringArraySerializer.instance;
            }
            JsonSerializer<?> jsonSerializer4 = StdArraySerializers.findStandardImpl(clazz);
            if (jsonSerializer4 != null) {
                return jsonSerializer4;
            }
        }
        return new ObjectArraySerializer(arrayType.getContentType(), bl, typeSerializer, jsonSerializer);
    }

    protected JsonSerializer<?> buildIteratorSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType);
        return StdContainerSerializers.iteratorSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts);
    }

    protected JsonSerializer<?> buildIterableSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        JavaType valueType = type.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        TypeSerializer vts = this.createTypeSerializer(config, valueType);
        return StdContainerSerializers.iterableSerializer(valueType, this.usesStaticTyping(config, beanDesc, vts), vts);
    }

    protected <T extends JavaType> T modifyTypeByAnnotation(SerializationConfig serializationConfig, Annotated annotated, T object) {
        Class<?> clazz = serializationConfig.getAnnotationIntrospector().findSerializationType(annotated);
        if (clazz != null) {
            try {
                object = object.widenBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Failed to widen type " + object + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(serializationConfig, annotated, object);
    }

    protected static <T extends JavaType> T modifySecondaryTypesByAnnotation(SerializationConfig serializationConfig, Annotated annotated, T object) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        if (((JavaType)object).isContainerType()) {
            Class<?> clazz;
            Class<?> clazz2 = annotationIntrospector.findSerializationKeyType(annotated, ((JavaType)object).getKeyType());
            if (clazz2 != null) {
                if (!(object instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + object + " is not a Map type");
                }
                try {
                    object = ((MapType)object).widenKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow key type " + object + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
            if ((clazz = annotationIntrospector.findSerializationContentType(annotated, ((JavaType)object).getContentType())) != null) {
                try {
                    object = ((JavaType)object).widenContentsBy(clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow content type " + object + " with content-type annotation (" + clazz.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
        }
        return (T)object;
    }

    protected JsonSerializer<Object> _findKeySerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findKeySerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    protected JsonSerializer<Object> _findContentSerializer(SerializerProvider prov, Annotated a) throws JsonMappingException {
        AnnotationIntrospector intr = prov.getAnnotationIntrospector();
        Object serDef = intr.findContentSerializer(a);
        if (serDef != null) {
            return prov.serializerInstance(a, serDef);
        }
        return null;
    }

    protected boolean usesStaticTyping(SerializationConfig config, BeanDescription beanDesc, TypeSerializer typeSer) {
        if (typeSer != null) {
            return false;
        }
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        JsonSerialize.Typing t = intr.findSerializationTyping(beanDesc.getClassInfo());
        return t != null ? t == JsonSerialize.Typing.STATIC : config.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer toStringSerializer = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), toStringSerializer);
        _concrete.put(StringBuilder.class.getName(), toStringSerializer);
        _concrete.put(Character.class.getName(), toStringSerializer);
        _concrete.put(Character.TYPE.getName(), toStringSerializer);
        NumberSerializers.addAll(_concrete);
        _concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        NumberSerializers.NumberSerializer numberSerializer = new NumberSerializers.NumberSerializer();
        _concrete.put(BigInteger.class.getName(), numberSerializer);
        _concrete.put(BigDecimal.class.getName(), numberSerializer);
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSerializer = DateSerializer.instance;
        _concrete.put(java.util.Date.class.getName(), dateSerializer);
        _concrete.put(Timestamp.class.getName(), dateSerializer);
        _concrete.put(Date.class.getName(), new SqlDateSerializer());
        _concrete.put(Time.class.getName(), new SqlTimeSerializer());
        for (Map.Entry<Class<?>, Object> entry : new StdJdkSerializers().provide()) {
            Object object = entry.getValue();
            if (object instanceof JsonSerializer) {
                _concrete.put(entry.getKey().getName(), (JsonSerializer)object);
                continue;
            }
            if (object instanceof Class) {
                Class clazz = (Class)object;
                _concreteLazy.put(entry.getKey().getName(), clazz);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + entry.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
    }
}

