/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.introspect;

import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;

public final class AnnotatedField
extends AnnotatedMember
implements Serializable {
    protected final transient Field _field;

    public AnnotatedField(Field field, AnnotationMap annMap) {
        super(annMap);
        this._field = field;
    }

    public AnnotatedField withAnnotations(AnnotationMap ann) {
        return new AnnotatedField(this._field, ann);
    }

    @Override
    public Field getAnnotated() {
        return this._field;
    }

    @Override
    public String getName() {
        return this._field.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotations.get(acls);
    }

    @Override
    public Type getGenericType() {
        return this._field.getGenericType();
    }

    @Override
    public Class<?> getRawType() {
        return this._field.getType();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this._field;
    }

    @Override
    public void setValue(Object pojo, Object value) throws IllegalArgumentException {
        try {
            this._field.set(pojo, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to setValue() for field " + this.getFullName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public Object getValue(Object pojo) throws IllegalArgumentException {
        try {
            return this._field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to getValue() for field " + this.getFullName() + ": " + e.getMessage(), e);
        }
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName();
    }

    public String toString() {
        return "[field " + this.getFullName() + "]";
    }
}

