/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind;

import com.amazonaws.com.fasterxml.jackson.core.Base64Variants;
import com.amazonaws.com.fasterxml.jackson.core.JsonFactory;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerationException;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.JsonParseException;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.core.ObjectCodec;
import com.amazonaws.com.fasterxml.jackson.core.PrettyPrinter;
import com.amazonaws.com.fasterxml.jackson.core.TreeNode;
import com.amazonaws.com.fasterxml.jackson.core.io.SerializedString;
import com.amazonaws.com.fasterxml.jackson.core.type.TypeReference;
import com.amazonaws.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.InjectableValues;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonNode;
import com.amazonaws.com.fasterxml.jackson.databind.MappingJsonFactory;
import com.amazonaws.com.fasterxml.jackson.databind.ObjectWriter;
import com.amazonaws.com.fasterxml.jackson.databind.SerializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.SerializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.amazonaws.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.amazonaws.com.fasterxml.jackson.databind.node.NullNode;
import com.amazonaws.com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.amazonaws.com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.type.ClassKey;
import com.amazonaws.com.fasterxml.jackson.databind.type.SimpleType;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeFactory;
import com.amazonaws.com.fasterxml.jackson.databind.util.RootNameLookup;
import com.amazonaws.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectMapper
extends ObjectCodec
implements Serializable {
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected static final ClassIntrospector DEFAULT_INTROSPECTOR = BasicClassIntrospector.instance;
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final VisibilityChecker<?> STD_VISIBILITY_CHECKER = VisibilityChecker.Std.defaultInstance();
    protected static final PrettyPrinter _defaultPrettyPrinter = new DefaultPrettyPrinter();
    protected static final BaseSettings DEFAULT_BASE = new BaseSettings(DEFAULT_INTROSPECTOR, DEFAULT_ANNOTATION_INTROSPECTOR, STD_VISIBILITY_CHECKER, null, TypeFactory.defaultInstance(), null, StdDateFormat.instance, null, Locale.getDefault(), TimeZone.getTimeZone("GMT"), Base64Variants.getDefaultVariant());
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final RootNameLookup _rootNames;
    protected final HashMap<ClassKey, Class<?>> _mixInAnnotations = new HashMap();
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jf) {
        this(jf, null, null);
    }

    public ObjectMapper(JsonFactory jf, DefaultSerializerProvider sp, DefaultDeserializationContext dc) {
        if (jf == null) {
            this._jsonFactory = new MappingJsonFactory(this);
        } else {
            this._jsonFactory = jf;
            if (jf.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new StdSubtypeResolver();
        this._rootNames = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        this._serializationConfig = new SerializationConfig(DEFAULT_BASE, this._subtypeResolver, this._mixInAnnotations);
        this._deserializationConfig = new DeserializationConfig(DEFAULT_BASE, this._subtypeResolver, this._mixInAnnotations);
        this._serializerProvider = sp == null ? new DefaultSerializerProvider.Impl() : sp;
        this._deserializationContext = dc == null ? new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance) : dc;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public ObjectMapper configure(DeserializationFeature f, boolean state) {
        this._deserializationConfig = state ? this._deserializationConfig.with(f) : this._deserializationConfig.without(f);
        return this;
    }

    public ObjectMapper configure(JsonParser.Feature f, boolean state) {
        this._jsonFactory.configure(f, state);
        return this;
    }

    @Override
    public <T> T readValue(JsonParser jp, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jp, this._typeFactory.constructType(valueType));
    }

    @Override
    public <T> T readValue(JsonParser jp, TypeReference<?> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readValue(this.getDeserializationConfig(), jp, this._typeFactory.constructType(valueTypeRef));
    }

    public JsonNode readTree(InputStream in) throws IOException, JsonProcessingException {
        JsonNode n = (JsonNode)this._readMapAndClose(this._jsonFactory.createJsonParser(in), JSON_NODE_TYPE);
        return n == null ? NullNode.instance : n;
    }

    @Override
    public void writeValue(JsonGenerator jgen, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        SerializationConfig config = this.getSerializationConfig();
        if (config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jgen.useDefaultPrettyPrinter();
        }
        if (config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseableValue(jgen, value, config);
        } else {
            this._serializerProvider(config).serializeValue(jgen, value);
            if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jgen.flush();
            }
        }
    }

    public JsonParser treeAsTokens(TreeNode n) {
        return new TreeTraversingParser((JsonNode)n, this);
    }

    @Override
    public <T> T treeToValue(TreeNode n, Class<T> valueType) throws JsonProcessingException {
        try {
            if (valueType != Object.class && valueType.isAssignableFrom(n.getClass())) {
                return (T)n;
            }
            return this.readValue(this.treeAsTokens(n), valueType);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public <T> T readValue(File src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(URL src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(src), this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(String content, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(content), this._typeFactory.constructType(valueType));
    }

    public ObjectWriter writer() {
        return new ObjectWriter(this, this.getSerializationConfig());
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        return new ObjectWriter(this, this.getSerializationConfig(), null, this._defaultPrettyPrinter());
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig config) {
        return this._serializerProvider.createInstance(config, this._serializerFactory);
    }

    protected PrettyPrinter _defaultPrettyPrinter() {
        return _defaultPrettyPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jgen, Object value, SerializationConfig cfg) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable toClose = (Closeable)value;
        try {
            this._serializerProvider(cfg).serializeValue(jgen, value);
            if (cfg.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jgen.flush();
            }
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        finally {
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected final DefaultDeserializationContext createDeserializationContext(JsonParser jp, DeserializationConfig cfg) {
        return this._deserializationContext.createInstance(cfg, jp, this._injectableValues);
    }

    protected Object _readValue(DeserializationConfig cfg, JsonParser jp, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        Object result;
        JsonToken t = this._initForReading(jp);
        if (t == JsonToken.VALUE_NULL) {
            DefaultDeserializationContext ctxt = this.createDeserializationContext(jp, cfg);
            result = this._findRootDeserializer(ctxt, valueType).getNullValue();
        } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
            result = null;
        } else {
            DefaultDeserializationContext ctxt = this.createDeserializationContext(jp, cfg);
            JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
            result = cfg.useRootWrapping() ? this._unwrapAndDeserialize(jp, ctxt, cfg, valueType, deser) : deser.deserialize(jp, ctxt);
        }
        jp.clearCurrentToken();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _readMapAndClose(JsonParser jp, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        try {
            Object result;
            JsonToken t = this._initForReading(jp);
            if (t == JsonToken.VALUE_NULL) {
                DefaultDeserializationContext ctxt = this.createDeserializationContext(jp, this.getDeserializationConfig());
                result = this._findRootDeserializer(ctxt, valueType).getNullValue();
            } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
                result = null;
            } else {
                DeserializationConfig cfg = this.getDeserializationConfig();
                DefaultDeserializationContext ctxt = this.createDeserializationContext(jp, cfg);
                JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt, valueType);
                result = cfg.useRootWrapping() ? this._unwrapAndDeserialize(jp, ctxt, cfg, valueType, deser) : deser.deserialize(jp, ctxt);
            }
            jp.clearCurrentToken();
            Object object = result;
            return object;
        }
        finally {
            try {
                jp.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected JsonToken _initForReading(JsonParser jsonParser) throws IOException, JsonParseException, JsonMappingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JsonMappingException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) throws IOException, JsonParseException, JsonMappingException {
        Object object;
        String string = deserializationConfig.getRootName();
        if (string == null) {
            object = this._rootNames.findRootName(javaType, deserializationConfig);
            string = ((SerializedString)object).getValue();
        }
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not START_OBJECT (needed to unwrap root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            throw JsonMappingException.from(jsonParser, "Current token not FIELD_NAME (to contain expected root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        object = jsonParser.getCurrentName();
        if (!string.equals(object)) {
            throw JsonMappingException.from(jsonParser, "Root name '" + (String)object + "' does not match expected ('" + string + "') for type " + javaType);
        }
        jsonParser.nextToken();
        Object object2 = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not END_OBJECT (to match wrapper object with root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        return object2;
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            throw new JsonMappingException("Can not find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    public static enum DefaultTyping {
        JAVA_LANG_OBJECT,
        OBJECT_AND_NON_CONCRETE,
        NON_CONCRETE_AND_ARRAYS,
        NON_FINAL;

    }
}

