/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.TimingInfoFullSupport;
import com.amazonaws.util.TimingInfoUnmodifiable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TimingInfo {
    static final int UNKNOWN = -1;
    private final Long startEpochTimeMilli;
    private final long startTimeNano;
    private Long endTimeNano;

    public static TimingInfo startTiming() {
        return new TimingInfo(System.currentTimeMillis(), System.nanoTime(), null);
    }

    public static TimingInfo startTimingFullSupport() {
        return new TimingInfoFullSupport(System.currentTimeMillis(), System.nanoTime(), null);
    }

    public static TimingInfo startTimingFullSupport(long l) {
        return new TimingInfoFullSupport(null, l, null);
    }

    public static TimingInfo newTimingInfoFullSupport(long l, long l2) {
        return new TimingInfoFullSupport(null, l, l2);
    }

    public static TimingInfo newTimingInfoFullSupport(long l, long l2, long l3) {
        return new TimingInfoFullSupport(l, l2, l3);
    }

    public static TimingInfo unmodifiableTimingInfo(long l, Long l2) {
        return new TimingInfoUnmodifiable(null, l, l2);
    }

    public static TimingInfo unmodifiableTimingInfo(long l, long l2, Long l3) {
        return new TimingInfoUnmodifiable(l, l2, l3);
    }

    protected TimingInfo(Long l, long l2, Long l3) {
        this.startEpochTimeMilli = l;
        this.startTimeNano = l2;
        this.endTimeNano = l3;
    }

    @Deprecated
    public final long getStartTime() {
        return this.isStartEpochTimeMilliKnown() ? this.startEpochTimeMilli.longValue() : TimeUnit.NANOSECONDS.toMillis(this.startTimeNano);
    }

    @Deprecated
    public final long getStartEpochTimeMilli() {
        Long l = this.getStartEpochTimeMilliIfKnown();
        return l == null ? -1L : l;
    }

    public final Long getStartEpochTimeMilliIfKnown() {
        return this.startEpochTimeMilli;
    }

    public final long getStartTimeNano() {
        return this.startTimeNano;
    }

    @Deprecated
    public final long getEndTime() {
        return this.getEndEpochTimeMilli();
    }

    @Deprecated
    public final long getEndEpochTimeMilli() {
        Long l = this.getEndEpochTimeMilliIfKnown();
        return l == null ? -1L : l;
    }

    public final Long getEndEpochTimeMilliIfKnown() {
        return this.isStartEpochTimeMilliKnown() && this.isEndTimeKnown() ? Long.valueOf(this.startEpochTimeMilli + TimeUnit.NANOSECONDS.toMillis(this.endTimeNano - this.startTimeNano)) : null;
    }

    public final long getEndTimeNano() {
        return this.endTimeNano == null ? -1L : this.endTimeNano;
    }

    public final Long getEndTimeNanoIfKnown() {
        return this.endTimeNano;
    }

    @Deprecated
    public final double getTimeTakenMillis() {
        Double d = this.getTimeTakenMillisIfKnown();
        return d == null ? -1.0 : d;
    }

    public final Double getTimeTakenMillisIfKnown() {
        return this.isEndTimeKnown() ? Double.valueOf(TimingInfo.durationMilliOf(this.startTimeNano, this.endTimeNano)) : null;
    }

    public static double durationMilliOf(long l, long l2) {
        double d = TimeUnit.NANOSECONDS.toMicros(l2 - l);
        return d / 1000.0;
    }

    @Deprecated
    public final long getElapsedTimeMillis() {
        Double d = this.getTimeTakenMillisIfKnown();
        return d == null ? -1L : d.longValue();
    }

    public final boolean isEndTimeKnown() {
        return this.endTimeNano != null;
    }

    public final boolean isStartEpochTimeMilliKnown() {
        return this.startEpochTimeMilli != null;
    }

    public final String toString() {
        return String.valueOf(this.getTimeTakenMillis());
    }

    @Deprecated
    public void setEndTime(long l) {
        this.endTimeNano = TimeUnit.MILLISECONDS.toNanos(l);
    }

    public void setEndTimeNano(long l) {
        this.endTimeNano = l;
    }

    public TimingInfo endTiming() {
        this.endTimeNano = System.nanoTime();
        return this;
    }

    public void addSubMeasurement(String string, TimingInfo timingInfo) {
    }

    public TimingInfo getSubMeasurement(String string) {
        return null;
    }

    public TimingInfo getSubMeasurement(String string, int n) {
        return null;
    }

    public TimingInfo getLastSubMeasurement(String string) {
        return null;
    }

    public List<TimingInfo> getAllSubMeasurements(String string) {
        return null;
    }

    public Map<String, List<TimingInfo>> getSubMeasurementsByName() {
        return Collections.emptyMap();
    }

    public Number getCounter(String string) {
        return null;
    }

    public Map<String, Number> getAllCounters() {
        return Collections.emptyMap();
    }

    public void setCounter(String string, long l) {
    }

    public void incrementCounter(String string) {
    }
}

