/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateIdentityPoolResult
implements Serializable {
    private String identityPoolId;
    private String identityPoolName;
    private Boolean allowUnauthenticatedIdentities;
    private Map<String, String> supportedLoginProviders;
    private String developerProviderName;
    private ListWithAutoConstructFlag<String> openIdConnectProviderARNs;

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public void setIdentityPoolId(String string) {
        this.identityPoolId = string;
    }

    public CreateIdentityPoolResult withIdentityPoolId(String string) {
        this.identityPoolId = string;
        return this;
    }

    public String getIdentityPoolName() {
        return this.identityPoolName;
    }

    public void setIdentityPoolName(String string) {
        this.identityPoolName = string;
    }

    public CreateIdentityPoolResult withIdentityPoolName(String string) {
        this.identityPoolName = string;
        return this;
    }

    public Boolean isAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public void setAllowUnauthenticatedIdentities(Boolean bl) {
        this.allowUnauthenticatedIdentities = bl;
    }

    public CreateIdentityPoolResult withAllowUnauthenticatedIdentities(Boolean bl) {
        this.allowUnauthenticatedIdentities = bl;
        return this;
    }

    public Boolean getAllowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> getSupportedLoginProviders() {
        if (this.supportedLoginProviders == null) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        return this.supportedLoginProviders;
    }

    public void setSupportedLoginProviders(Map<String, String> map) {
        this.supportedLoginProviders = map;
    }

    public CreateIdentityPoolResult withSupportedLoginProviders(Map<String, String> map) {
        this.setSupportedLoginProviders(map);
        return this;
    }

    public CreateIdentityPoolResult addSupportedLoginProvidersEntry(String string, String string2) {
        if (null == this.supportedLoginProviders) {
            this.supportedLoginProviders = new HashMap<String, String>();
        }
        if (this.supportedLoginProviders.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.supportedLoginProviders.put(string, string2);
        return this;
    }

    public CreateIdentityPoolResult clearSupportedLoginProvidersEntries() {
        this.supportedLoginProviders = null;
        return this;
    }

    public String getDeveloperProviderName() {
        return this.developerProviderName;
    }

    public void setDeveloperProviderName(String string) {
        this.developerProviderName = string;
    }

    public CreateIdentityPoolResult withDeveloperProviderName(String string) {
        this.developerProviderName = string;
        return this;
    }

    public List<String> getOpenIdConnectProviderARNs() {
        if (this.openIdConnectProviderARNs == null) {
            this.openIdConnectProviderARNs = new ListWithAutoConstructFlag();
            this.openIdConnectProviderARNs.setAutoConstruct(true);
        }
        return this.openIdConnectProviderARNs;
    }

    public void setOpenIdConnectProviderARNs(Collection<String> collection) {
        if (collection == null) {
            this.openIdConnectProviderARNs = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.openIdConnectProviderARNs = listWithAutoConstructFlag;
    }

    public CreateIdentityPoolResult withOpenIdConnectProviderARNs(String ... stringArray) {
        if (this.getOpenIdConnectProviderARNs() == null) {
            this.setOpenIdConnectProviderARNs(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getOpenIdConnectProviderARNs().add(string);
        }
        return this;
    }

    public CreateIdentityPoolResult withOpenIdConnectProviderARNs(Collection<String> collection) {
        if (collection == null) {
            this.openIdConnectProviderARNs = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.openIdConnectProviderARNs = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIdentityPoolId() != null) {
            stringBuilder.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentityPoolName() != null) {
            stringBuilder.append("IdentityPoolName: " + this.getIdentityPoolName() + ",");
        }
        if (this.isAllowUnauthenticatedIdentities() != null) {
            stringBuilder.append("AllowUnauthenticatedIdentities: " + this.isAllowUnauthenticatedIdentities() + ",");
        }
        if (this.getSupportedLoginProviders() != null) {
            stringBuilder.append("SupportedLoginProviders: " + this.getSupportedLoginProviders() + ",");
        }
        if (this.getDeveloperProviderName() != null) {
            stringBuilder.append("DeveloperProviderName: " + this.getDeveloperProviderName() + ",");
        }
        if (this.getOpenIdConnectProviderARNs() != null) {
            stringBuilder.append("OpenIdConnectProviderARNs: " + this.getOpenIdConnectProviderARNs());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        n = 31 * n + (this.getIdentityPoolName() == null ? 0 : this.getIdentityPoolName().hashCode());
        n = 31 * n + (this.isAllowUnauthenticatedIdentities() == null ? 0 : this.isAllowUnauthenticatedIdentities().hashCode());
        n = 31 * n + (this.getSupportedLoginProviders() == null ? 0 : ((Object)this.getSupportedLoginProviders()).hashCode());
        n = 31 * n + (this.getDeveloperProviderName() == null ? 0 : this.getDeveloperProviderName().hashCode());
        n = 31 * n + (this.getOpenIdConnectProviderARNs() == null ? 0 : ((Object)this.getOpenIdConnectProviderARNs()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CreateIdentityPoolResult)) {
            return false;
        }
        CreateIdentityPoolResult createIdentityPoolResult = (CreateIdentityPoolResult)object;
        if (createIdentityPoolResult.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (createIdentityPoolResult.getIdentityPoolId() != null && !createIdentityPoolResult.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (createIdentityPoolResult.getIdentityPoolName() == null ^ this.getIdentityPoolName() == null) {
            return false;
        }
        if (createIdentityPoolResult.getIdentityPoolName() != null && !createIdentityPoolResult.getIdentityPoolName().equals(this.getIdentityPoolName())) {
            return false;
        }
        if (createIdentityPoolResult.isAllowUnauthenticatedIdentities() == null ^ this.isAllowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (createIdentityPoolResult.isAllowUnauthenticatedIdentities() != null && !createIdentityPoolResult.isAllowUnauthenticatedIdentities().equals(this.isAllowUnauthenticatedIdentities())) {
            return false;
        }
        if (createIdentityPoolResult.getSupportedLoginProviders() == null ^ this.getSupportedLoginProviders() == null) {
            return false;
        }
        if (createIdentityPoolResult.getSupportedLoginProviders() != null && !((Object)createIdentityPoolResult.getSupportedLoginProviders()).equals(this.getSupportedLoginProviders())) {
            return false;
        }
        if (createIdentityPoolResult.getDeveloperProviderName() == null ^ this.getDeveloperProviderName() == null) {
            return false;
        }
        if (createIdentityPoolResult.getDeveloperProviderName() != null && !createIdentityPoolResult.getDeveloperProviderName().equals(this.getDeveloperProviderName())) {
            return false;
        }
        if (createIdentityPoolResult.getOpenIdConnectProviderARNs() == null ^ this.getOpenIdConnectProviderARNs() == null) {
            return false;
        }
        return createIdentityPoolResult.getOpenIdConnectProviderARNs() == null || ((Object)createIdentityPoolResult.getOpenIdConnectProviderARNs()).equals(this.getOpenIdConnectProviderARNs());
    }
}

