/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentity;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.GetIdRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsResult;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.MergeDeveloperIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.transform.CreateIdentityPoolRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.CreateIdentityPoolResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.DeleteIdentityPoolRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.DescribeIdentityPoolRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.DescribeIdentityPoolResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.DeveloperUserAlreadyRegisteredExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.GetIdRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.GetIdResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.GetOpenIdTokenForDeveloperIdentityRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.GetOpenIdTokenForDeveloperIdentityResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.GetOpenIdTokenRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.GetOpenIdTokenResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.ListIdentitiesRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.ListIdentitiesResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.ListIdentityPoolsRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.ListIdentityPoolsResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.LookupDeveloperIdentityRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.LookupDeveloperIdentityResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.MergeDeveloperIdentitiesRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.MergeDeveloperIdentitiesResultJsonUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.NotAuthorizedExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.ResourceConflictExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.UnlinkDeveloperIdentityRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.UnlinkIdentityRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.UpdateIdentityPoolRequestMarshaller;
import com.amazonaws.services.cognitoidentity.model.transform.UpdateIdentityPoolResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;

public class AmazonCognitoIdentityClient
extends AmazonWebServiceClient
implements AmazonCognitoIdentity {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCognitoIdentity.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonCognitoIdentityClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCognitoIdentityClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCognitoIdentityClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, new ClientConfiguration());
    }

    public AmazonCognitoIdentityClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonCognitoIdentityClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(aWSCredentials);
        this.init();
    }

    public AmazonCognitoIdentityClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCognitoIdentityClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCognitoIdentityClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonCognitoIdentityClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = aWSCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new DeveloperUserAlreadyRegisteredExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InternalErrorExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceConflictExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new NotAuthorizedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TooManyRequestsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("cognito-identity.us-east-1.amazonaws.com");
        HandlerChainFactory handlerChainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandlerChain("/com/amazonaws/services/cognitoidentity/request.handlers"));
        this.requestHandler2s.addAll(handlerChainFactory.newRequestHandler2Chain("/com/amazonaws/services/cognitoidentity/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration clientConfiguration) {
        ClientConfiguration clientConfiguration2 = clientConfiguration;
        return clientConfiguration2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkDeveloperIdentity(UnlinkDeveloperIdentityRequest unlinkDeveloperIdentityRequest) {
        Request<UnlinkDeveloperIdentityRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(unlinkDeveloperIdentityRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new UnlinkDeveloperIdentityRequestMarshaller().marshall(unlinkDeveloperIdentityRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler jsonResponseHandler = new JsonResponseHandler(null);
        this.invoke(request, jsonResponseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityPoolResult describeIdentityPool(DescribeIdentityPoolRequest describeIdentityPoolRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIdentityPoolRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeIdentityPoolRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeIdentityPoolRequestMarshaller().marshall(describeIdentityPoolRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeIdentityPoolResultJsonUnmarshaller describeIdentityPoolResultJsonUnmarshaller = new DescribeIdentityPoolResultJsonUnmarshaller();
            JsonResponseHandler<DescribeIdentityPoolResult> jsonResponseHandler = new JsonResponseHandler<DescribeIdentityPoolResult>(describeIdentityPoolResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            DescribeIdentityPoolResult describeIdentityPoolResult = (DescribeIdentityPoolResult)response.getAwsResponse();
            return describeIdentityPoolResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdResult getId(GetIdRequest getIdRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIdRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIdRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIdRequestMarshaller().marshall(getIdRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetIdResultJsonUnmarshaller getIdResultJsonUnmarshaller = new GetIdResultJsonUnmarshaller();
            JsonResponseHandler<GetIdResult> jsonResponseHandler = new JsonResponseHandler<GetIdResult>(getIdResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            GetIdResult getIdResult = (GetIdResult)response.getAwsResponse();
            return getIdResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteIdentityPool(DeleteIdentityPoolRequest deleteIdentityPoolRequest) {
        Request<DeleteIdentityPoolRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deleteIdentityPoolRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeleteIdentityPoolRequestMarshaller().marshall(deleteIdentityPoolRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler jsonResponseHandler = new JsonResponseHandler(null);
        this.invoke(request, jsonResponseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIdentityPoolResult updateIdentityPool(UpdateIdentityPoolRequest updateIdentityPoolRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateIdentityPoolRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateIdentityPoolRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateIdentityPoolRequestMarshaller().marshall(updateIdentityPoolRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateIdentityPoolResultJsonUnmarshaller updateIdentityPoolResultJsonUnmarshaller = new UpdateIdentityPoolResultJsonUnmarshaller();
            JsonResponseHandler<UpdateIdentityPoolResult> jsonResponseHandler = new JsonResponseHandler<UpdateIdentityPoolResult>(updateIdentityPoolResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            UpdateIdentityPoolResult updateIdentityPoolResult = (UpdateIdentityPoolResult)response.getAwsResponse();
            return updateIdentityPoolResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoolsResult listIdentityPools(ListIdentityPoolsRequest listIdentityPoolsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentityPoolsRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentityPoolsRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentityPoolsRequestMarshaller().marshall(listIdentityPoolsRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListIdentityPoolsResultJsonUnmarshaller listIdentityPoolsResultJsonUnmarshaller = new ListIdentityPoolsResultJsonUnmarshaller();
            JsonResponseHandler<ListIdentityPoolsResult> jsonResponseHandler = new JsonResponseHandler<ListIdentityPoolsResult>(listIdentityPoolsResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            ListIdentityPoolsResult listIdentityPoolsResult = (ListIdentityPoolsResult)response.getAwsResponse();
            return listIdentityPoolsResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeDeveloperIdentitiesResult mergeDeveloperIdentities(MergeDeveloperIdentitiesRequest mergeDeveloperIdentitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(mergeDeveloperIdentitiesRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<MergeDeveloperIdentitiesRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new MergeDeveloperIdentitiesRequestMarshaller().marshall(mergeDeveloperIdentitiesRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            MergeDeveloperIdentitiesResultJsonUnmarshaller mergeDeveloperIdentitiesResultJsonUnmarshaller = new MergeDeveloperIdentitiesResultJsonUnmarshaller();
            JsonResponseHandler<MergeDeveloperIdentitiesResult> jsonResponseHandler = new JsonResponseHandler<MergeDeveloperIdentitiesResult>(mergeDeveloperIdentitiesResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            MergeDeveloperIdentitiesResult mergeDeveloperIdentitiesResult = (MergeDeveloperIdentitiesResult)response.getAwsResponse();
            return mergeDeveloperIdentitiesResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpenIdTokenResult getOpenIdToken(GetOpenIdTokenRequest getOpenIdTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOpenIdTokenRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOpenIdTokenRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOpenIdTokenRequestMarshaller().marshall(getOpenIdTokenRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetOpenIdTokenResultJsonUnmarshaller getOpenIdTokenResultJsonUnmarshaller = new GetOpenIdTokenResultJsonUnmarshaller();
            JsonResponseHandler<GetOpenIdTokenResult> jsonResponseHandler = new JsonResponseHandler<GetOpenIdTokenResult>(getOpenIdTokenResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            GetOpenIdTokenResult getOpenIdTokenResult = (GetOpenIdTokenResult)response.getAwsResponse();
            return getOpenIdTokenResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupDeveloperIdentityResult lookupDeveloperIdentity(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(lookupDeveloperIdentityRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LookupDeveloperIdentityRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LookupDeveloperIdentityRequestMarshaller().marshall(lookupDeveloperIdentityRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            LookupDeveloperIdentityResultJsonUnmarshaller lookupDeveloperIdentityResultJsonUnmarshaller = new LookupDeveloperIdentityResultJsonUnmarshaller();
            JsonResponseHandler<LookupDeveloperIdentityResult> jsonResponseHandler = new JsonResponseHandler<LookupDeveloperIdentityResult>(lookupDeveloperIdentityResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            LookupDeveloperIdentityResult lookupDeveloperIdentityResult = (LookupDeveloperIdentityResult)response.getAwsResponse();
            return lookupDeveloperIdentityResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlinkIdentity(UnlinkIdentityRequest unlinkIdentityRequest) {
        Request<UnlinkIdentityRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(unlinkIdentityRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new UnlinkIdentityRequestMarshaller().marshall(unlinkIdentityRequest);
            request.setAWSRequestMetrics(aWSRequestMetrics);
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler jsonResponseHandler = new JsonResponseHandler(null);
        this.invoke(request, jsonResponseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentitiesResult listIdentities(ListIdentitiesRequest listIdentitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIdentitiesRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIdentitiesRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIdentitiesRequestMarshaller().marshall(listIdentitiesRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListIdentitiesResultJsonUnmarshaller listIdentitiesResultJsonUnmarshaller = new ListIdentitiesResultJsonUnmarshaller();
            JsonResponseHandler<ListIdentitiesResult> jsonResponseHandler = new JsonResponseHandler<ListIdentitiesResult>(listIdentitiesResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            ListIdentitiesResult listIdentitiesResult = (ListIdentitiesResult)response.getAwsResponse();
            return listIdentitiesResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpenIdTokenForDeveloperIdentityResult getOpenIdTokenForDeveloperIdentity(GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOpenIdTokenForDeveloperIdentityRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOpenIdTokenForDeveloperIdentityRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOpenIdTokenForDeveloperIdentityRequestMarshaller().marshall(getOpenIdTokenForDeveloperIdentityRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetOpenIdTokenForDeveloperIdentityResultJsonUnmarshaller getOpenIdTokenForDeveloperIdentityResultJsonUnmarshaller = new GetOpenIdTokenForDeveloperIdentityResultJsonUnmarshaller();
            JsonResponseHandler<GetOpenIdTokenForDeveloperIdentityResult> jsonResponseHandler = new JsonResponseHandler<GetOpenIdTokenForDeveloperIdentityResult>(getOpenIdTokenForDeveloperIdentityResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            GetOpenIdTokenForDeveloperIdentityResult getOpenIdTokenForDeveloperIdentityResult = (GetOpenIdTokenForDeveloperIdentityResult)response.getAwsResponse();
            return getOpenIdTokenForDeveloperIdentityResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIdentityPoolResult createIdentityPool(CreateIdentityPoolRequest createIdentityPoolRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createIdentityPoolRequest);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateIdentityPoolRequest> request = null;
        Response response = null;
        try {
            aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateIdentityPoolRequestMarshaller().marshall(createIdentityPoolRequest);
                request.setAWSRequestMetrics(aWSRequestMetrics);
            }
            finally {
                aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateIdentityPoolResultJsonUnmarshaller createIdentityPoolResultJsonUnmarshaller = new CreateIdentityPoolResultJsonUnmarshaller();
            JsonResponseHandler<CreateIdentityPoolResult> jsonResponseHandler = new JsonResponseHandler<CreateIdentityPoolResult>(createIdentityPoolResultJsonUnmarshaller);
            response = this.invoke(request, jsonResponseHandler, executionContext);
            CreateIdentityPoolResult createIdentityPoolResult = (CreateIdentityPoolResult)response.getAwsResponse();
            return createIdentityPoolResult;
        }
        finally {
            this.endClientExecution(aWSRequestMetrics, request, response, true);
        }
    }

    @Override
    public void setEndpoint(String string) {
        super.setEndpoint(string);
    }

    @Override
    public void setEndpoint(String string, String string2, String string3) throws IllegalArgumentException {
        super.setEndpoint(string, string2, string3);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest amazonWebServiceRequest) {
        return this.client.getResponseMetadataForRequest(amazonWebServiceRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> httpResponseHandler, ExecutionContext executionContext) {
        AWSCredentials aWSCredentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics aWSRequestMetrics = executionContext.getAwsRequestMetrics();
        aWSRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            aWSCredentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            aWSRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest amazonWebServiceRequest = request.getOriginalRequest();
        if (amazonWebServiceRequest != null && amazonWebServiceRequest.getRequestCredentials() != null) {
            aWSCredentials = amazonWebServiceRequest.getRequestCredentials();
        }
        executionContext.setCredentials(aWSCredentials);
        JsonErrorResponseHandler jsonErrorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response response = this.client.execute(request, httpResponseHandler, jsonErrorResponseHandler, executionContext);
        return response;
    }
}

