/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.retry.RetryUtils;
import java.io.IOException;
import java.util.Random;

public class PredefinedRetryPolicies {
    public static final int DEFAULT_MAX_ERROR_RETRY = 3;
    public static final RetryPolicy DEFAULT;
    public static final int DYNAMODB_DEFAULT_MAX_ERROR_RETRY = 10;
    public static final RetryPolicy DYNAMODB_DEFAULT;
    public static final RetryPolicy.RetryCondition DEFAULT_RETRY_CONDITION;
    public static final RetryPolicy.BackoffStrategy DEFAULT_BACKOFF_STRATEGY;
    public static final RetryPolicy.BackoffStrategy DYNAMODB_DEFAULT_BACKOFF_STRATEGY;

    public static RetryPolicy getDefaultRetryPolicy() {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DEFAULT_BACKOFF_STRATEGY, 3, true);
    }

    public static RetryPolicy getDynamoDBDefaultRetryPolicy() {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DYNAMODB_DEFAULT_BACKOFF_STRATEGY, 10, true);
    }

    public static RetryPolicy getDefaultRetryPolicyWithCustomMaxRetries(int n) {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DEFAULT_BACKOFF_STRATEGY, n, false);
    }

    public static RetryPolicy getDynamoDBDefaultRetryPolicyWithCustomMaxRetries(int n) {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DYNAMODB_DEFAULT_BACKOFF_STRATEGY, n, false);
    }

    static {
        DEFAULT_RETRY_CONDITION = new SDKDefaultRetryCondition();
        DEFAULT_BACKOFF_STRATEGY = new SDKDefaultBackoffStrategy();
        DYNAMODB_DEFAULT_BACKOFF_STRATEGY = new DynamoDBDefaultBackoffStrategy();
        DEFAULT = PredefinedRetryPolicies.getDefaultRetryPolicy();
        DYNAMODB_DEFAULT = PredefinedRetryPolicies.getDynamoDBDefaultRetryPolicy();
    }

    private static class DynamoDBDefaultBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private static final int SCALE_FACTOR = 25;
        private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;

        private DynamoDBDefaultBackoffStrategy() {
        }

        @Override
        public final long delayBeforeNextRetry(AmazonWebServiceRequest amazonWebServiceRequest, AmazonClientException amazonClientException, int n) {
            if (n <= 0) {
                return 0L;
            }
            long l = (1 << n) * 25;
            l = Math.min(l, 20000L);
            return l;
        }
    }

    private static class SDKDefaultBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private static final int SCALE_FACTOR = 300;
        private static final int THROTTLING_SCALE_FACTOR = 500;
        private static final int THROTTLING_SCALE_FACTOR_RANDOM_RANGE = 125;
        private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
        private final Random random = new Random();

        private SDKDefaultBackoffStrategy() {
        }

        @Override
        public final long delayBeforeNextRetry(AmazonWebServiceRequest amazonWebServiceRequest, AmazonClientException amazonClientException, int n) {
            if (n <= 0) {
                return 0L;
            }
            int n2 = amazonClientException instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)amazonClientException) ? 500 + this.random.nextInt(125) : 300;
            long l = (1 << n) * n2;
            l = Math.min(l, 20000L);
            return l;
        }
    }

    public static class SDKDefaultRetryCondition
    implements RetryPolicy.RetryCondition {
        @Override
        public boolean shouldRetry(AmazonWebServiceRequest amazonWebServiceRequest, AmazonClientException amazonClientException, int n) {
            if (amazonClientException.getCause() instanceof IOException) {
                return true;
            }
            if (amazonClientException instanceof AmazonServiceException) {
                AmazonServiceException amazonServiceException = (AmazonServiceException)amazonClientException;
                if (amazonServiceException.getStatusCode() == 500 || amazonServiceException.getStatusCode() == 503) {
                    return true;
                }
                if (RetryUtils.isThrottlingException(amazonServiceException)) {
                    return true;
                }
                if (RetryUtils.isClockSkewError(amazonServiceException)) {
                    return true;
                }
            }
            return false;
        }
    }
}

