/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public final class Region {
    private static final String DEFAULT_DOMAIN = "amazonaws.com";
    private final String name;
    private final String domain;
    private final Map<String, String> serviceEndpoints = new HashMap<String, String>();
    private final Map<String, Boolean> httpSupport = new HashMap<String, Boolean>();
    private final Map<String, Boolean> httpsSupport = new HashMap<String, Boolean>();

    Region(String string, String string2) {
        this.name = string;
        this.domain = string2 == null ? DEFAULT_DOMAIN : string2;
    }

    public static Region getRegion(Regions regions) {
        return RegionUtils.getRegion(regions.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    Map<String, String> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    Map<String, Boolean> getHttpSupport() {
        return this.httpSupport;
    }

    Map<String, Boolean> getHttpsSupport() {
        return this.httpsSupport;
    }

    public String getServiceEndpoint(String string) {
        return this.serviceEndpoints.get(string);
    }

    public boolean isServiceSupported(String string) {
        return this.serviceEndpoints.containsKey(string);
    }

    public boolean hasHttpsEndpoint(String string) {
        return this.httpsSupport.containsKey(string) && this.httpsSupport.get(string) != false;
    }

    public boolean hasHttpEndpoint(String string) {
        return this.httpSupport.containsKey(string) && this.httpSupport.get(string) != false;
    }

    public <T extends AmazonWebServiceClient> T createClient(Class<T> clazz, AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        try {
            AmazonWebServiceClient amazonWebServiceClient;
            if (aWSCredentialsProvider == null && clientConfiguration == null) {
                Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(new Object[0]);
            } else if (aWSCredentialsProvider == null) {
                Constructor<T> constructor = clazz.getConstructor(ClientConfiguration.class);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(clientConfiguration);
            } else if (clientConfiguration == null) {
                Constructor<T> constructor = clazz.getConstructor(AWSCredentialsProvider.class);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(aWSCredentialsProvider);
            } else {
                Constructor<T> constructor = clazz.getConstructor(AWSCredentialsProvider.class, ClientConfiguration.class);
                amazonWebServiceClient = (AmazonWebServiceClient)constructor.newInstance(aWSCredentialsProvider, clientConfiguration);
            }
            amazonWebServiceClient.setRegion(this);
            return (T)amazonWebServiceClient;
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't instantiate instance of " + clazz, exception);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.getName().equals(region.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

