/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.tz;

import com.amazonaws.org.joda.time.Chronology;
import com.amazonaws.org.joda.time.DateTimeUtils;
import com.amazonaws.org.joda.time.DateTimeZone;
import com.amazonaws.org.joda.time.chrono.ISOChronology;
import com.amazonaws.org.joda.time.tz.CachedDateTimeZone;
import com.amazonaws.org.joda.time.tz.FixedDateTimeZone;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class DateTimeZoneBuilder {
    private final ArrayList<RuleSet> iRuleSets = new ArrayList(10);

    public static DateTimeZone readFrom(InputStream inputStream, String string) throws IOException {
        if (inputStream instanceof DataInput) {
            return DateTimeZoneBuilder.readFrom((DataInput)((Object)inputStream), string);
        }
        return DateTimeZoneBuilder.readFrom(new DataInputStream(inputStream), string);
    }

    public static DateTimeZone readFrom(DataInput dataInput, String string) throws IOException {
        switch (dataInput.readUnsignedByte()) {
            case 70: {
                DateTimeZone dateTimeZone = new FixedDateTimeZone(string, dataInput.readUTF(), (int)DateTimeZoneBuilder.readMillis(dataInput), (int)DateTimeZoneBuilder.readMillis(dataInput));
                if (((DateTimeZone)dateTimeZone).equals(DateTimeZone.UTC)) {
                    dateTimeZone = DateTimeZone.UTC;
                }
                return dateTimeZone;
            }
            case 67: {
                return CachedDateTimeZone.forZone(PrecalculatedZone.readFrom(dataInput, string));
            }
            case 80: {
                return PrecalculatedZone.readFrom(dataInput, string);
            }
        }
        throw new IOException("Invalid encoding");
    }

    static long readMillis(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        switch (n >> 6) {
            default: {
                n = n << 26 >> 26;
                return (long)n * 1800000L;
            }
            case 1: {
                n = n << 26 >> 2;
                n |= dataInput.readUnsignedByte() << 16;
                n |= dataInput.readUnsignedByte() << 8;
                return (long)(n |= dataInput.readUnsignedByte()) * 60000L;
            }
            case 2: {
                long l = (long)n << 58 >> 26;
                l |= (long)(dataInput.readUnsignedByte() << 24);
                l |= (long)(dataInput.readUnsignedByte() << 16);
                l |= (long)(dataInput.readUnsignedByte() << 8);
                return (l |= (long)dataInput.readUnsignedByte()) * 1000L;
            }
            case 3: 
        }
        return dataInput.readLong();
    }

    private static final class PrecalculatedZone
    extends DateTimeZone {
        private final long[] iTransitions;
        private final int[] iWallOffsets;
        private final int[] iStandardOffsets;
        private final String[] iNameKeys;
        private final DSTZone iTailZone;

        static PrecalculatedZone readFrom(DataInput dataInput, String string) throws IOException {
            int n;
            int n2 = dataInput.readUnsignedShort();
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = dataInput.readUTF();
            }
            n = dataInput.readInt();
            long[] lArray = new long[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = DateTimeZoneBuilder.readMillis(dataInput);
                nArray[i] = (int)DateTimeZoneBuilder.readMillis(dataInput);
                nArray2[i] = (int)DateTimeZoneBuilder.readMillis(dataInput);
                try {
                    int n3 = n2 < 256 ? dataInput.readUnsignedByte() : dataInput.readUnsignedShort();
                    stringArray2[i] = stringArray[n3];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IOException("Invalid encoding");
                }
            }
            DSTZone dSTZone = null;
            if (dataInput.readBoolean()) {
                dSTZone = DSTZone.readFrom(dataInput, string);
            }
            return new PrecalculatedZone(string, lArray, nArray, nArray2, stringArray2, dSTZone);
        }

        private PrecalculatedZone(String string, long[] lArray, int[] nArray, int[] nArray2, String[] stringArray, DSTZone dSTZone) {
            super(string);
            this.iTransitions = lArray;
            this.iWallOffsets = nArray;
            this.iStandardOffsets = nArray2;
            this.iNameKeys = stringArray;
            this.iTailZone = dSTZone;
        }

        public String getNameKey(long l) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, l);
            if (n >= 0) {
                return this.iNameKeys[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iNameKeys[n - 1];
                }
                return "UTC";
            }
            if (this.iTailZone == null) {
                return this.iNameKeys[n - 1];
            }
            return this.iTailZone.getNameKey(l);
        }

        public int getOffset(long l) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, l);
            if (n >= 0) {
                return this.iWallOffsets[n];
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                if (n > 0) {
                    return this.iWallOffsets[n - 1];
                }
                return 0;
            }
            if (this.iTailZone == null) {
                return this.iWallOffsets[n - 1];
            }
            return this.iTailZone.getOffset(l);
        }

        public boolean isFixed() {
            return false;
        }

        public long nextTransition(long l) {
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, l);
            int n2 = n = n >= 0 ? n + 1 : ~n;
            if (n < lArray.length) {
                return lArray[n];
            }
            if (this.iTailZone == null) {
                return l;
            }
            long l2 = lArray[lArray.length - 1];
            if (l < l2) {
                l = l2;
            }
            return this.iTailZone.nextTransition(l);
        }

        public long previousTransition(long l) {
            long l2;
            long[] lArray = this.iTransitions;
            int n = Arrays.binarySearch(lArray, l);
            if (n >= 0) {
                if (l > Long.MIN_VALUE) {
                    return l - 1L;
                }
                return l;
            }
            if ((n ^= 0xFFFFFFFF) < lArray.length) {
                long l3;
                if (n > 0 && (l3 = lArray[n - 1]) > Long.MIN_VALUE) {
                    return l3 - 1L;
                }
                return l;
            }
            if (this.iTailZone != null && (l2 = this.iTailZone.previousTransition(l)) < l) {
                return l2;
            }
            l2 = lArray[n - 1];
            if (l2 > Long.MIN_VALUE) {
                return l2 - 1L;
            }
            return l;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PrecalculatedZone) {
                PrecalculatedZone precalculatedZone = (PrecalculatedZone)object;
                return this.getID().equals(precalculatedZone.getID()) && Arrays.equals(this.iTransitions, precalculatedZone.iTransitions) && Arrays.equals(this.iNameKeys, precalculatedZone.iNameKeys) && Arrays.equals(this.iWallOffsets, precalculatedZone.iWallOffsets) && Arrays.equals(this.iStandardOffsets, precalculatedZone.iStandardOffsets) && (this.iTailZone == null ? null == precalculatedZone.iTailZone : this.iTailZone.equals(precalculatedZone.iTailZone));
            }
            return false;
        }
    }

    private static final class DSTZone
    extends DateTimeZone {
        final int iStandardOffset;
        final Recurrence iStartRecurrence;
        final Recurrence iEndRecurrence;

        static DSTZone readFrom(DataInput dataInput, String string) throws IOException {
            return new DSTZone(string, (int)DateTimeZoneBuilder.readMillis(dataInput), Recurrence.readFrom(dataInput), Recurrence.readFrom(dataInput));
        }

        DSTZone(String string, int n, Recurrence recurrence, Recurrence recurrence2) {
            super(string);
            this.iStandardOffset = n;
            this.iStartRecurrence = recurrence;
            this.iEndRecurrence = recurrence2;
        }

        public String getNameKey(long l) {
            return this.findMatchingRecurrence(l).getNameKey();
        }

        public int getOffset(long l) {
            return this.iStandardOffset + this.findMatchingRecurrence(l).getSaveMillis();
        }

        public boolean isFixed() {
            return false;
        }

        public long nextTransition(long l) {
            long l2;
            long l3;
            int n = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l3 = recurrence.next(l, n, recurrence2.getSaveMillis());
                if (l > 0L && l3 < 0L) {
                    l3 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l;
            }
            try {
                l2 = recurrence2.next(l, n, recurrence.getSaveMillis());
                if (l > 0L && l2 < 0L) {
                    l2 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = l;
            }
            return l3 > l2 ? l2 : l3;
        }

        public long previousTransition(long l) {
            long l2;
            long l3;
            ++l;
            int n = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l3 = recurrence.previous(l, n, recurrence2.getSaveMillis());
                if (l < 0L && l3 > 0L) {
                    l3 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l;
            }
            try {
                l2 = recurrence2.previous(l, n, recurrence.getSaveMillis());
                if (l < 0L && l2 > 0L) {
                    l2 = l;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = l;
            }
            return (l3 > l2 ? l3 : l2) - 1L;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DSTZone) {
                DSTZone dSTZone = (DSTZone)object;
                return this.getID().equals(dSTZone.getID()) && this.iStandardOffset == dSTZone.iStandardOffset && this.iStartRecurrence.equals(dSTZone.iStartRecurrence) && this.iEndRecurrence.equals(dSTZone.iEndRecurrence);
            }
            return false;
        }

        private Recurrence findMatchingRecurrence(long l) {
            long l2;
            long l3;
            int n = this.iStandardOffset;
            Recurrence recurrence = this.iStartRecurrence;
            Recurrence recurrence2 = this.iEndRecurrence;
            try {
                l3 = recurrence.next(l, n, recurrence2.getSaveMillis());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l3 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l3 = l;
            }
            try {
                l2 = recurrence2.next(l, n, recurrence.getSaveMillis());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                l2 = l;
            }
            catch (ArithmeticException arithmeticException) {
                l2 = l;
            }
            return l3 > l2 ? recurrence : recurrence2;
        }
    }

    private static final class RuleSet {
        private static final int YEAR_LIMIT;
        private ArrayList<Rule> iRules = new ArrayList(10);
        private int iUpperYear = Integer.MAX_VALUE;

        RuleSet() {
        }

        static {
            long l = DateTimeUtils.currentTimeMillis();
            YEAR_LIMIT = ISOChronology.getInstanceUTC().year().get(l) + 100;
        }
    }

    private static final class Rule {
    }

    private static final class Recurrence {
        final OfYear iOfYear;
        final String iNameKey;
        final int iSaveMillis;

        static Recurrence readFrom(DataInput dataInput) throws IOException {
            return new Recurrence(OfYear.readFrom(dataInput), dataInput.readUTF(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        Recurrence(OfYear ofYear, String string, int n) {
            this.iOfYear = ofYear;
            this.iNameKey = string;
            this.iSaveMillis = n;
        }

        public long next(long l, int n, int n2) {
            return this.iOfYear.next(l, n, n2);
        }

        public long previous(long l, int n, int n2) {
            return this.iOfYear.previous(l, n, n2);
        }

        public String getNameKey() {
            return this.iNameKey;
        }

        public int getSaveMillis() {
            return this.iSaveMillis;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Recurrence) {
                Recurrence recurrence = (Recurrence)object;
                return this.iSaveMillis == recurrence.iSaveMillis && this.iNameKey.equals(recurrence.iNameKey) && this.iOfYear.equals(recurrence.iOfYear);
            }
            return false;
        }
    }

    private static final class OfYear {
        final char iMode;
        final int iMonthOfYear;
        final int iDayOfMonth;
        final int iDayOfWeek;
        final boolean iAdvance;
        final int iMillisOfDay;

        static OfYear readFrom(DataInput dataInput) throws IOException {
            return new OfYear((char)dataInput.readUnsignedByte(), dataInput.readUnsignedByte(), dataInput.readByte(), dataInput.readUnsignedByte(), dataInput.readBoolean(), (int)DateTimeZoneBuilder.readMillis(dataInput));
        }

        OfYear(char c, int n, int n2, int n3, boolean bl, int n4) {
            if (c != 'u' && c != 'w' && c != 's') {
                throw new IllegalArgumentException("Unknown mode: " + c);
            }
            this.iMode = c;
            this.iMonthOfYear = n;
            this.iDayOfMonth = n2;
            this.iDayOfWeek = n3;
            this.iAdvance = bl;
            this.iMillisOfDay = n4;
        }

        public long next(long l, int n, int n2) {
            int n3 = this.iMode == 'w' ? n + n2 : (this.iMode == 's' ? n : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).monthOfYear().set(l += (long)n3, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, this.iMillisOfDay);
            l2 = this.setDayOfMonthNext(iSOChronology, l2);
            if (this.iDayOfWeek == 0) {
                if (l2 <= l) {
                    l2 = ((Chronology)iSOChronology).year().add(l2, 1);
                    l2 = this.setDayOfMonthNext(iSOChronology, l2);
                }
            } else if ((l2 = this.setDayOfWeek(iSOChronology, l2)) <= l) {
                l2 = ((Chronology)iSOChronology).year().add(l2, 1);
                l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
                l2 = this.setDayOfMonthNext(iSOChronology, l2);
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            return l2 - (long)n3;
        }

        public long previous(long l, int n, int n2) {
            int n3 = this.iMode == 'w' ? n + n2 : (this.iMode == 's' ? n : 0);
            ISOChronology iSOChronology = ISOChronology.getInstanceUTC();
            long l2 = ((Chronology)iSOChronology).monthOfYear().set(l += (long)n3, this.iMonthOfYear);
            l2 = ((Chronology)iSOChronology).millisOfDay().set(l2, 0);
            l2 = ((Chronology)iSOChronology).millisOfDay().add(l2, this.iMillisOfDay);
            l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
            if (this.iDayOfWeek == 0) {
                if (l2 >= l) {
                    l2 = ((Chronology)iSOChronology).year().add(l2, -1);
                    l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
                }
            } else if ((l2 = this.setDayOfWeek(iSOChronology, l2)) >= l) {
                l2 = ((Chronology)iSOChronology).year().add(l2, -1);
                l2 = ((Chronology)iSOChronology).monthOfYear().set(l2, this.iMonthOfYear);
                l2 = this.setDayOfMonthPrevious(iSOChronology, l2);
                l2 = this.setDayOfWeek(iSOChronology, l2);
            }
            return l2 - (long)n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof OfYear) {
                OfYear ofYear = (OfYear)object;
                return this.iMode == ofYear.iMode && this.iMonthOfYear == ofYear.iMonthOfYear && this.iDayOfMonth == ofYear.iDayOfMonth && this.iDayOfWeek == ofYear.iDayOfWeek && this.iAdvance == ofYear.iAdvance && this.iMillisOfDay == ofYear.iMillisOfDay;
            }
            return false;
        }

        private long setDayOfMonthNext(Chronology chronology, long l) {
            try {
                l = this.setDayOfMonth(chronology, l);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l)) {
                        l = chronology.year().add(l, 1);
                    }
                    l = this.setDayOfMonth(chronology, l);
                }
                throw illegalArgumentException;
            }
            return l;
        }

        private long setDayOfMonthPrevious(Chronology chronology, long l) {
            try {
                l = this.setDayOfMonth(chronology, l);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.iMonthOfYear == 2 && this.iDayOfMonth == 29) {
                    while (!chronology.year().isLeap(l)) {
                        l = chronology.year().add(l, -1);
                    }
                    l = this.setDayOfMonth(chronology, l);
                }
                throw illegalArgumentException;
            }
            return l;
        }

        private long setDayOfMonth(Chronology chronology, long l) {
            if (this.iDayOfMonth >= 0) {
                l = chronology.dayOfMonth().set(l, this.iDayOfMonth);
            } else {
                l = chronology.dayOfMonth().set(l, 1);
                l = chronology.monthOfYear().add(l, 1);
                l = chronology.dayOfMonth().add(l, this.iDayOfMonth);
            }
            return l;
        }

        private long setDayOfWeek(Chronology chronology, long l) {
            int n = chronology.dayOfWeek().get(l);
            int n2 = this.iDayOfWeek - n;
            if (n2 != 0) {
                if (this.iAdvance) {
                    if (n2 < 0) {
                        n2 += 7;
                    }
                } else if (n2 > 0) {
                    n2 -= 7;
                }
                l = chronology.dayOfWeek().add(l, n2);
            }
            return l;
        }
    }
}

