/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream;

import com.amazonaws.javax.xml.stream.PropertyManager;
import com.amazonaws.javax.xml.stream.XMLEntityHandler;
import com.amazonaws.javax.xml.stream.XMLEntityStorage;
import com.amazonaws.javax.xml.stream.XMLScanner;
import com.amazonaws.javax.xml.stream.dtd.DTDGrammarUtil;
import com.amazonaws.javax.xml.stream.xerces.util.XMLAttributesIteratorImpl;
import com.amazonaws.javax.xml.stream.xerces.util.XMLChar;
import com.amazonaws.javax.xml.stream.xerces.util.XMLStringBuffer;
import com.amazonaws.javax.xml.stream.xerces.util.XMLSymbols;
import com.amazonaws.javax.xml.stream.xerces.xni.QName;
import com.amazonaws.javax.xml.stream.xerces.xni.XMLAttributes;
import com.amazonaws.javax.xml.stream.xerces.xni.XMLDocumentHandler;
import com.amazonaws.javax.xml.stream.xerces.xni.XMLResourceIdentifier;
import com.amazonaws.javax.xml.stream.xerces.xni.XMLString;
import com.amazonaws.javax.xml.stream.xerces.xni.XNIException;
import com.amazonaws.javax.xml.stream.xerces.xni.parser.XMLInputSource;
import java.io.EOFException;
import java.io.IOException;

public class XMLDocumentFragmentScannerImpl
extends XMLScanner
implements XMLEntityHandler {
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/validation", "http://apache.org/xml/features/scanner/notify-builtin-refs", "http://apache.org/xml/features/scanner/notify-char-refs"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, null, Boolean.FALSE, Boolean.FALSE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-manager"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null};
    protected static final char[] cdata = new char[]{'[', 'C', 'D', 'A', 'T', 'A', '['};
    protected static final char[] xmlDecl = new char[]{'<', '?', 'x', 'm', 'l'};
    protected static final char[] endTag = new char[]{'<', '/'};
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLEntityStorage fEntityStore;
    protected int[] fEntityStack = new int[4];
    protected int fMarkupDepth;
    protected boolean fEmptyElement;
    protected int fScannerState;
    protected boolean fInScanContent = false;
    protected boolean fLastSectionWasCData = false;
    protected boolean fLastSectionWasEntityReference = false;
    protected boolean fLastSectionWasCharacterData = false;
    protected boolean fHasExternalDTD;
    protected boolean fStandaloneSet;
    protected boolean fStandalone;
    protected QName fCurrentElement;
    protected ElementStack fElementStack = new ElementStack();
    protected ElementStack2 fElementStack2 = new ElementStack2();
    protected String fPITarget;
    protected XMLString fPIData = new XMLString();
    protected boolean fNamespaces;
    protected boolean fNotifyBuiltInRefs = false;
    protected boolean fReplaceEntityReferences = true;
    protected boolean fSupportExternalEntities = false;
    protected boolean fReportCdataEvent = false;
    protected boolean fIsCoalesce = false;
    protected String fDeclaredEncoding = null;
    protected boolean fDisallowDoctype = false;
    protected Driver fDriver;
    protected Driver fContentDriver = this.createContentDriver();
    protected QName fElementQName = new QName();
    protected QName fAttributeQName = new QName();
    protected XMLAttributesIteratorImpl fAttributes = new XMLAttributesIteratorImpl();
    protected XMLString fTempString = new XMLString();
    protected XMLString fTempString2 = new XMLString();
    private String[] fStrings = new String[3];
    protected XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    protected XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    protected XMLStringBuffer fContentBuffer = new XMLStringBuffer();
    private final char[] fSingleChar = new char[1];
    private String fCurrentEntityName = null;
    protected boolean fScanToEnd = false;
    protected DTDGrammarUtil dtdGrammarUtil = null;
    protected boolean fAddDefaultAttr = false;
    protected boolean foundBuiltInRefs = false;
    String[] fElementArray = new String[200];
    short fLastPointerLocation = 0;
    short fElementPointer = 0;
    short[][] fPointerInfo = new short[5][4];
    protected boolean fShouldSkip = false;
    protected boolean fAdd = false;
    protected boolean fSkip = false;
    boolean fUsebuffer;

    public void setInputSource(XMLInputSource xMLInputSource) throws IOException {
        this.fEntityManager.setEntityHandler(this);
        this.fEntityManager.startEntity("$fragment$", xMLInputSource, false, true);
    }

    public int next() throws IOException, XNIException {
        return this.fDriver.next();
    }

    public void reset(PropertyManager propertyManager) {
        Boolean bl;
        super.reset(propertyManager);
        this.fNamespaces = false;
        this.fNotifyBuiltInRefs = false;
        this.fMarkupDepth = 0;
        this.fCurrentElement = null;
        this.fShouldSkip = false;
        this.fAdd = false;
        this.fSkip = false;
        this.fElementStack.clear();
        this.fHasExternalDTD = false;
        this.fStandaloneSet = false;
        this.fStandalone = false;
        Boolean bl2 = (Boolean)propertyManager.getProperty("com.amazonaws.javax.xml.stream.isReplacingEntityReferences");
        this.fReplaceEntityReferences = bl2;
        bl2 = (Boolean)propertyManager.getProperty("com.amazonaws.javax.xml.stream.isSupportingExternalEntities");
        this.fSupportExternalEntities = bl2;
        Boolean bl3 = (Boolean)propertyManager.getProperty("http://java.sun.com/xml/stream/properties/report-cdata-event");
        if (bl3 != null) {
            this.fReportCdataEvent = bl3;
        }
        if ((bl = (Boolean)propertyManager.getProperty("com.amazonaws.javax.xml.stream.isCoalescing")) != null) {
            this.fIsCoalesce = bl;
        }
        this.fReportCdataEvent = this.fIsCoalesce ? false : this.fReportCdataEvent;
        this.fReplaceEntityReferences = this.fIsCoalesce ? true : this.fReplaceEntityReferences;
        this.fEntityStore = this.fEntityManager.getEntityStore();
    }

    public void startEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2) throws XNIException {
        if (this.fEntityDepth == this.fEntityStack.length) {
            int[] nArray = new int[this.fEntityStack.length * 2];
            System.arraycopy(this.fEntityStack, 0, nArray, 0, this.fEntityStack.length);
            this.fEntityStack = nArray;
        }
        this.fEntityStack[this.fEntityDepth] = this.fMarkupDepth;
        super.startEntity(string, xMLResourceIdentifier, string2);
        if (this.fStandalone && this.fEntityStore.isEntityDeclInExternalSubset(string)) {
            this.reportFatalError("MSG_REFERENCE_TO_EXTERNALLY_DECLARED_ENTITY_WHEN_STANDALONE", new Object[]{string});
        }
        if (this.fDocumentHandler != null && !this.fScanningAttribute && !string.equals("[xml]")) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, null);
        }
    }

    public void endEntity(String string) throws IOException, XNIException {
        super.endEntity(string);
        if (this.fMarkupDepth != this.fEntityStack[this.fEntityDepth]) {
            this.reportFatalError("MarkupEntityMismatch", null);
        }
        if (this.fDocumentHandler != null && !this.fScanningAttribute && !string.equals("[xml]")) {
            this.fDocumentHandler.endGeneralEntity(string, null);
        }
    }

    protected Driver createContentDriver() {
        return new FragmentContentDriver();
    }

    protected void scanXMLDeclOrTextDecl(boolean bl) throws IOException, XNIException {
        super.scanXMLDeclOrTextDecl(bl, this.fStrings);
        --this.fMarkupDepth;
        String string = this.fStrings[0];
        String string2 = this.fStrings[1];
        String string3 = this.fStrings[2];
        this.fDeclaredEncoding = string2;
        this.fStandaloneSet = string3 != null;
        this.fStandalone = this.fStandaloneSet && string3.equals("yes");
        this.fEntityManager.setStandalone(this.fStandalone);
        if (this.fDocumentHandler != null) {
            if (bl) {
                this.fDocumentHandler.textDecl(string, string2, null);
            } else {
                this.fDocumentHandler.xmlDecl(string, string2, string3, null);
            }
        }
        if (string != null) {
            this.fEntityScanner.setVersion(string);
        }
        if (string2 != null) {
            this.fEntityScanner.setEncoding(string2);
        }
    }

    public String getPITarget() {
        return this.fPITarget;
    }

    public XMLStringBuffer getPIData() {
        return this.fContentBuffer;
    }

    public XMLString getCharacterData() {
        if (this.fUsebuffer) {
            return this.fContentBuffer;
        }
        return this.fTempString;
    }

    protected void scanPIData(String target, XMLStringBuffer data) throws IOException, XNIException {
        super.scanPIData(target, data);
        this.fPITarget = target;
        --this.fMarkupDepth;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(target, data, null);
        }
    }

    protected void scanComment() throws IOException, XNIException {
        this.fContentBuffer.clear();
        this.scanComment(this.fContentBuffer);
        this.fUsebuffer = true;
        --this.fMarkupDepth;
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(this.fContentBuffer, null);
        }
    }

    boolean skipQElement(QName name) throws IOException {
        int c = this.fEntityScanner.getChar(name.characters.length);
        if (XMLChar.isName(c)) {
            return false;
        }
        return this.fEntityScanner.skipString(name.characters);
    }

    protected boolean scanStartElement() throws IOException, XNIException {
        Object object;
        if (this.fShouldSkip && !this.fAdd) {
            object = this.fElementStack2.getNext();
            this.fShouldSkip = this.skipQElement((QName)object);
        }
        this.fElementQName = this.fAdd ? this.fElementStack2.nextElement() : this.fElementStack.nextElement();
        this.fCurrentElement = this.fElementQName;
        if (!this.fShouldSkip || this.fAdd) {
            if (this.fNamespaces) {
                this.fEntityScanner.scanQName(this.fElementQName);
            } else {
                object = this.fEntityScanner.scanName();
                this.fElementQName.setValues(null, (String)object, (String)object, null);
                this.fElementQName.characters = this.fEntityScanner.scannedName;
            }
        }
        if (this.fAdd) {
            this.fElementStack2.matchElement(this.fElementQName);
        }
        object = this.fElementQName.rawname;
        boolean bl = false;
        this.fAttributes.removeAllAttributes();
        while (true) {
            boolean bl2 = this.fEntityScanner.skipSpaces();
            int n = this.fEntityScanner.peekChar();
            if (n == 62) {
                this.fEntityScanner.scanChar();
                break;
            }
            if (n == 47) {
                this.fEntityScanner.scanChar();
                if (!this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("ElementUnterminated", new Object[]{object});
                }
                bl = true;
                break;
            }
            if (!XMLDocumentFragmentScannerImpl.isValidNameStartChar(n) || !bl2) {
                this.reportFatalError("ElementUnterminated", new Object[]{object});
            }
            this.scanAttribute(this.fAttributes);
        }
        if (bl) {
            --this.fMarkupDepth;
            if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
                this.reportFatalError("ElementEntityMismatch", new Object[]{this.fCurrentElement.rawname});
            }
            if (this.fDocumentHandler != null) {
                // empty if block
            }
            this.fElementStack.popElement();
        } else if (this.fDocumentHandler != null) {
            // empty if block
        }
        return bl;
    }

    public XMLAttributesIteratorImpl getAttributeIterator() {
        if (this.dtdGrammarUtil != null && this.fAddDefaultAttr) {
            this.dtdGrammarUtil.addDTDDefaultAttrs(this.fElementQName, this.fAttributes);
            this.fAddDefaultAttr = false;
        }
        return this.fAttributes;
    }

    public boolean isStandAlone() {
        return this.fStandalone;
    }

    protected void scanAttribute(XMLAttributes xMLAttributes) throws IOException, XNIException {
        if (this.fNamespaces) {
            this.fEntityScanner.scanQName(this.fAttributeQName);
        } else {
            String string = this.fEntityScanner.scanName();
            this.fAttributeQName.setValues(null, string, string, null);
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(61)) {
            this.reportFatalError("EqRequiredInAttribute", new Object[]{this.fAttributeQName.rawname});
        }
        this.fEntityScanner.skipSpaces();
        int n = xMLAttributes.getLength();
        xMLAttributes.addAttribute(this.fAttributeQName, XMLSymbols.fCDATASymbol, null);
        if (n == xMLAttributes.getLength()) {
            this.reportFatalError("AttributeNotUnique", new Object[]{this.fCurrentElement.rawname, this.fAttributeQName.rawname});
        }
        boolean bl = this.fHasExternalDTD && !this.fStandalone;
        this.scanAttributeValue(this.fTempString, this.fTempString2, this.fAttributeQName.rawname, xMLAttributes, n, bl);
        xMLAttributes.setValue(n, this.fTempString.toString());
        xMLAttributes.setSpecified(n, true);
    }

    protected int scanContent(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        this.fTempString.length = 0;
        int n = this.fEntityScanner.scanContent(this.fTempString);
        xMLStringBuffer.append(this.fTempString);
        this.fTempString.length = 0;
        if (n == 13) {
            this.fEntityScanner.scanChar();
            xMLStringBuffer.append((char)n);
            n = -1;
        } else if (n == 93) {
            xMLStringBuffer.append((char)this.fEntityScanner.scanChar());
            this.fInScanContent = true;
            if (this.fEntityScanner.skipChar(93)) {
                xMLStringBuffer.append(']');
                while (this.fEntityScanner.skipChar(93)) {
                    xMLStringBuffer.append(']');
                }
                if (this.fEntityScanner.skipChar(62)) {
                    this.reportFatalError("CDEndInContent", null);
                }
            }
            this.fInScanContent = false;
            n = -1;
        }
        if (this.fDocumentHandler != null && xMLStringBuffer.length > 0) {
            this.fDocumentHandler.characters(xMLStringBuffer, null);
        }
        return n;
    }

    protected boolean scanCDATASection(XMLStringBuffer xMLStringBuffer, boolean bl) throws IOException, XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(null);
        }
        if (this.fEntityScanner.scanData("]]>", xMLStringBuffer)) {
            int n = this.fEntityScanner.peekChar();
            if (n != -1 && XMLDocumentFragmentScannerImpl.isInvalidLiteral(n)) {
                if (XMLChar.isHighSurrogate(n)) {
                    this.scanSurrogates(xMLStringBuffer);
                } else {
                    this.reportFatalError("InvalidCharInCDSect", new Object[]{Integer.toString(n, 16)});
                    this.fEntityScanner.scanChar();
                }
            }
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(xMLStringBuffer, null);
            }
        }
        --this.fMarkupDepth;
        if (this.fDocumentHandler != null && xMLStringBuffer.length > 0) {
            this.fDocumentHandler.characters(xMLStringBuffer, null);
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(null);
        }
        return true;
    }

    protected int scanEndElement() throws IOException, XNIException {
        String string = this.fElementStack.popElement().rawname;
        if (!this.fEntityScanner.skipString(string)) {
            this.reportFatalError("ETagRequired", new Object[]{string});
        }
        this.fEntityScanner.skipSpaces();
        if (!this.fEntityScanner.skipChar(62)) {
            this.reportFatalError("ETagUnterminated", new Object[]{string});
        }
        --this.fMarkupDepth;
        --this.fMarkupDepth;
        if (this.fMarkupDepth < this.fEntityStack[this.fEntityDepth - 1]) {
            this.reportFatalError("ElementEntityMismatch", new Object[]{string});
        }
        if (this.fDocumentHandler != null) {
            // empty if block
        }
        return this.fMarkupDepth;
    }

    protected void scanEntityReference(XMLStringBuffer xMLStringBuffer) throws IOException, XNIException {
        String string = this.fEntityScanner.scanName();
        if (string == null) {
            this.reportFatalError("NameRequiredInReference", null);
        }
        if (!this.fEntityScanner.skipChar(59)) {
            this.reportFatalError("SemicolonRequiredInReference", new Object[]{string});
        }
        if (this.fEntityStore.isUnparsedEntity(string)) {
            this.reportFatalError("ReferenceToUnparsedEntity", new Object[]{string});
        }
        --this.fMarkupDepth;
        this.fCurrentEntityName = string;
        if (string == fAmpSymbol) {
            this.handleCharacter('&', fAmpSymbol, xMLStringBuffer);
            this.fScannerState = 41;
            return;
        }
        if (string == fLtSymbol) {
            this.handleCharacter('<', fLtSymbol, xMLStringBuffer);
            this.fScannerState = 41;
            return;
        }
        if (string == fGtSymbol) {
            this.handleCharacter('>', fGtSymbol, xMLStringBuffer);
            this.fScannerState = 41;
            return;
        }
        if (string == fQuotSymbol) {
            this.handleCharacter('\"', fQuotSymbol, xMLStringBuffer);
            this.fScannerState = 41;
            return;
        }
        if (string == fAposSymbol) {
            this.handleCharacter('\'', fAposSymbol, xMLStringBuffer);
            this.fScannerState = 41;
            return;
        }
        if (this.fEntityStore.isExternalEntity(string) && !this.fSupportExternalEntities || !this.fEntityStore.isExternalEntity(string) && !this.fReplaceEntityReferences) {
            this.fScannerState = 28;
            return;
        }
        if (!this.fEntityStore.isDeclaredEntity(string)) {
            if (this.fDisallowDoctype && this.fReplaceEntityReferences) {
                this.reportFatalError("EntityNotDeclared", new Object[]{string});
                return;
            }
            if (this.fHasExternalDTD && !this.fStandalone) {
                if (this.fValidation) {
                    this.fErrorReporter.reportError(this.fEntityScanner, "http://www.w3.org/TR/1998/REC-xml-19980210", "EntityNotDeclared", new Object[]{string}, (short)1);
                }
            } else {
                this.reportFatalError("EntityNotDeclared", new Object[]{string});
            }
        }
        this.fEntityManager.startEntity(string, false);
    }

    private void handleCharacter(char c, String entity, XMLStringBuffer content) throws XNIException {
        this.foundBuiltInRefs = true;
        content.append(c);
        if (this.fDocumentHandler != null) {
            this.fSingleChar[0] = c;
            if (this.fNotifyBuiltInRefs) {
                this.fDocumentHandler.startGeneralEntity(entity, null, null, null);
            }
            this.fTempString.setValues(this.fSingleChar, 0, 1);
            this.fDocumentHandler.characters(this.fTempString, null);
            if (this.fNotifyBuiltInRefs) {
                this.fDocumentHandler.endGeneralEntity(entity, null);
            }
        }
    }

    protected final void setScannerState(int state) {
        this.fScannerState = state;
    }

    protected final void setDriver(Driver driver) {
        this.fDriver = driver;
    }

    protected String getScannerStateName(int n) {
        switch (n) {
            case 24: {
                return "SCANNER_STATE_DOCTYPE";
            }
            case 26: {
                return "SCANNER_STATE_ROOT_ELEMENT";
            }
            case 21: {
                return "SCANNER_STATE_START_OF_MARKUP";
            }
            case 27: {
                return "SCANNER_STATE_COMMENT";
            }
            case 23: {
                return "SCANNER_STATE_PI";
            }
            case 22: {
                return "SCANNER_STATE_CONTENT";
            }
            case 28: {
                return "SCANNER_STATE_REFERENCE";
            }
            case 33: {
                return "SCANNER_STATE_END_OF_INPUT";
            }
            case 34: {
                return "SCANNER_STATE_TERMINATED";
            }
            case 35: {
                return "SCANNER_STATE_CDATA";
            }
            case 36: {
                return "SCANNER_STATE_TEXT_DECL";
            }
            case 29: {
                return "SCANNER_STATE_ATTRIBUTE";
            }
            case 30: {
                return "SCANNER_STATE_ATTRIBUTE_VALUE";
            }
            case 38: {
                return "SCANNER_STATE_START_ELEMENT_TAG";
            }
            case 39: {
                return "SCANNER_STATE_END_ELEMENT_TAG";
            }
            case 37: {
                return "SCANNER_STATE_CHARACTER_DATA";
            }
        }
        return "??? (" + n + ')';
    }

    public String getEntityName() {
        return this.fCurrentEntityName;
    }

    protected class FragmentContentDriver
    implements Driver {
        private boolean fContinueDispatching = true;
        private boolean fScanningForMarkup = true;

        protected FragmentContentDriver() {
        }

        private void startOfMarkup() throws IOException {
            ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
            int ch = XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar();
            switch (ch) {
                case 63: {
                    XMLDocumentFragmentScannerImpl.this.setScannerState(23);
                    XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(ch);
                    break;
                }
                case 33: {
                    XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(ch);
                    if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(45)) {
                        if (!XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(45)) {
                            XMLDocumentFragmentScannerImpl.this.reportFatalError("InvalidCommentStart", null);
                        }
                        XMLDocumentFragmentScannerImpl.this.setScannerState(27);
                        break;
                    }
                    if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipString(cdata)) {
                        XMLDocumentFragmentScannerImpl.this.setScannerState(35);
                        break;
                    }
                    if (this.scanForDoctypeHook()) break;
                    XMLDocumentFragmentScannerImpl.this.reportFatalError("MarkupNotRecognizedInContent", null);
                    break;
                }
                case 47: {
                    XMLDocumentFragmentScannerImpl.this.setScannerState(39);
                    XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(ch);
                    break;
                }
                default: {
                    if (XMLScanner.isValidNameStartChar(ch)) {
                        XMLDocumentFragmentScannerImpl.this.setScannerState(38);
                        break;
                    }
                    XMLDocumentFragmentScannerImpl.this.reportFatalError("MarkupNotRecognizedInContent", null);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public int next() throws IOException, XNIException {
            try {
                switch (XMLDocumentFragmentScannerImpl.this.fScannerState) {
                    case 22: {
                        var1_1 = XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar();
                        if (var1_1 == 60) {
                            XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                            XMLDocumentFragmentScannerImpl.this.setScannerState(21);
                        } else {
                            if (var1_1 == 38) {
                                XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                                XMLDocumentFragmentScannerImpl.this.setScannerState(28);
                                break;
                            }
                            XMLDocumentFragmentScannerImpl.this.setScannerState(37);
                            break;
                        }
                    }
                    case 21: {
                        this.startOfMarkup();
                    }
                }
                if (XMLDocumentFragmentScannerImpl.this.fIsCoalesce) {
                    XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                    if (XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData) {
                        if (XMLDocumentFragmentScannerImpl.this.fScannerState != 35 && XMLDocumentFragmentScannerImpl.this.fScannerState != 28 && XMLDocumentFragmentScannerImpl.this.fScannerState != 37) {
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = false;
                            return 4;
                        }
                    } else if ((XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData || XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference) && XMLDocumentFragmentScannerImpl.this.fScannerState != 35 && XMLDocumentFragmentScannerImpl.this.fScannerState != 28 && XMLDocumentFragmentScannerImpl.this.fScannerState != 37) {
                        XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData = false;
                        XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference = false;
                        return 4;
                    }
                }
                switch (XMLDocumentFragmentScannerImpl.this.fScannerState) {
                    case 7: {
                        return 7;
                    }
                    case 38: {
                        XMLDocumentFragmentScannerImpl.this.fEmptyElement = XMLDocumentFragmentScannerImpl.this.scanStartElement();
                        if (XMLDocumentFragmentScannerImpl.this.fEmptyElement) {
                            XMLDocumentFragmentScannerImpl.this.setScannerState(39);
                        } else {
                            XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        }
                        return 1;
                    }
                    case 37: {
                        v0 = XMLDocumentFragmentScannerImpl.this.fUsebuffer = XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference != false || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData != false || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData != false;
                        if (XMLDocumentFragmentScannerImpl.this.fIsCoalesce && (XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData)) {
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference = false;
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData = false;
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = true;
                            XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                        } else {
                            XMLDocumentFragmentScannerImpl.this.fContentBuffer.clear();
                        }
                        XMLDocumentFragmentScannerImpl.this.fTempString.length = 0;
                        var1_1 = XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanContent(XMLDocumentFragmentScannerImpl.this.fTempString);
                        if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(60)) {
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(47)) {
                                ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                                XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = false;
                                XMLDocumentFragmentScannerImpl.this.setScannerState(39);
                            } else if (XMLChar.isNameStart(XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar())) {
                                ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                                XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = false;
                                XMLDocumentFragmentScannerImpl.this.setScannerState(38);
                            } else {
                                XMLDocumentFragmentScannerImpl.this.setScannerState(21);
                                if (XMLDocumentFragmentScannerImpl.this.fIsCoalesce) {
                                    XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                                    XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = true;
                                    XMLDocumentFragmentScannerImpl.this.fContentBuffer.append(XMLDocumentFragmentScannerImpl.this.fTempString);
                                    XMLDocumentFragmentScannerImpl.this.fTempString.length = 0;
                                    return XMLDocumentFragmentScannerImpl.this.fDriver.next();
                                }
                            }
                            if (XMLDocumentFragmentScannerImpl.this.fUsebuffer) {
                                XMLDocumentFragmentScannerImpl.this.fContentBuffer.append(XMLDocumentFragmentScannerImpl.this.fTempString);
                                XMLDocumentFragmentScannerImpl.this.fTempString.length = 0;
                            }
                            if (XMLDocumentFragmentScannerImpl.this.dtdGrammarUtil != null && XMLDocumentFragmentScannerImpl.this.dtdGrammarUtil.isIgnorableWhiteSpace(XMLDocumentFragmentScannerImpl.this.fContentBuffer)) {
                                return 6;
                            }
                            return 4;
                        }
                        XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                        XMLDocumentFragmentScannerImpl.this.fContentBuffer.append(XMLDocumentFragmentScannerImpl.this.fTempString);
                        XMLDocumentFragmentScannerImpl.this.fTempString.length = 0;
                        if (var1_1 == 13) {
                            XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                            XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                            XMLDocumentFragmentScannerImpl.this.fContentBuffer.append((char)var1_1);
                            var1_1 = -1;
                        } else if (var1_1 == 93) {
                            XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                            XMLDocumentFragmentScannerImpl.this.fContentBuffer.append((char)XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar());
                            XMLDocumentFragmentScannerImpl.this.fInScanContent = true;
                            if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(93)) {
                                XMLDocumentFragmentScannerImpl.this.fContentBuffer.append(']');
                                while (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(93)) {
                                    XMLDocumentFragmentScannerImpl.this.fContentBuffer.append(']');
                                }
                                if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(62)) {
                                    XMLDocumentFragmentScannerImpl.this.reportFatalError("CDEndInContent", null);
                                }
                            }
                            var1_1 = -1;
                            XMLDocumentFragmentScannerImpl.this.fInScanContent = false;
                        }
                        do {
                            if (var1_1 != 60) ** GOTO lbl104
                            XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                            XMLDocumentFragmentScannerImpl.this.setScannerState(21);
                            ** GOTO lbl122
lbl104:
                            // 1 sources

                            if (var1_1 != 38) ** GOTO lbl109
                            XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                            XMLDocumentFragmentScannerImpl.this.setScannerState(28);
                            ** GOTO lbl122
lbl109:
                            // 1 sources

                            if (var1_1 == -1 || !XMLScanner.isInvalidLiteral(var1_1)) ** GOTO lbl119
                            if (XMLChar.isHighSurrogate(var1_1)) {
                                XMLDocumentFragmentScannerImpl.this.scanSurrogates(XMLDocumentFragmentScannerImpl.this.fContentBuffer);
                                XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                            } else {
                                XMLDocumentFragmentScannerImpl.this.reportFatalError("InvalidCharInContent", new Object[]{Integer.toString(var1_1, 16)});
                                XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar();
                            }
                            ** GOTO lbl122
lbl119:
                            // 1 sources

                            var1_1 = XMLDocumentFragmentScannerImpl.this.scanContent(XMLDocumentFragmentScannerImpl.this.fContentBuffer);
                        } while (XMLDocumentFragmentScannerImpl.this.fIsCoalesce);
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
lbl122:
                        // 5 sources

                        if (XMLDocumentFragmentScannerImpl.this.fIsCoalesce) {
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = true;
                            return XMLDocumentFragmentScannerImpl.this.fDriver.next();
                        }
                        if (XMLDocumentFragmentScannerImpl.this.dtdGrammarUtil != null && XMLDocumentFragmentScannerImpl.this.dtdGrammarUtil.isIgnorableWhiteSpace(XMLDocumentFragmentScannerImpl.this.fContentBuffer)) {
                            return 6;
                        }
                        return 4;
                    }
                    case 39: {
                        if (XMLDocumentFragmentScannerImpl.this.fEmptyElement) {
                            XMLDocumentFragmentScannerImpl.this.fEmptyElement = false;
                            XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                            return XMLDocumentFragmentScannerImpl.this.fMarkupDepth == 0 && this.elementDepthIsZeroHook() != false ? 2 : 2;
                        }
                        if (XMLDocumentFragmentScannerImpl.this.scanEndElement() == 0 && this.elementDepthIsZeroHook()) {
                            return 2;
                        }
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        return 2;
                    }
                    case 27: {
                        XMLDocumentFragmentScannerImpl.this.scanComment();
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        return 5;
                    }
                    case 23: {
                        XMLDocumentFragmentScannerImpl.this.fContentBuffer.clear();
                        XMLDocumentFragmentScannerImpl.this.scanPI(XMLDocumentFragmentScannerImpl.this.fContentBuffer);
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        return 3;
                    }
                    case 35: {
                        if (XMLDocumentFragmentScannerImpl.this.fIsCoalesce && (XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData)) {
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData = true;
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference = false;
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = false;
                        } else {
                            XMLDocumentFragmentScannerImpl.this.fContentBuffer.clear();
                        }
                        XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                        XMLDocumentFragmentScannerImpl.this.scanCDATASection(XMLDocumentFragmentScannerImpl.this.fContentBuffer, true);
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        if (XMLDocumentFragmentScannerImpl.this.fIsCoalesce) {
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData = true;
                            return XMLDocumentFragmentScannerImpl.this.fDriver.next();
                        }
                        if (XMLDocumentFragmentScannerImpl.this.fReportCdataEvent) {
                            return 12;
                        }
                        return 4;
                    }
                    case 28: {
                        ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                        XMLDocumentFragmentScannerImpl.this.foundBuiltInRefs = false;
                        if (XMLDocumentFragmentScannerImpl.this.fIsCoalesce && (XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData || XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData)) {
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference = true;
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCData = false;
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasCharacterData = false;
                        } else {
                            XMLDocumentFragmentScannerImpl.this.fContentBuffer.clear();
                        }
                        XMLDocumentFragmentScannerImpl.this.fUsebuffer = true;
                        if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipChar(35)) {
                            XMLDocumentFragmentScannerImpl.this.scanCharReferenceValue(XMLDocumentFragmentScannerImpl.this.fContentBuffer, null);
                            --XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                            if (!XMLDocumentFragmentScannerImpl.this.fIsCoalesce) {
                                XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                                return 4;
                            }
                        } else {
                            XMLDocumentFragmentScannerImpl.this.scanEntityReference(XMLDocumentFragmentScannerImpl.this.fContentBuffer);
                        }
                        if (XMLDocumentFragmentScannerImpl.this.fScannerState == 41 && !XMLDocumentFragmentScannerImpl.this.fIsCoalesce) {
                            XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                            return 4;
                        }
                        if (XMLDocumentFragmentScannerImpl.this.fScannerState == 36) {
                            XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference = true;
                            return XMLDocumentFragmentScannerImpl.this.fDriver.next();
                        }
                        if (XMLDocumentFragmentScannerImpl.this.fScannerState == 28) {
                            XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                            if (!XMLDocumentFragmentScannerImpl.this.fReplaceEntityReferences) {
                                return 9;
                            }
                        }
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        XMLDocumentFragmentScannerImpl.this.fLastSectionWasEntityReference = true;
                        return XMLDocumentFragmentScannerImpl.this.fDriver.next();
                    }
                    case 36: {
                        if (XMLDocumentFragmentScannerImpl.this.fEntityScanner.skipString("<?xml")) {
                            ++XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                            if (XMLScanner.isValidNameChar(XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentFragmentScannerImpl.this.fStringBuffer.clear();
                                XMLDocumentFragmentScannerImpl.this.fStringBuffer.append("xml");
                                if (XMLDocumentFragmentScannerImpl.this.fNamespaces) {
                                    while (XMLScanner.isValidNCName(XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar())) {
                                        XMLDocumentFragmentScannerImpl.this.fStringBuffer.append((char)XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar());
                                    }
                                } else {
                                    while (XMLScanner.isValidNameChar(XMLDocumentFragmentScannerImpl.this.fEntityScanner.peekChar())) {
                                        XMLDocumentFragmentScannerImpl.this.fStringBuffer.append((char)XMLDocumentFragmentScannerImpl.this.fEntityScanner.scanChar());
                                    }
                                }
                                var1_2 = XMLDocumentFragmentScannerImpl.this.fSymbolTable.addSymbol(XMLDocumentFragmentScannerImpl.this.fStringBuffer.ch, XMLDocumentFragmentScannerImpl.this.fStringBuffer.offset, XMLDocumentFragmentScannerImpl.this.fStringBuffer.length);
                                XMLDocumentFragmentScannerImpl.this.fStringBuffer.clear();
                                XMLDocumentFragmentScannerImpl.this.scanPIData(var1_2, XMLDocumentFragmentScannerImpl.this.fStringBuffer);
                            } else {
                                XMLDocumentFragmentScannerImpl.this.scanXMLDeclOrTextDecl(true);
                            }
                        }
                        XMLDocumentFragmentScannerImpl.this.fEntityManager.fCurrentEntity.mayReadChunks = true;
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        return XMLDocumentFragmentScannerImpl.this.fDriver.next();
                    }
                    case 26: {
                        if (this.scanRootElementHook()) {
                            return -1;
                        }
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        break;
                    }
                    case 40: {
                        XMLDocumentFragmentScannerImpl.this.fContentBuffer.clear();
                        XMLDocumentFragmentScannerImpl.this.scanCharReferenceValue(XMLDocumentFragmentScannerImpl.this.fContentBuffer, null);
                        --XMLDocumentFragmentScannerImpl.this.fMarkupDepth;
                        XMLDocumentFragmentScannerImpl.this.setScannerState(22);
                        return 4;
                    }
                    default: {
                        throw new XNIException("Scanner State " + XMLDocumentFragmentScannerImpl.this.fScannerState + " not Recognized ");
                    }
                }
            }
            catch (EOFException var1_3) {
                this.endOfFileHook(var1_3);
                return -1;
            }
            return -1;
        }

        protected boolean scanForDoctypeHook() throws IOException, XNIException {
            return false;
        }

        protected boolean elementDepthIsZeroHook() throws IOException, XNIException {
            return false;
        }

        protected boolean scanRootElementHook() throws IOException, XNIException {
            return false;
        }

        protected void endOfFileHook(EOFException eOFException) throws IOException, XNIException {
            if (XMLDocumentFragmentScannerImpl.this.fMarkupDepth != 0) {
                XMLDocumentFragmentScannerImpl.this.reportFatalError("PrematureEOF", null);
            }
        }
    }

    protected static interface Driver {
        public int next() throws IOException, XNIException;
    }

    protected class ElementStack {
        protected QName[] fElements;
        protected int[] fInt = new int[20];
        protected int fDepth;
        protected int fCount;
        protected int fPosition;
        protected int fMark;
        protected int fLastDepth;

        public ElementStack() {
            this.fElements = new QName[20];
            for (int i = 0; i < this.fElements.length; ++i) {
                this.fElements[i] = new QName();
            }
        }

        public QName getNext() {
            if (this.fPosition == this.fCount) {
                this.fPosition = this.fMark;
            }
            return this.fElements[this.fPosition];
        }

        public void push() {
            this.fInt[++this.fDepth] = this.fPosition++;
        }

        public boolean matchElement(QName element) {
            boolean match = false;
            if (this.fLastDepth > this.fDepth && this.fDepth <= 3) {
                if (element.rawname == this.fElements[this.fDepth - 1].rawname) {
                    XMLDocumentFragmentScannerImpl.this.fAdd = false;
                    this.fPosition = this.fMark = this.fDepth - 1;
                    match = true;
                    --this.fCount;
                } else {
                    XMLDocumentFragmentScannerImpl.this.fAdd = true;
                }
            }
            if (match) {
                ++this.fPosition;
            } else {
                this.fInt[this.fDepth] = this.fCount - 1;
            }
            if (this.fCount == this.fElements.length) {
                XMLDocumentFragmentScannerImpl.this.fSkip = false;
                XMLDocumentFragmentScannerImpl.this.fAdd = false;
                this.reposition();
                return false;
            }
            this.fLastDepth = this.fDepth;
            return match;
        }

        public QName nextElement() {
            if (XMLDocumentFragmentScannerImpl.this.fSkip) {
                ++this.fDepth;
                return this.fElements[this.fCount++];
            }
            if (this.fDepth == this.fElements.length) {
                QName[] array = new QName[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, array, 0, this.fDepth);
                this.fElements = array;
                for (int i = this.fDepth; i < this.fElements.length; ++i) {
                    this.fElements[i] = new QName();
                }
            }
            return this.fElements[this.fDepth++];
        }

        public QName popElement() {
            if (XMLDocumentFragmentScannerImpl.this.fSkip || XMLDocumentFragmentScannerImpl.this.fAdd) {
                return this.fElements[this.fInt[this.fDepth--]];
            }
            return this.fElements[--this.fDepth];
        }

        public void reposition() {
            for (int i = 2; i <= this.fDepth; ++i) {
                this.fElements[i - 1] = this.fElements[this.fInt[i]];
            }
        }

        public void clear() {
            this.fDepth = 0;
            this.fLastDepth = 0;
            this.fCount = 0;
            this.fMark = 1;
            this.fPosition = 1;
        }

        public QName getLastPoppedElement() {
            return this.fElements[this.fDepth];
        }
    }

    protected class ElementStack2 {
        protected QName[] fQName = new QName[20];
        protected int fDepth;
        protected int fCount;
        protected int fPosition;
        protected int fMark;
        protected int fLastDepth;

        public ElementStack2() {
            for (int i = 0; i < this.fQName.length; ++i) {
                this.fQName[i] = new QName();
            }
            this.fPosition = 1;
            this.fMark = 1;
        }

        public boolean matchElement(QName element) {
            boolean match = false;
            if (this.fLastDepth > this.fDepth && this.fDepth <= 2) {
                if (element.rawname == this.fQName[this.fDepth].rawname) {
                    XMLDocumentFragmentScannerImpl.this.fAdd = false;
                    this.fMark = this.fDepth - 1;
                    this.fPosition = this.fMark + 1;
                    match = true;
                    --this.fCount;
                } else {
                    XMLDocumentFragmentScannerImpl.this.fAdd = true;
                }
            }
            this.fLastDepth = this.fDepth++;
            return match;
        }

        public QName nextElement() {
            if (this.fCount == this.fQName.length) {
                XMLDocumentFragmentScannerImpl.this.fShouldSkip = false;
                XMLDocumentFragmentScannerImpl.this.fAdd = false;
                return this.fQName[--this.fCount];
            }
            return this.fQName[this.fCount++];
        }

        public QName getNext() {
            if (this.fPosition == this.fCount) {
                this.fPosition = this.fMark;
            }
            return this.fQName[this.fPosition++];
        }
    }
}

