/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.http.HttpMethodName;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpMethodName methodName;
    private String serviceName;
    private URI endpoint;
    private String resourcePath;
    private InputStream inputStream;
    private AmazonWebServiceRequest originalRequest;

    public HttpRequest(HttpMethodName httpMethodName) {
        this.methodName = httpMethodName;
    }

    public HttpMethodName getMethodName() {
        return this.methodName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI uRI) {
        this.endpoint = uRI;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public void removeHeader(String string) {
        this.headers.remove(string);
    }

    public void addParameter(String string, String string2) {
        this.parameters.put(string, string2);
    }

    public void setParameters(Map<String, String> map) {
        this.parameters = map;
    }

    public HttpRequest withParameter(String string, String string2) {
        this.addParameter(string, string2);
        return this;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String string) {
        this.resourcePath = string;
    }

    public void setContent(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getContent() {
        return this.inputStream;
    }

    public void setOriginalRequest(AmazonWebServiceRequest amazonWebServiceRequest) {
        this.originalRequest = amazonWebServiceRequest;
    }

    public AmazonWebServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getMethodName().toString() + " ");
        stringBuilder.append(this.getEndpoint().toString() + " ");
        stringBuilder.append("/" + (this.getResourcePath() != null ? this.getResourcePath() : "") + " ");
        if (!this.getParameters().isEmpty()) {
            stringBuilder.append("Parameters: (");
            for (String string2 : this.getParameters().keySet()) {
                string = this.getParameters().get(string2);
                stringBuilder.append(string2 + ": " + string + ", ");
            }
            stringBuilder.append(") ");
        }
        if (!this.getHeaders().isEmpty()) {
            stringBuilder.append("Headers: (");
            for (String string2 : this.getHeaders().keySet()) {
                string = this.getHeaders().get(string2);
                stringBuilder.append(string2 + ": " + string + ", ");
            }
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }
}

