/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListenerCallbackExecutor;
import com.amazonaws.internal.SdkFilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressReportingInputStream
extends SdkFilterInputStream {
    private static final int NOTIFICATION_THRESHOLD = 8192;
    private final ProgressListenerCallbackExecutor listenerCallbackExecutor;
    private int unnotifiedByteCount;
    private boolean fireCompletedEvent;

    public ProgressReportingInputStream(InputStream inputStream, ProgressListenerCallbackExecutor progressListenerCallbackExecutor) {
        super(inputStream);
        this.listenerCallbackExecutor = progressListenerCallbackExecutor;
    }

    public void setFireCompletedEvent(boolean bl) {
        this.fireCompletedEvent = bl;
    }

    public boolean getFireCompletedEvent() {
        return this.fireCompletedEvent;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            this.notifyCompleted();
        } else {
            this.notify(1);
        }
        return n;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        ProgressEvent progressEvent = new ProgressEvent(this.unnotifiedByteCount);
        progressEvent.setEventCode(32);
        this.listenerCallbackExecutor.progressChanged(progressEvent);
        this.unnotifiedByteCount = 0;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            this.notifyCompleted();
        }
        if (n3 != -1) {
            this.notify(n3);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (this.unnotifiedByteCount > 0) {
            this.listenerCallbackExecutor.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
        super.close();
    }

    private void notifyCompleted() {
        if (!this.fireCompletedEvent) {
            return;
        }
        ProgressEvent progressEvent = new ProgressEvent(this.unnotifiedByteCount);
        progressEvent.setEventCode(4);
        this.unnotifiedByteCount = 0;
        this.listenerCallbackExecutor.progressChanged(progressEvent);
    }

    private void notify(int n) {
        this.unnotifiedByteCount += n;
        if (this.unnotifiedByteCount >= 8192) {
            this.listenerCallbackExecutor.progressChanged(new ProgressEvent(this.unnotifiedByteCount));
            this.unnotifiedByteCount = 0;
        }
    }
}

