/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.util;

import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;

public class SimpleBeanPropertyDefinition
extends BeanPropertyDefinition {
    protected final AnnotatedMember _member;
    protected final String _name;

    public SimpleBeanPropertyDefinition(AnnotatedMember member) {
        this(member, member.getName());
    }

    public SimpleBeanPropertyDefinition(AnnotatedMember member, String name) {
        this._member = member;
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return false;
    }

    @Override
    public boolean hasGetter() {
        return this.getGetter() != null;
    }

    @Override
    public boolean hasSetter() {
        return this.getSetter() != null;
    }

    @Override
    public boolean hasField() {
        return this._member instanceof AnnotatedField;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._member instanceof AnnotatedParameter;
    }

    @Override
    public AnnotatedMethod getGetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 0) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    @Override
    public AnnotatedMethod getSetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 1) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    @Override
    public AnnotatedField getField() {
        return this._member instanceof AnnotatedField ? (AnnotatedField)this._member : null;
    }

    public AnnotatedParameter getConstructorParameter() {
        return this._member instanceof AnnotatedParameter ? (AnnotatedParameter)this._member : null;
    }

    @Override
    public AnnotatedMember getAccessor() {
        AnnotatedMember acc = this.getGetter();
        if (acc == null) {
            acc = this.getField();
        }
        return acc;
    }

    @Override
    public AnnotatedMember getMutator() {
        AnnotatedMember acc = this.getConstructorParameter();
        if (acc == null && (acc = this.getSetter()) == null) {
            acc = this.getField();
        }
        return acc;
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        return this._member;
    }
}

